/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nlogo.api.Dump;
import org.nlogo.api.File;
import org.nlogo.api.LocalFile;
import org.nlogo.api.Version;
import org.nlogo.util.Exceptions;

public strictfp abstract class AbstractExporter {
    private final String filename;

    protected AbstractExporter(String filename) {
        this.filename = filename;
    }

    protected abstract void export(PrintWriter var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String type, String modelFileName, String extraHeader) throws IOException {
        LocalFile file = new LocalFile(this.filename, ".csv");
        try {
            ((File)file).open(File.Mode.WRITE);
            PrintWriter printWriter = ((File)file).getPrintWriter();
            AbstractExporter.exportHeader(printWriter, type, modelFileName, extraHeader);
            this.export(printWriter);
        }
        finally {
            try {
                ((File)file).close(false);
            }
            catch (IOException ex2) {
                Exceptions.ignore(ex2);
            }
        }
    }

    public static void exportHeader(PrintWriter writer, String type, String modelFileName, String extraHeader) {
        writer.println(Dump.csv.header("export-" + type + " data (" + Version.version() + ")"));
        writer.println(Dump.csv.header(modelFileName));
        if (!extraHeader.equals("")) {
            writer.println(Dump.csv.header(extraHeader));
        }
        Date currentDate = new Date();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss:SSS Z");
        writer.println(Dump.csv.header(dateFormatter.format(currentDate)));
        writer.println();
    }
}

