/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;

public strictfp class DrawingLine3D
implements org.nlogo.api.DrawingLine3D {
    public double x0;
    public double y0;
    public double z0;
    public double x1;
    public double y1;
    public double z1;
    public double width;
    public Object color;
    public double heading;
    public double pitch;

    public double x0() {
        return this.x0;
    }

    public double y0() {
        return this.y0;
    }

    public double z0() {
        return this.z0;
    }

    public double x1() {
        return this.x1;
    }

    public double y1() {
        return this.y1;
    }

    public double z1() {
        return this.z1;
    }

    public double width() {
        return this.width;
    }

    public Object color() {
        return this.color;
    }

    public double heading() {
        return this.heading;
    }

    public double pitch() {
        return this.pitch;
    }

    DrawingLine3D(double x0, double y0, double z0, double x1, double y1, double z1, double width, Object color, World3D world) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.width = width;
        this.color = color;
        this.heading = this.heading(world);
        this.pitch = this.pitch(world);
    }

    public double length() {
        double xdiff = this.x1 - this.x0;
        double ydiff = this.y1 - this.y0;
        double zdiff = this.z1 - this.z0;
        return StrictMath.sqrt(xdiff * xdiff + ydiff * ydiff + zdiff * zdiff);
    }

    private double heading(World3D world) {
        try {
            return world.protractor.towards(this.x0, this.y0, this.x1, this.y1, true);
        }
        catch (AgentException e) {
            return 0.0;
        }
    }

    private double pitch(World3D world) {
        try {
            return world.protractor.towardsPitch(this.x0, this.y0, this.z0, this.x1, this.y1, this.z1, true);
        }
        catch (AgentException e) {
            throw new IllegalStateException(e);
        }
    }
}

