/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp final class HorizCylinder
extends Topology {
    HorizCylinder(World world) {
        super(world);
    }

    double wrapX(double x) throws AgentException {
        double max = (double)this.world.maxPxcor() + 0.5;
        double min = (double)this.world.minPxcor() - 0.5;
        if (x >= max || x < min) {
            throw new AgentException("Cannot move turtle beyond the world's edge.");
        }
        return x;
    }

    double wrapY(double y) {
        return HorizCylinder.wrap(y, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dy2 = y1 > y2 ? y2 + (double)this.world.worldHeight() - y1 : y2 - (double)this.world.worldHeight() - y1;
        dy = StrictMath.abs(dy2) < StrictMath.abs(dy) ? dy2 : dy;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    double towardsWrap(double headingX, double headingY) {
        if ((headingY = HorizCylinder.wrap(headingY, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    Patch getPatchAt(double xc, double yc) throws AgentException {
        if (xc > (double)this.world.maxPxcor() + 0.5 || xc < (double)this.world.minPxcor() - 0.5) {
            return null;
        }
        return this.world.getPatchAt(xc, yc);
    }

    double shortestPathX(double x1, double x2) {
        return x2;
    }

    double shortestPathY(double y1, double y2) {
        double yprime = y1 > y2 ? y2 + (double)this.world.worldHeight() : y2 - (double)this.world.worldHeight();
        if (StrictMath.abs(y2 - y1) > StrictMath.abs(yprime - y1)) {
            y2 = yprime;
        }
        return y2;
    }

    void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        int xx2 = xx * 2;
        int yy2 = yy * 2;
        double[][] scratch = this.world.getPatchScratch();
        double[][] scratch2 = new double[xx][yy];
        int x = 0;
        int y = 0;
        int minx = this.world.minPxcor();
        int miny = this.world.minPycor();
        try {
            for (y = 0; y < yy; ++y) {
                for (x = 0; x < xx; ++x) {
                    scratch[x][y] = (Double)this.world.fastGetPatchAt(x + minx, y + miny).getPatchVariable(vn);
                    scratch2[x][y] = 0.0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)));
        }
        for (y = yy; y < yy2; ++y) {
            for (x = xx; x < xx2; ++x) {
                double diffuseVal = scratch[x - xx][y - yy] / 8.0 * diffuseparam;
                if (x > xx && x < xx2 - 1) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 8.0 * diffuseVal);
                    double[] dArray2 = scratch2[(x - 1) % xx];
                    int n2 = (y - 1) % yy;
                    dArray2[n2] = dArray2[n2] + diffuseVal;
                    double[] dArray3 = scratch2[(x - 1) % xx];
                    int n3 = y % yy;
                    dArray3[n3] = dArray3[n3] + diffuseVal;
                    double[] dArray4 = scratch2[(x - 1) % xx];
                    int n4 = (y + 1) % yy;
                    dArray4[n4] = dArray4[n4] + diffuseVal;
                    double[] dArray5 = scratch2[x % xx];
                    int n5 = (y + 1) % yy;
                    dArray5[n5] = dArray5[n5] + diffuseVal;
                    double[] dArray6 = scratch2[x % xx];
                    int n6 = (y - 1) % yy;
                    dArray6[n6] = dArray6[n6] + diffuseVal;
                    double[] dArray7 = scratch2[(x + 1) % xx];
                    int n7 = (y - 1) % yy;
                    dArray7[n7] = dArray7[n7] + diffuseVal;
                    double[] dArray8 = scratch2[(x + 1) % xx];
                    int n8 = y % yy;
                    dArray8[n8] = dArray8[n8] + diffuseVal;
                    double[] dArray9 = scratch2[(x + 1) % xx];
                    int n9 = (y + 1) % yy;
                    dArray9[n9] = dArray9[n9] + diffuseVal;
                    continue;
                }
                if (x == xx) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 5.0 * diffuseVal);
                    double[] dArray10 = scratch2[x % xx];
                    int n10 = (y + 1) % yy;
                    dArray10[n10] = dArray10[n10] + diffuseVal;
                    double[] dArray11 = scratch2[x % xx];
                    int n11 = (y - 1) % yy;
                    dArray11[n11] = dArray11[n11] + diffuseVal;
                    double[] dArray12 = scratch2[(x + 1) % xx];
                    int n12 = (y - 1) % yy;
                    dArray12[n12] = dArray12[n12] + diffuseVal;
                    double[] dArray13 = scratch2[(x + 1) % xx];
                    int n13 = y % yy;
                    dArray13[n13] = dArray13[n13] + diffuseVal;
                    double[] dArray14 = scratch2[(x + 1) % xx];
                    int n14 = (y + 1) % yy;
                    dArray14[n14] = dArray14[n14] + diffuseVal;
                    continue;
                }
                double[] dArray = scratch2[x - xx];
                int n = y - yy;
                dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 5.0 * diffuseVal);
                double[] dArray15 = scratch2[x % xx];
                int n15 = (y + 1) % yy;
                dArray15[n15] = dArray15[n15] + diffuseVal;
                double[] dArray16 = scratch2[x % xx];
                int n16 = (y - 1) % yy;
                dArray16[n16] = dArray16[n16] + diffuseVal;
                double[] dArray17 = scratch2[(x - 1) % xx];
                int n17 = (y - 1) % yy;
                dArray17[n17] = dArray17[n17] + diffuseVal;
                double[] dArray18 = scratch2[(x - 1) % xx];
                int n18 = y % yy;
                dArray18[n18] = dArray18[n18] + diffuseVal;
                double[] dArray19 = scratch2[(x - 1) % xx];
                int n19 = (y + 1) % yy;
                dArray19[n19] = dArray19[n19] + diffuseVal;
            }
        }
        for (y = 0; y < yy; ++y) {
            for (x = 0; x < xx; ++x) {
                if (scratch2[x][y] == scratch[x][y]) continue;
                this.world.getPatchAtWrap(x + minx, y + miny).setPatchVariable(vn, scratch2[x][y]);
            }
        }
    }

    void diffuse4(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        int xx2 = xx * 2;
        int yy2 = yy * 2;
        double[][] scratch = this.world.getPatchScratch();
        double[][] scratch2 = new double[xx][yy];
        int x = 0;
        int y = 0;
        int minx = this.world.minPxcor();
        int miny = this.world.minPycor();
        try {
            for (y = 0; y < yy; ++y) {
                for (x = 0; x < xx; ++x) {
                    scratch[x][y] = (Double)this.world.fastGetPatchAt(x + minx, y + miny).getPatchVariable(vn);
                    scratch2[x][y] = 0.0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)));
        }
        for (y = yy; y < yy2; ++y) {
            for (x = xx; x < xx2; ++x) {
                double diffuseVal = scratch[x - xx][y - yy] / 4.0 * diffuseparam;
                if (x > 0 && x < xx - 1) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 4.0 * diffuseVal);
                    double[] dArray2 = scratch2[(x - 1) % xx];
                    int n2 = y;
                    dArray2[n2] = dArray2[n2] + diffuseVal;
                    double[] dArray3 = scratch2[x % xx];
                    int n3 = (y + 1) % yy;
                    dArray3[n3] = dArray3[n3] + diffuseVal;
                    double[] dArray4 = scratch2[x % xx];
                    int n4 = (y - 1) % yy;
                    dArray4[n4] = dArray4[n4] + diffuseVal;
                    double[] dArray5 = scratch2[(x + 1) % xx];
                    int n5 = y % yy;
                    dArray5[n5] = dArray5[n5] + diffuseVal;
                    continue;
                }
                if (x == xx) {
                    double[] dArray = scratch2[x - xx];
                    int n = y - yy;
                    dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 3.0 * diffuseVal);
                    double[] dArray6 = scratch2[x % xx];
                    int n6 = (y + 1) % yy;
                    dArray6[n6] = dArray6[n6] + diffuseVal;
                    double[] dArray7 = scratch2[x % xx];
                    int n7 = (y - 1) % yy;
                    dArray7[n7] = dArray7[n7] + diffuseVal;
                    double[] dArray8 = scratch2[(x + 1) % xx];
                    int n8 = y % yy;
                    dArray8[n8] = dArray8[n8] + diffuseVal;
                    continue;
                }
                double[] dArray = scratch2[x - xx];
                int n = y - yy;
                dArray[n] = dArray[n] + (scratch[x - xx][y - yy] - 3.0 * diffuseVal);
                double[] dArray9 = scratch2[x % xx];
                int n9 = (y + 1) % yy;
                dArray9[n9] = dArray9[n9] + diffuseVal;
                double[] dArray10 = scratch2[x % xx];
                int n10 = (y - 1) % yy;
                dArray10[n10] = dArray10[n10] + diffuseVal;
                double[] dArray11 = scratch2[(x - 1) % xx];
                int n11 = y % yy;
                dArray11[n11] = dArray11[n11] + diffuseVal;
            }
        }
        for (y = 0; y < yy; ++y) {
            for (x = 0; x < xx; ++x) {
                if (scratch2[x][y] == scratch[x][y]) continue;
                this.world.getPatchAtWrap(x + minx, y + miny).setPatchVariable(vn, scratch2[x][y]);
            }
        }
    }

    double followOffsetX() {
        return 0.0;
    }

    AgentSet getNeighbors(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            if (patch.pxcor == this.world.minPxcor()) {
                if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
        }
        if (patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
    }

    AgentSet getNeighbors4(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            if (patch.pxcor == this.world.minPxcor()) {
                if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
        }
        if (patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
    }

    Patch getPN(Patch source2) {
        return this.getPatchNorth(source2);
    }

    Patch getPE(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchEast(source2);
    }

    Patch getPS(Patch source2) {
        return this.getPatchSouth(source2);
    }

    Patch getPW(Patch source2) {
        if (source2.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchWest(source2);
    }

    Patch getPNE(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchNorthEast(source2);
    }

    Patch getPSE(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchSouthEast(source2);
    }

    Patch getPSW(Patch source2) {
        if (source2.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchSouthWest(source2);
    }

    Patch getPNW(Patch source2) {
        if (source2.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchNorthWest(source2);
    }
}

