/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class InRadiusOrCone {
    private final World world;

    InRadiusOrCone(World world) {
        this.world = world;
    }

    public List<Agent> inRadius(Agent agent, AgentSet agentSet, double d, boolean bl) {
        double d2;
        double d3;
        double d4;
        Patch patch;
        int n = this.world.worldWidth();
        int n2 = this.world.worldHeight();
        int n3 = this.world.maxPxcor();
        int n4 = this.world.maxPycor();
        int n5 = this.world.minPxcor();
        int n6 = this.world.minPycor();
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            patch = turtle2.getPatchHere();
            d4 = turtle2.xcor();
            d3 = turtle2.ycor();
        } else {
            patch = (Patch)agent;
            d4 = patch.pxcor;
            d3 = patch.pycor;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = (int)StrictMath.ceil(d);
        if (this.world.wrappingAllowedInX()) {
            d2 = (double)n / 2.0;
            if ((double)n11 < d2) {
                n8 = n11;
                n7 = -n11;
            } else {
                n8 = (int)StrictMath.floor(d2);
                n7 = -((int)StrictMath.ceil(d2 - 1.0));
            }
        } else {
            int n12 = n5 - patch.pxcor;
            n7 = StrictMath.abs(n12) < n11 ? n12 : -n11;
            n8 = StrictMath.min(n3 - patch.pxcor, n11);
        }
        if (this.world.wrappingAllowedInY()) {
            d2 = (double)n2 / 2.0;
            if ((double)n11 < d2) {
                n10 = n11;
                n9 = -n11;
            } else {
                n10 = (int)StrictMath.floor(d2);
                n9 = -((int)StrictMath.ceil(d2 - 1.0));
            }
        } else {
            int n13 = n6 - patch.pycor;
            n9 = StrictMath.abs(n13) < n11 ? n13 : -n11;
            n10 = StrictMath.min(n4 - patch.pycor, n11);
        }
        for (int i = n9; i <= n10; ++i) {
            for (int j = n7; j <= n8; ++j) {
                try {
                    Patch patch2 = patch.getPatchAtOffsets(j, i);
                    if (agentSet.type() == Patch.class) {
                        if (!(this.world.protractor.distance(patch2.pxcor, patch2.pycor, d4, d3, bl) <= d) || agentSet != this.world.patches() && !agentSet.contains(patch2)) continue;
                        arrayList.add(patch2);
                        continue;
                    }
                    if (agentSet.type() != Turtle.class || this.world.rootsTable.gridRoot(j * j + i * i) > d + 1.415) continue;
                    for (int k = 0; k < patch2.turtlesHere.size(); ++k) {
                        Turtle turtle3 = patch2.turtlesHere.get(k);
                        if (!(this.world.protractor.distance(turtle3.xcor(), turtle3.ycor(), d4, d3, bl) <= d) || agentSet != this.world.turtles() && (agentSet.printName() == null || agentSet != turtle3.getBreed()) && (agentSet.printName() != null || !agentSet.contains(turtle3))) continue;
                        arrayList.add(turtle3);
                    }
                    continue;
                }
                catch (AgentException agentException) {
                    Exceptions.ignore(agentException);
                }
            }
        }
        return arrayList;
    }

    public List<Agent> inCone(Turtle turtle2, AgentSet agentSet, double d, double d2, boolean bl) {
        double d3;
        int n;
        int n2;
        int n3 = this.world.worldWidth();
        int n4 = this.world.worldHeight();
        int n5 = this.world.maxPxcor();
        int n6 = this.world.maxPycor();
        int n7 = this.world.minPxcor();
        int n8 = this.world.minPycor();
        if (bl) {
            n2 = this.world.wrappingAllowedInX() ? (int)StrictMath.ceil(d / (double)n3) : 0;
            n = this.world.wrappingAllowedInY() ? (int)StrictMath.ceil(d / (double)n4) : 0;
        } else {
            n2 = 0;
            n = 0;
        }
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        Patch patch = turtle2.getPatchHere();
        double d4 = d2 / 2.0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = (int)StrictMath.ceil(d);
        if (this.world.wrappingAllowedInX()) {
            d3 = (double)n3 / 2.0;
            if ((double)n13 < d3) {
                n11 = n13;
                n9 = -n13;
            } else {
                n11 = (int)StrictMath.floor(d3);
                n9 = -((int)StrictMath.ceil(d3 - 1.0));
            }
        } else {
            int n14 = n7 - patch.pxcor;
            n9 = StrictMath.abs(n14) < n13 ? n14 : -n13;
            n11 = StrictMath.min(n5 - patch.pxcor, n13);
        }
        if (this.world.wrappingAllowedInY()) {
            d3 = (double)n4 / 2.0;
            if ((double)n13 < d3) {
                n12 = n13;
                n10 = -n13;
            } else {
                n12 = (int)StrictMath.floor(d3);
                n10 = -((int)StrictMath.ceil(d3 - 1.0));
            }
        } else {
            int n15 = n8 - patch.pycor;
            n10 = StrictMath.abs(n15) < n13 ? n15 : -n13;
            n12 = StrictMath.min(n6 - patch.pycor, n13);
        }
        for (int i = n10; i <= n12; ++i) {
            block1: for (int j = n9; j <= n11; ++j) {
                int n16;
                Patch patch2 = this.world.getPatchAtWrap(patch.pxcor + j, patch.pycor + i);
                if (patch2 == null) continue;
                if (agentSet.type() == Patch.class) {
                    for (n16 = -n2; n16 <= n2; ++n16) {
                        for (int k = -n; k <= n; ++k) {
                            if (agentSet != this.world.patches() && !agentSet.contains(patch2) || !this.isInCone(patch2.pxcor + n3 * n16, patch2.pycor + n4 * k, turtle2.xcor(), turtle2.ycor(), d, d4, turtle2.heading())) continue;
                            arrayList.add(patch2);
                            continue block1;
                        }
                    }
                    continue;
                }
                if (!(this.world.rootsTable.gridRoot(j * j + i * i) <= d + 1.415)) continue;
                block4: for (n16 = 0; n16 < patch2.turtlesHere.size(); ++n16) {
                    Turtle turtle3 = patch2.turtlesHere.get(n16);
                    for (int k = -n2; k <= n2; ++k) {
                        for (int i2 = -n; i2 <= n; ++i2) {
                            if (agentSet != this.world.turtles() && (agentSet.printName() == null || agentSet != turtle3.getBreed()) && (agentSet.printName() != null || !agentSet.contains(turtle3)) || !this.isInCone(turtle3.xcor() + (double)(n3 * k), turtle3.ycor() + (double)(n4 * i2), turtle2.xcor(), turtle2.ycor(), d, d4, turtle2.heading())) continue;
                            arrayList.add(turtle3);
                            continue block4;
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    private boolean isInCone(double x, double y, double cx, double cy, double r, double half, double h) {
        double theta;
        if (x == cx && y == cy) {
            return true;
        }
        if (this.world.protractor.distance(cx, cy, x, y, false) > r) {
            return false;
        }
        try {
            theta = this.world.protractor.towards(cx, cy, x, y, false);
        }
        catch (AgentException e) {
            throw new IllegalStateException(e.toString());
        }
        double diff = StrictMath.abs(theta - h);
        return diff <= half || 360.0 - diff <= half;
    }
}

