/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.InRadiusOrCone;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class InRadiusOrCone3D
extends InRadiusOrCone {
    private final World3D world;

    InRadiusOrCone3D(World3D world) {
        super(world);
        this.world = world;
    }

    @Override
    public List<Agent> inRadius(Agent agent, AgentSet agentSet, double d, boolean bl) {
        double d2;
        double d3;
        double d4;
        double d5;
        Patch3D patch3D;
        int n = this.world.worldWidth();
        int n2 = this.world.worldHeight();
        int n3 = this.world.worldDepth();
        int n4 = this.world.maxPxcor();
        int n5 = this.world.maxPycor();
        int n6 = this.world.minPxcor();
        int n7 = this.world.minPycor();
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            patch3D = (Patch3D)turtle3D.getPatchHere();
            d5 = turtle3D.xcor();
            d4 = turtle3D.ycor();
            d3 = turtle3D.zcor();
        } else {
            patch3D = (Patch3D)agent;
            d5 = patch3D.pxcor;
            d4 = patch3D.pycor;
            d3 = patch3D.pzcor;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = (int)StrictMath.ceil(d);
        if (this.world.wrappingAllowedInX()) {
            d2 = (double)n / 2.0;
            if ((double)n14 < d2) {
                n9 = n14;
                n8 = -n14;
            } else {
                n9 = (int)StrictMath.floor(d2);
                n8 = -((int)StrictMath.ceil(d2 - 1.0));
            }
        } else {
            int n15 = n6 - patch3D.pxcor;
            n8 = StrictMath.abs(n15) < n14 ? n15 : -n14;
            n9 = StrictMath.min(n4 - patch3D.pxcor, n14);
        }
        if (this.world.wrappingAllowedInY()) {
            d2 = (double)n2 / 2.0;
            if ((double)n14 < d2) {
                n11 = n14;
                n10 = -n14;
            } else {
                n11 = (int)StrictMath.floor(d2);
                n10 = -((int)StrictMath.ceil(d2 - 1.0));
            }
        } else {
            int n16 = n7 - patch3D.pycor;
            n10 = StrictMath.abs(n16) < n14 ? n16 : -n14;
            n11 = StrictMath.min(n5 - patch3D.pycor, n14);
        }
        double d6 = (double)n3 / 2.0;
        if ((double)n14 < d6) {
            n13 = n14;
            n12 = -n14;
        } else {
            n13 = (int)StrictMath.floor(d6);
            n12 = -((int)StrictMath.ceil(d6 - 1.0));
        }
        Protractor3D protractor3D = (Protractor3D)this.world.protractor;
        for (int i = n12; i <= n13; ++i) {
            for (int j = n10; j <= n11; ++j) {
                for (int k = n8; k <= n9; ++k) {
                    Patch3D patch3D2 = null;
                    try {
                        patch3D2 = patch3D.getPatchAtOffsets(k, j, i);
                    }
                    catch (AgentException agentException) {
                        throw new IllegalStateException(agentException);
                    }
                    if (agentSet.type() == Patch.class) {
                        if (!(protractor3D.distance(patch3D2.pxcor, patch3D2.pycor, patch3D2.pzcor, d5, d4, d3, bl) <= d) || agentSet != this.world.patches() && !agentSet.contains(patch3D2)) continue;
                        arrayList.add(patch3D2);
                        continue;
                    }
                    if (!(StrictMath.sqrt(k * k + j * j + i * i) <= d + 1.415)) continue;
                    for (int i2 = 0; i2 < patch3D2.turtlesHere.size(); ++i2) {
                        Turtle3D turtle3D = (Turtle3D)patch3D2.turtlesHere.get(i2);
                        if (agentSet != this.world.turtles() && (agentSet.printName() == null || agentSet != turtle3D.getBreed()) && (agentSet.printName() != null || !agentSet.contains(turtle3D)) || !(protractor3D.distance(turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor(), d5, d4, d3, bl) <= d)) continue;
                        arrayList.add(turtle3D);
                    }
                }
            }
        }
        return arrayList;
    }

    @Override
    public List<Agent> inCone(Turtle turtle2, AgentSet agentSet, double d, double d2, boolean bl) {
        double d3;
        int n = this.world.worldWidth();
        int n2 = this.world.worldHeight();
        int n3 = this.world.worldDepth();
        int n4 = this.world.maxPxcor();
        int n5 = this.world.maxPycor();
        int n6 = this.world.minPxcor();
        int n7 = this.world.minPycor();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Turtle3D turtle3D = (Turtle3D)turtle2;
        if (bl) {
            n8 = this.world.wrappingAllowedInX() ? (int)StrictMath.ceil(d / (double)n) : 0;
            n9 = this.world.wrappingAllowedInY() ? (int)StrictMath.ceil(d / (double)n2) : 0;
            n10 = this.world.wrappingAllowedInZ() ? (int)StrictMath.ceil(d / (double)n3) : 0;
        }
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        Patch3D patch3D = (Patch3D)turtle3D.getPatchHere();
        double d4 = d2 / 2.0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = (int)StrictMath.ceil(d);
        if (this.world.wrappingAllowedInX()) {
            d3 = (double)n / 2.0;
            if ((double)n17 < d3) {
                n12 = n17;
                n11 = -n17;
            } else {
                n12 = (int)StrictMath.floor(d3);
                n11 = -((int)StrictMath.ceil(d3 - 1.0));
            }
        } else {
            int n18 = n6 - patch3D.pxcor;
            n11 = StrictMath.abs(n18) < n17 ? n18 : -n17;
            n12 = StrictMath.min(n4 - patch3D.pxcor, n17);
        }
        if (this.world.wrappingAllowedInY()) {
            d3 = (double)n2 / 2.0;
            if ((double)n17 < d3) {
                n14 = n17;
                n13 = -n17;
            } else {
                n14 = (int)StrictMath.floor(d3);
                n13 = -((int)StrictMath.ceil(d3 - 1.0));
            }
        } else {
            int n19 = n7 - patch3D.pycor;
            n13 = StrictMath.abs(n19) < n17 ? n19 : -n17;
            n14 = StrictMath.min(n5 - patch3D.pycor, n17);
        }
        double d5 = (double)n3 / 2.0;
        if ((double)n17 < d5) {
            n16 = n17;
            n15 = -n17;
        } else {
            n16 = (int)StrictMath.floor(d5);
            n15 = -((int)StrictMath.ceil(d5 - 1.0));
        }
        for (int i = n15; i <= n16; ++i) {
            for (int j = n13; j <= n14; ++j) {
                block2: for (int k = n11; k <= n12; ++k) {
                    int n20;
                    int n21;
                    Patch3D patch3D2 = (Patch3D)this.world.getPatchAtWrap(patch3D.pxcor + k, patch3D.pycor + j, patch3D.pzcor + i);
                    if (patch3D2 == null) continue;
                    if (agentSet.type() == Patch.class) {
                        for (n21 = -n8; n21 <= n8; ++n21) {
                            for (int i2 = -n9; i2 <= n9; ++i2) {
                                for (n20 = -n10; n20 <= n10; ++n20) {
                                    if (agentSet != this.world.patches() && !agentSet.contains(patch3D2) || !this.isInCone(patch3D2.pxcor + n * n21, patch3D2.pycor + n2 * i2, patch3D2.pzcor + n3 * n20, turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor(), d, d4, turtle3D.heading(), turtle3D.pitch())) continue;
                                    arrayList.add(patch3D2);
                                    continue block2;
                                }
                            }
                        }
                        continue;
                    }
                    if (!(StrictMath.sqrt(k * k + j * j + i * i) <= d + 1.415)) continue;
                    block6: for (n21 = 0; n21 < patch3D2.turtlesHere.size(); ++n21) {
                        Turtle3D turtle3D2 = (Turtle3D)patch3D2.turtlesHere.get(n21);
                        for (n20 = -n8; n20 <= n8; ++n20) {
                            for (int i3 = -n9; i3 <= n9; ++i3) {
                                for (int i4 = -n10; i4 <= n10; ++i4) {
                                    if (agentSet != this.world.turtles() && (agentSet.printName() == null || agentSet != turtle3D2.getBreed()) && (agentSet.printName() != null || !agentSet.contains(turtle3D2)) || !this.isInCone(turtle3D2.xcor() + (double)(n * n20), turtle3D2.ycor() + (double)(n2 * i3), turtle3D2.zcor() + (double)(n3 * i4), turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor(), d, d4, turtle3D.heading(), turtle3D.pitch())) continue;
                                    arrayList.add(turtle3D2);
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    private boolean isInCone(double x, double y, double z, double cx, double cy, double cz, double r, double half, double h, double p) {
        double thetaP;
        double thetaH;
        Protractor3D protractor = (Protractor3D)this.world.protractor;
        if (x == cx && y == cy && z == cz) {
            return true;
        }
        if (protractor.distance(cx, cy, cz, x, y, z, false) > r) {
            return false;
        }
        try {
            thetaH = protractor.towards(cx, cy, x, y, false);
        }
        catch (AgentException e) {
            thetaH = 0.0;
        }
        try {
            thetaP = protractor.towardsPitch(cx, cy, cz, x, y, z, false);
        }
        catch (AgentException e) {
            throw new IllegalStateException(e.toString());
        }
        double diffH = StrictMath.abs(thetaH - h);
        double diffP = StrictMath.abs(thetaP - p);
        return (diffH <= half || 360.0 - diffH <= half) && (diffP <= half || 360.0 - diffP <= half);
    }
}

