/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.Perspective;
import org.nlogo.api.Vect;

public strictfp final class Observer3D
extends Observer
implements Agent3D {
    private Vect forward;
    private Vect right;

    public Observer3D(World world) {
        super(world);
    }

    public void home() {
        super.home();
        World3D w = (World3D)this.world;
        double zOff = (double)w.minPzcor() + (double)(w.maxPzcor() - w.minPzcor()) / 2.0;
        this.ozcor = zOff + (double)(StrictMath.max(this.world.worldWidth(), StrictMath.max(this.world.worldHeight(), w.worldDepth())) * 2);
        this.rotationPoint = new Vect(this.oxcor, this.oycor, zOff);
        this.right = new Vect(1.0, 0.0, 0.0);
        this.forward = new Vect(0.0, 0.0, 1.0);
    }

    public boolean updatePosition() {
        boolean changed = false;
        if (this.perspective == Perspective.OBSERVE) {
            return false;
        }
        if (this.perspective == Perspective.WATCH) {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.face(this.targetAgent);
        } else {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            Turtle3D turtle2 = (Turtle3D)this.targetAgent;
            this.oxyandzcor(turtle2.xcor(), turtle2.ycor(), turtle2.zcor());
            this.heading(turtle2.heading());
            this.pitch(turtle2.pitch());
            this.roll(turtle2.roll());
        }
        return changed;
    }

    public double followOffsetZ() {
        if (this.perspective == Perspective.FOLLOW || this.perspective == Perspective.RIDE) {
            World3D w = (World3D)this.world;
            return this.ozcor - (double)(w.minPzcor() + w.maxPzcor()) / 2.0;
        }
        return 0.0;
    }

    public void face(double x, double y, double z) {
        try {
            this.heading(this.world.protractor.towards(this, x, y, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor.towardsPitch(this, x, y, z, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(x, y, z);
        Vect[] v = Vect.toVectors(this.heading, this.pitch, this.roll);
        this.forward = v[0];
        this.right = v[1];
    }

    public void moveto(Agent otherAgent) {
        if (otherAgent instanceof Turtle) {
            Turtle3D t = (Turtle3D)otherAgent;
            this.oxyandzcor(t.xcor(), t.ycor(), t.zcor());
        } else {
            Patch3D p = (Patch3D)otherAgent;
            this.oxyandzcor(p.pxcor, p.pycor, p.pzcor);
        }
        this.face(this.rotationPoint.x(), this.rotationPoint.y(), this.rotationPoint.z());
    }

    public Patch3D getPatchAtOffsets(double dx, double dy, double dz) throws AgentException {
        return ((World3D)this.world).getPatchAt(dx, dy, dz);
    }

    public void setRotationPoint(org.nlogo.api.Agent agent) {
        if (agent instanceof Turtle) {
            Turtle3D t = (Turtle3D)agent;
            this.setRotationPoint(t.xcor(), t.ycor(), t.zcor());
        } else {
            Patch3D p = (Patch3D)agent;
            this.setRotationPoint(p.pxcor(), p.pycor(), p.pzcor());
        }
    }
}

