/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoList;

public strictfp final class Patch3D
extends Patch
implements Agent3D,
org.nlogo.api.Patch3D {
    public final int pzcor;
    public AgentSet patchNeighbors6;

    public int pzcor() {
        return this.pzcor;
    }

    void topologyChanged() {
        super.topologyChanged();
        this.patchNeighbors6 = null;
    }

    Patch3D(World world, int id, int pxcor, int pycor, int pzcor, int numVariables) {
        super(world, pxcor, pycor);
        this.id = id;
        this.pzcor = pzcor;
        this.variables = new Object[numVariables];
        block7: for (int i = 0; i < numVariables; ++i) {
            switch (i) {
                case 0: {
                    this.variables[i] = (double)pxcor;
                    continue block7;
                }
                case 1: {
                    this.variables[i] = (double)pycor;
                    continue block7;
                }
                case 2: {
                    this.variables[i] = (double)pzcor;
                    continue block7;
                }
                case 4: {
                    this.variables[i] = "";
                    continue block7;
                }
                case 5: {
                    this.variables[i] = Color.BOXED_WHITE;
                    continue block7;
                }
                default: {
                    this.variables[i] = World.ZERO;
                }
            }
        }
        this.NUMBER_PREDEFINED_VARS = 6;
    }

    public void setPatchVariable(int n, Object object) throws AgentException {
        if (n > 5) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 3: {
                    if (object instanceof Double) {
                        this.pcolor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.pcolor((LogoList)object, 3, true);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[n], Double.class, object);
                    break;
                }
                case 4: {
                    this.label(object);
                    break;
                }
                case 5: {
                    if (object instanceof Double) {
                        this.labelColor((double)((Double)object));
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 5);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[n], Double.class, object);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    throw new AgentException("you can't change a patch's coordinates");
                }
                default: {
                    return;
                }
            }
        }
    }

    public Object getPatchVariable(int vn) {
        if (vn == 3 && this.variables[3] == null) {
            this.variables[3] = this.pcolor;
        }
        return this.variables[vn];
    }

    public double getPatchVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
            case 2: {
                return this.pzcor;
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        Patch3D target = ((World3D)this.world).getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy, this.pzcor);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    public Patch3D getPatchAtOffsets(double dx, double dy, double dz) throws AgentException {
        Patch3D target = ((World3D)this.world).getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy, (double)this.pzcor + dz);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    public Patch fastGetPatchAt(int x, int y) {
        return ((World3D)this.world).fastGetPatchAt(x, y, this.pzcor);
    }

    public Turtle sprout(int c, int heading, AgentSet breed) {
        Turtle3D child = new Turtle3D((World3D)this.world, breed, (Double)this.variables[0], (Double)this.variables[1], (Double)this.variables[2]);
        child.colorDouble(Double.valueOf(5 + 10 * c));
        child.heading(heading);
        return child;
    }

    public Object pcolor() {
        if (this.variables[3] == null) {
            this.variables[3] = this.pcolor;
        }
        return this.variables[3];
    }

    public void pcolor(double pcolor) {
        if (pcolor < 0.0 || pcolor >= 140.0) {
            pcolor = Color.modulateDouble(pcolor);
        }
        if (this.pcolor != pcolor) {
            this.pcolor = pcolor;
            this.variables[3] = null;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(pcolor);
            this.world.patchColorsDirty = true;
            if (pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(Double boxedColor) {
        double color = boxedColor;
        if (color < 0.0 || color >= 140.0) {
            if (this.pcolor != (color = Color.modulateDouble(color))) {
                this.pcolor = color;
                this.variables[3] = null;
                this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
                this.world.patchColorsDirty = true;
                if (this.pcolor != 0.0) {
                    this.world.patchesAllBlack = false;
                }
            }
        } else if (this.pcolor != color) {
            this.pcolor = color;
            this.variables[3] = boxedColor;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
            this.world.patchColorsDirty = true;
            if (this.pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(LogoList rgb) throws AgentException {
        this.pcolor(rgb, 3, true);
    }

    public void pcolorDoubleUnchecked(Double boxedColor) {
        double color = boxedColor;
        if (color != this.pcolor) {
            this.pcolor = color;
            this.variables[3] = boxedColor;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(color);
            this.world.patchColorsDirty = true;
            if (color != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public Object label() {
        return this.variables[4];
    }

    public String labelString() {
        return Dump.logoObject(this.variables[4]);
    }

    public void label(Object label) {
        if (label instanceof String && ((String)label).length() == 0) {
            if (this.hasLabel()) {
                --this.world.patchesWithLabels;
            }
        } else if (!this.hasLabel()) {
            ++this.world.patchesWithLabels;
        }
        this.variables[4] = label;
    }

    public Object labelColor() {
        return this.variables[5];
    }

    public void labelColor(double labelColor) {
        this.variables[5] = Color.modulateDouble(labelColor);
    }

    public void labelColor(Double labelColor) {
        this.variables[5] = labelColor;
    }

    public AgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = ((Topology3D)((Object)this.world.getTopology())).getNeighbors3d(this);
        }
        return this.patchNeighbors;
    }

    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor + " " + this.pzcor;
    }
}

