/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.ConstantSliderConstraint;
import org.nlogo.agent.DynamicSliderConstraint;
import org.nlogo.agent.Evaluator;
import org.nlogo.agent.Thunk;
import org.nlogo.agent.World;
import org.nlogo.api.Approximate;
import org.nlogo.api.CompilerException;
import org.nlogo.api.LogoException;
import org.nlogo.api.ValueConstraint;
import org.nlogo.util.Exceptions;

public strictfp abstract class SliderConstraint
implements ValueConstraint {
    Double defaultValue = World.ZERO;

    public abstract Double minimum() throws LogoException;

    public abstract Double maximum() throws LogoException;

    public abstract Double increment() throws LogoException;

    public Object defaultValue() {
        return this.defaultValue;
    }

    public void defaultValue(Double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Double effectiveMaximum() throws LogoException {
        Double min = this.minimum();
        Double max = this.maximum();
        Double inc = this.increment();
        if (min >= max) {
            return min;
        }
        if (inc == 0.0) {
            return min;
        }
        double result = min + inc * StrictMath.floor((max - min) / inc);
        if (Approximate.approximate(result + inc, this.getPrecision()) <= max) {
            result += inc.doubleValue();
        }
        return Approximate.approximate(result, this.getPrecision());
    }

    public int getPrecision() {
        try {
            int minPrec = this.getPrecisionHelper(this.minimum());
            int incPrec = this.getPrecisionHelper(this.increment());
            return minPrec > incPrec ? minPrec : incPrec;
        }
        catch (LogoException ex) {
            Exceptions.ignore(ex);
            return 0;
        }
    }

    private int getPrecisionHelper(Double n) {
        String s = n.toString();
        int prec = 0;
        int place = s.indexOf(69);
        if (place != -1) {
            String precstr = s.substring(place + 2);
            prec = Integer.valueOf(precstr);
        } else {
            place = s.indexOf(46);
            if (place != -1) {
                while (s.lastIndexOf(48) == s.length() - 1) {
                    s = s.substring(0, s.length() - 1);
                }
                prec = s.length() - place - 1;
            }
        }
        return prec;
    }

    public void assertConstraint(Object val) throws ValueConstraint.Violation {
        if (!(val instanceof Double)) {
            throw new ValueConstraint.Violation("Value must be a number.");
        }
    }

    public Object coerceValue(Object val) {
        if (val instanceof Double) {
            return val;
        }
        return this.defaultValue();
    }

    public static SliderConstraint makeSliderConstraint(Agent agent, String minSpec, String maxSpec, String incSpec, Double defValue, Object owner) throws ConstraintCompilerException, LogoException {
        SliderConstraint con;
        Evaluator ev = agent.world().defaultEvaluator();
        if (ev.isConstant(minSpec) && ev.isConstant(maxSpec) && ev.isConstant(incSpec)) {
            Double inc;
            Double max;
            Double min;
            Object o;
            try {
                o = ev.readFromString(minSpec);
                if (!(o instanceof Double)) {
                    throw new RuntimeConstraintException("Minimum", "constraint must be a number.");
                }
                min = (Double)o;
            }
            catch (CompilerException ex) {
                throw new RuntimeConstraintException("Minimum", ex.getMessage());
            }
            try {
                o = ev.readFromString(maxSpec);
                if (!(o instanceof Double)) {
                    throw new RuntimeConstraintException("Maximum", "constraint must be a number.");
                }
                max = (Double)o;
            }
            catch (CompilerException ex) {
                throw new RuntimeConstraintException("Maximum", ex.getMessage());
            }
            try {
                o = ev.readFromString(incSpec);
                if (!(o instanceof Double)) {
                    throw new RuntimeConstraintException("Increment", "constraint must be a number.");
                }
                inc = (Double)o;
            }
            catch (CompilerException ex) {
                throw new RuntimeConstraintException("Increment", ex.getMessage());
            }
            con = new ConstantSliderConstraint(min, max, inc);
        } else {
            String prop = "Minimum";
            try {
                Thunk minThunk = ev.makeThunk(minSpec, agent, owner);
                prop = "Maximum";
                Thunk maxThunk = ev.makeThunk(maxSpec, agent, owner);
                prop = "Increment";
                Thunk incThunk = ev.makeThunk(incSpec, agent, owner);
                con = new DynamicSliderConstraint(minThunk, maxThunk, incThunk);
            }
            catch (CompilerException ex) {
                throw new ConstraintCompilerException(prop, ex);
            }
        }
        con.defaultValue(defValue);
        return con;
    }

    public strictfp static class RuntimeConstraintException
    extends LogoException {
        public String constraint;

        public RuntimeConstraintException(String constraint, String message) {
            super("Constraint runtime error for " + constraint + ": " + message);
            this.constraint = constraint;
        }
    }

    public strictfp static class ConstraintCompilerException
    extends CompilerException {
        public final String constraint;
        public final CompilerException exception;

        public ConstraintCompilerException(String constraint, CompilerException ex) {
            super(ex.getMessage(), ex.startPos(), ex.endPos(), ex.fileName());
            this.constraint = constraint;
            this.exception = ex;
        }
    }
}

