/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp class Torus
extends Topology {
    Torus(World world) {
        super(world);
    }

    double wrapX(double x) {
        return Torus.wrap(x, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    double wrapY(double y) {
        return Torus.wrap(y, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world.worldWidth() - x1 : x2 - (double)this.world.worldWidth() - x1;
        dx = StrictMath.abs(dx2) < StrictMath.abs(dx) ? dx2 : dx;
        double dy2 = y1 > y2 ? y2 + (double)this.world.worldHeight() - y1 : y2 - (double)this.world.worldHeight() - y1;
        dy = StrictMath.abs(dy2) < StrictMath.abs(dy) ? dy2 : dy;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    double towardsWrap(double headingX, double headingY) {
        headingX = Torus.wrap(headingX, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        if ((headingY = Torus.wrap(headingY, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    Patch getPatchAt(double xc, double yc) throws AgentException {
        return this.world.getPatchAt(xc, yc);
    }

    AgentSet getNeighbors(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor() && patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
    }

    AgentSet getNeighbors4(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor() && patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
    }

    double shortestPathX(double x1, double x2) {
        double xprime = x1 > x2 ? x2 + (double)this.world.worldWidth() : x2 - (double)this.world.worldWidth();
        if (StrictMath.abs(x2 - x1) > StrictMath.abs(xprime - x1)) {
            x2 = xprime;
        }
        return x2;
    }

    double shortestPathY(double y1, double y2) {
        double yprime = y1 > y2 ? y2 + (double)this.world.worldHeight() : y2 - (double)this.world.worldHeight();
        if (StrictMath.abs(y2 - y1) > StrictMath.abs(yprime - y1)) {
            y2 = yprime;
        }
        return y2;
    }

    void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int xx2 = xx * 2;
        int yy = this.world.worldHeight();
        int yy2 = yy * 2;
        double[][] scratch = this.world.getPatchScratch();
        int x = 0;
        int y = 0;
        try {
            for (y = 0; y < yy; ++y) {
                for (x = 0; x < xx; ++x) {
                    scratch[x][y] = (Double)this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)).getPatchVariable(vn);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)));
        }
        for (y = yy; y < yy2; ++y) {
            for (x = xx; x < xx2; ++x) {
                double sum = scratch[(x - 1) % xx][(y - 1) % yy];
                sum += scratch[(x - 1) % xx][y % yy];
                sum += scratch[(x - 1) % xx][(y + 1) % yy];
                sum += scratch[x % xx][(y - 1) % yy];
                sum += scratch[x % xx][(y + 1) % yy];
                sum += scratch[(x + 1) % xx][(y - 1) % yy];
                sum += scratch[(x + 1) % xx][y % yy];
                double oldval = scratch[x - xx][y - yy];
                double newval = oldval * (1.0 - diffuseparam) + (sum += scratch[(x + 1) % xx][(y + 1) % yy]) / 8.0 * diffuseparam;
                if (newval == oldval) continue;
                this.world.getPatchAt(x - xx, y - yy).setPatchVariable(vn, newval);
            }
        }
    }

    void diffuse4(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        double[][] scratch = this.world.getPatchScratch();
        int x = 0;
        int y = 0;
        try {
            for (y = 0; y < yy; ++y) {
                for (x = 0; x < xx; ++x) {
                    scratch[x][y] = (Double)this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)).getPatchVariable(vn);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x), (int)this.wrapY(y)));
        }
        for (y = 0; y < yy; ++y) {
            for (x = 0; x < xx; ++x) {
                double sum = 0.0;
                sum += scratch[(x + xx - 1) % xx][(y + yy) % yy];
                sum += scratch[(x + xx) % xx][(y + yy + 1) % yy];
                sum += scratch[(x + xx + 1) % xx][(y + yy) % yy];
                double newval = scratch[x][y] * (1.0 - diffuseparam) + (sum += scratch[(x + xx) % xx][(y + yy - 1) % yy]) * diffuseparam / 4.0;
                if (newval == scratch[x][y]) continue;
                this.world.getPatchAt(x, y).setPatchVariable(vn, newval);
            }
        }
    }

    Patch getPN(Patch source2) {
        return this.getPatchNorth(source2);
    }

    Patch getPE(Patch source2) {
        return this.getPatchEast(source2);
    }

    Patch getPS(Patch source2) {
        return this.getPatchSouth(source2);
    }

    Patch getPW(Patch source2) {
        return this.getPatchWest(source2);
    }

    Patch getPNE(Patch source2) {
        return this.getPatchNorthEast(source2);
    }

    Patch getPSE(Patch source2) {
        return this.getPatchSouthEast(source2);
    }

    Patch getPSW(Patch source2) {
        return this.getPatchSouthWest(source2);
    }

    Patch getPNW(Patch source2) {
        return this.getPatchNorthWest(source2);
    }
}

