/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.BreedShapes;
import org.nlogo.agent.Evaluator;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.Importer;
import org.nlogo.agent.InRadiusOrCone;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TickCounter;
import org.nlogo.agent.TieManager;
import org.nlogo.agent.Timer;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Torus;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.VertCylinder;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.LogoException;
import org.nlogo.api.Program;
import org.nlogo.api.RandomSeedGenerator;
import org.nlogo.api.ShapeList;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.WorldDimensions;
import org.nlogo.util.Exceptions;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class World
implements org.nlogo.api.World {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public final TickCounter tickCounter = new TickCounter();
    public final Timer timer = new Timer();
    private final ShapeList turtleShapeList;
    private final ShapeList linkShapeList;
    private double patchSize = 12.0;
    TrailDrawerInterface trailDrawer;
    private final Map<Agent, Double> lineThicknesses = new HashMap<Agent, Double>();
    Topology topology;
    RootsTable rootsTable;
    public Protractor protractor = new Protractor(this);
    public LinkManager linkManager;
    public TieManager tieManager;
    public InRadiusOrCone inRadiusOrCone;
    public volatile boolean comeUpForAir = false;
    private final AgentSet noTurtles = new ArrayAgentSet(Turtle.class, 0, false, this);
    private final AgentSet noPatches = new ArrayAgentSet(Patch.class, 0, false, this);
    private final AgentSet noLinks = new ArrayAgentSet(Link.class, 0, false, this);
    public final MersenneTwisterFast mainRNG = new MersenneTwisterFast();
    public final MersenneTwisterFast auxRNG = new MersenneTwisterFast();
    private final RandomSeedGenerator seedGenerator = new RandomSeedGenerator();
    Double worldWidthBoxed;
    Double worldHeightBoxed;
    Double minPxcorBoxed;
    Double minPycorBoxed;
    Double maxPxcorBoxed;
    Double maxPycorBoxed;
    int worldWidth;
    int worldHeight;
    int minPxcor;
    int minPycor;
    int maxPxcor;
    int maxPycor;
    final AgentSet observers;
    final Observer observer;
    AgentSet patches = null;
    AgentSet turtles = null;
    AgentSet links = null;
    private long nextTurtleIndex = 0L;
    private long nextLinkIndex = 0L;
    int[] patchColors;
    boolean patchColorsDirty = true;
    boolean patchesAllBlack = true;
    int patchesWithLabels = 0;
    double[][] patchScratch;
    public final BreedShapes linkBreedShapes = new BreedShapes("LINKS");
    public final BreedShapes turtleBreedShapes = new BreedShapes("TURTLES");
    Program program = this.newProgram();
    List<String> oldTurtlesOwn = new ArrayList<String>();
    List<String> oldPatchesOwn = new ArrayList<String>();
    List<String> oldLinksOwn = new ArrayList<String>();
    List<String> oldGlobals = new ArrayList<String>();
    Map<String, Object> oldBreeds = new LinkedHashMap<String, Object>();
    Map<String, Object> oldLinkBreeds = new LinkedHashMap<String, Object>();
    Map<String, List<String>> oldBreedsOwn = new HashMap<String, List<String>>();
    Map<String, List<String>> oldLinkBreedsOwn = new HashMap<String, List<String>>();
    private boolean displayOn = true;
    private Evaluator defaultEvaluator;

    @Override
    public ShapeList turtleShapeList() {
        return this.turtleShapeList;
    }

    @Override
    public ShapeList linkShapeList() {
        return this.linkShapeList;
    }

    @Override
    public Protractor protractor() {
        return this.protractor;
    }

    public World() {
        this.turtleShapeList = new ShapeList();
        this.linkShapeList = new ShapeList();
        this.observer = this.createObserver();
        this.observers = new ArrayAgentSet(Observer.class, 1, "observers", false, this);
        this.linkManager = new LinkManager(this);
        this.tieManager = new TieManager(this, this.linkManager);
        this.inRadiusOrCone = new InRadiusOrCone(this);
        this.observers.add(this.observer);
        this.changeTopology(true, true);
        this.createPatches(this.minPxcor, this.maxPxcor, this.minPycor, this.maxPycor);
    }

    Observer createObserver() {
        return new Observer(this);
    }

    public AgentSet noTurtles() {
        return this.noTurtles;
    }

    public AgentSet noPatches() {
        return this.noPatches;
    }

    public AgentSet noLinks() {
        return this.noLinks;
    }

    public void trailDrawer(TrailDrawerInterface trailDrawer) {
        this.trailDrawer = trailDrawer;
    }

    Topology getTopology() {
        return this.topology;
    }

    public void changeTopology(boolean xWrapping, boolean yWrapping) {
        this.topology = Topology.getTopology(this, xWrapping, yWrapping);
        if (this.patches != null) {
            AgentSet.Iterator it = this.patches.iterator();
            while (it.hasNext()) {
                ((Patch)it.next()).topologyChanged();
            }
        }
    }

    @Override
    public double wrappedObserverX(double x) {
        try {
            x = this.topology.wrapX(x - this.topology.followOffsetX());
        }
        catch (AgentException e) {
            Exceptions.ignore(e);
        }
        return x;
    }

    @Override
    public double wrappedObserverY(double y) {
        try {
            y = this.topology.wrapY(y - this.topology.followOffsetY());
        }
        catch (AgentException e) {
            Exceptions.ignore(e);
        }
        return y;
    }

    @Override
    public double followOffsetX() {
        return this.observer.followOffsetX();
    }

    @Override
    public double followOffsetY() {
        return this.observer.followOffsetY();
    }

    @Override
    public boolean wrappingAllowedInX() {
        return this.topology instanceof Torus || this.topology instanceof VertCylinder;
    }

    @Override
    public boolean wrappingAllowedInY() {
        return this.topology instanceof Torus || this.topology instanceof HorizCylinder;
    }

    public void exportWorld(PrintWriter writer, boolean full) {
        new Exporter(this).exportWorld(writer, full);
    }

    public void importWorld(Importer.ErrorHandler errorHandler, ImporterUser importerUser, Importer.StringReader stringReader, BufferedReader reader) throws IOException {
        new Importer(errorHandler, this, importerUser, stringReader).importWorld(reader);
    }

    public double generateSeed() {
        return this.seedGenerator.generateSeed();
    }

    public void setLineThickness(Agent agent, double size) {
        this.lineThicknesses.put(agent, size);
    }

    public double lineThickness(Agent agent) {
        Double size = this.lineThicknesses.get(agent);
        if (size != null) {
            return size;
        }
        return 0.0;
    }

    public void removeLineThickness(Agent agent) {
        this.lineThicknesses.remove(agent);
    }

    void drawLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.trailDrawer.drawLine(x0, y0, x1, y1, color, size, mode);
    }

    public Double worldWidthBoxed() {
        return this.worldWidthBoxed;
    }

    public Double worldHeightBoxed() {
        return this.worldHeightBoxed;
    }

    public Double minPxcorBoxed() {
        return this.minPxcorBoxed;
    }

    public Double minPycorBoxed() {
        return this.minPycorBoxed;
    }

    public Double maxPxcorBoxed() {
        return this.maxPxcorBoxed;
    }

    public Double maxPycorBoxed() {
        return this.maxPycorBoxed;
    }

    @Override
    public int worldWidth() {
        return this.worldWidth;
    }

    @Override
    public int worldHeight() {
        return this.worldHeight;
    }

    @Override
    public int minPxcor() {
        return this.minPxcor;
    }

    @Override
    public int minPycor() {
        return this.minPycor;
    }

    @Override
    public int maxPxcor() {
        return this.maxPxcor;
    }

    @Override
    public int maxPycor() {
        return this.maxPycor;
    }

    @Override
    public double wrapX(double x) throws AgentException {
        return this.topology.wrapX(x);
    }

    @Override
    public double wrapY(double y) throws AgentException {
        return this.topology.wrapY(y);
    }

    @Override
    public double wrap(double pos, double min, double max) {
        return Topology.wrap(pos, min, max);
    }

    public void diffuse(double param, int vn) throws AgentException, PatchException {
        this.topology.diffuse(param, vn);
    }

    public void diffuse4(double param, int vn) throws AgentException, PatchException {
        this.topology.diffuse4(param, vn);
    }

    public int roundX(double x) throws AgentException {
        try {
            x = this.topology.wrapX(x);
        }
        catch (AgentException ex) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        if (x > 0.0) {
            return (int)(x + 0.5);
        }
        int intPart = (int)x;
        double fractPart = (double)intPart - x;
        return fractPart > 0.5 ? intPart - 1 : intPart;
    }

    public int roundY(double y) throws AgentException {
        try {
            y = this.topology.wrapY(y);
        }
        catch (AgentException ex) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        if (y > 0.0) {
            return (int)(y + 0.5);
        }
        int intPart = (int)y;
        double fractPart = (double)intPart - y;
        return fractPart > 0.5 ? intPart - 1 : intPart;
    }

    public Turtle createTurtle(AgentSet breed) {
        return new Turtle(this, breed, ZERO, ZERO);
    }

    public Turtle createTurtle(AgentSet breed, int c, int h) {
        Turtle baby = new Turtle(this, breed, ZERO, ZERO);
        baby.colorDoubleUnchecked(Double.valueOf(5 + 10 * c));
        baby.heading(h);
        return baby;
    }

    public AgentSet observers() {
        return this.observers;
    }

    @Override
    public Observer observer() {
        return this.observer;
    }

    @Override
    public AgentSet patches() {
        return this.patches;
    }

    @Override
    public AgentSet turtles() {
        return this.turtles;
    }

    @Override
    public AgentSet links() {
        return this.links;
    }

    public AgentSet agentClassToAgentSet(Class<? extends Agent> clazz) {
        if (clazz == Turtle.class) {
            return this.turtles;
        }
        if (clazz == Patch.class) {
            return this.patches;
        }
        if (clazz == Observer.class) {
            return this.observers;
        }
        if (clazz == Link.class) {
            return this.links;
        }
        throw new IllegalArgumentException("agentClass = " + clazz);
    }

    public WorldDimensions getDimensions() {
        return new WorldDimensions(this.minPxcor, this.maxPxcor, this.minPycor, this.maxPycor);
    }

    @Override
    public Patch getPatch(int id) {
        return (Patch)this.patches.toArray()[id];
    }

    @Override
    public Patch getPatchAt(double x, double y) throws AgentException {
        int xc = this.roundX(x);
        int yc = this.roundY(y);
        int id = this.worldWidth * (this.maxPycor - yc) + xc - this.minPxcor;
        return (Patch)this.patches.toArray()[id];
    }

    public Patch getPatchAtWrap(double x, double y) {
        double fractPart;
        int intPart;
        int xc;
        x = Topology.wrap(x, (double)this.minPxcor() - 0.5, (double)this.maxPxcor() + 0.5);
        y = Topology.wrap(y, (double)this.minPycor() - 0.5, (double)this.maxPycor() + 0.5);
        if (x > 0.0) {
            xc = (int)(x + 0.5);
        } else {
            intPart = (int)x;
            fractPart = (double)intPart - x;
            int n = xc = fractPart > 0.5 ? intPart - 1 : intPart;
        }
        int yc = y > 0.0 ? (int)(y + 0.5) : ((fractPart = (double)(intPart = (int)y) - y) > 0.5 ? intPart - 1 : intPart);
        int patchid = this.worldWidth * (this.maxPycor - yc) + xc - this.minPxcor;
        return (Patch)this.patches.toArray()[patchid];
    }

    public boolean validPatchCoordinates(int xc, int yc) {
        return xc >= this.minPxcor && xc <= this.maxPxcor && yc >= this.minPycor && yc <= this.maxPycor;
    }

    @Override
    public Patch fastGetPatchAt(int xc, int yc) {
        return (Patch)this.patches.toArray()[this.worldWidth * (this.maxPycor - yc) + xc - this.minPxcor];
    }

    public Turtle getTurtle(long id) {
        return (Turtle)this.turtles.getAgent(id);
    }

    public Link getLink(Object end1, Object end2, AgentSet breed) {
        return this.linkManager.findLink((Turtle)this.turtles.getAgent(end1), (Turtle)this.turtles.getAgent(end2), breed, false);
    }

    void nextTurtleIndex(long nextTurtleIndex) {
        this.nextTurtleIndex = nextTurtleIndex;
    }

    long nextTurtleIndex() {
        return this.nextTurtleIndex;
    }

    long newTurtleId() {
        return this.nextTurtleIndex++;
    }

    long newLinkId() {
        return this.nextLinkIndex++;
    }

    public Turtle getOrCreateTurtle(long id) {
        Turtle turtle2 = this.getTurtle(id);
        if (turtle2 == null) {
            turtle2 = new Turtle(this, id);
            this.nextTurtleIndex = StrictMath.max(this.nextTurtleIndex, id + 1L);
        }
        return turtle2;
    }

    public Link getOrCreateLink(Double end1, Double end2, AgentSet breed) {
        return this.getOrCreateLink(this.getOrCreateTurtle(end1.longValue()), this.getOrCreateTurtle(end2.longValue()), breed);
    }

    public Link getOrCreateLink(Turtle end1, Turtle end2, AgentSet breed) {
        Link link = this.getLink(end1.agentKey(), end2.agentKey(), breed);
        if (link == null) {
            link = this.linkManager.createLink(end1, end2, breed);
        }
        return link;
    }

    @Override
    public boolean patchColorsDirty() {
        return this.patchColorsDirty;
    }

    @Override
    public void markPatchColorsDirty() {
        this.patchColorsDirty = true;
    }

    @Override
    public void markPatchColorsClean() {
        this.patchColorsDirty = false;
    }

    @Override
    public boolean patchesAllBlack() {
        return this.patchesAllBlack;
    }

    @Override
    public int[] patchColors() {
        return this.patchColors;
    }

    @Override
    public int patchesWithLabels() {
        return this.patchesWithLabels;
    }

    public void createPatches(int n, int n2, int n3, int n4) {
        Iterator<Object> iterator;
        this.patchScratch = null;
        this.minPxcor = n;
        this.maxPxcor = n2;
        this.minPycor = n3;
        this.maxPycor = n4;
        this.worldWidth = n2 - n + 1;
        this.worldHeight = n4 - n3 + 1;
        this.rootsTable = new RootsTable(this.worldWidth, this.worldHeight);
        this.worldWidthBoxed = this.worldWidth;
        this.worldHeightBoxed = this.worldHeight;
        this.minPxcorBoxed = n;
        this.minPycorBoxed = n3;
        this.maxPxcorBoxed = n2;
        this.maxPycorBoxed = n4;
        if (this.program.breeds != null) {
            iterator = this.program.breeds.values().iterator();
            while (iterator.hasNext()) {
                ((AgentSet)iterator.next()).clear();
            }
        }
        if (this.program.linkBreeds != null) {
            iterator = this.program.breeds.values().iterator();
            while (iterator.hasNext()) {
                ((AgentSet)iterator.next()).clear();
            }
        }
        this.turtles = new TreeAgentSet(Turtle.class, "TURTLES", this);
        this.links = new TreeAgentSet(Link.class, "LINKS", this);
        int n5 = n;
        int n6 = n4;
        Agent[] agentArray = new Agent[this.worldWidth * this.worldHeight];
        this.patchColors = new int[this.worldWidth * this.worldHeight];
        Arrays.fill(this.patchColors, Color.getARGBbyPremodulatedColorNumber(0.0));
        this.patchColorsDirty = true;
        int n7 = this.program().patchesOwn.size();
        this.observer.resetPerspective();
        for (int i = 0; this.worldWidth * this.worldHeight != i; ++i) {
            Patch patch = new Patch(this, i, n5, n6, n7);
            if (++n5 == n2 + 1) {
                n5 = n;
                --n6;
            }
            agentArray[i] = patch;
        }
        this.patches = new ArrayAgentSet(Patch.class, agentArray, "patches", this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
    }

    public void clearAll() {
        this.tickCounter.reset();
        this.clearTurtles();
        this.clearPatches();
        this.clearGlobals();
        this.clearLinks();
        this.observer.resetPerspective();
    }

    public void clearDrawing() {
    }

    public void stamp(Agent agent, boolean erase) {
        this.trailDrawer.stamp(agent, erase);
    }

    @Override
    public double patchSize() {
        return this.patchSize;
    }

    public boolean patchSize(double patchSize) {
        if (this.patchSize != patchSize) {
            this.patchSize = patchSize;
            return true;
        }
        return false;
    }

    @Override
    public Object getDrawing() {
        return this.trailDrawer.getDrawing();
    }

    @Override
    public boolean sendPixels() {
        return this.trailDrawer.sendPixels();
    }

    @Override
    public void markDrawingClean() {
        this.trailDrawer.sendPixels(false);
    }

    public void clearPatches() {
        AgentSet.Iterator iter = this.patches.iterator();
        while (iter.hasNext()) {
            Patch patch = (Patch)iter.next();
            patch.pcolorDoubleUnchecked(Color.BOXED_BLACK);
            patch.label("");
            patch.labelColor(Color.BOXED_WHITE);
            try {
                for (int j = patch.NUMBER_PREDEFINED_VARS; j < patch.variables.length; ++j) {
                    patch.setPatchVariable(j, ZERO);
                }
            }
            catch (AgentException ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.patchesAllBlack = true;
    }

    public void clearTurtles() {
        Object iter;
        if (this.program.breeds != null) {
            iter = this.program.breeds.values().iterator();
            while (iter.hasNext()) {
                ((AgentSet)iter.next()).clear();
            }
        }
        iter = this.turtles.iterator();
        while (iter.hasNext()) {
            Turtle turtle2 = (Turtle)iter.next();
            this.lineThicknesses.remove(turtle2);
            this.linkManager.cleanup(turtle2);
            turtle2.id(-1L);
        }
        this.turtles.clear();
        iter = this.patches.iterator();
        while (iter.hasNext()) {
            ((Patch)iter.next()).turtlesHere.clear();
        }
        this.nextTurtleIndex = 0L;
        this.observer.updatePosition();
    }

    public void clearLinks() {
        if (this.program.linkBreeds != null) {
            for (AgentSet agentSet : this.program.linkBreeds.values()) {
                agentSet.clear();
            }
        }
        AgentSet.Iterator iter = this.links.iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            link.id = -1L;
        }
        this.links.clear();
        this.nextLinkIndex = 0L;
        this.linkManager.reset();
    }

    public void clearGlobals() {
        for (int j = this.program().interfaceGlobals.size(); j < this.observer.variables.length; ++j) {
            try {
                ValueConstraint con = this.observer.variableConstraint(j);
                if (con != null) {
                    this.observer.setObserverVariable(j, con.defaultValue());
                    continue;
                }
                this.observer.setObserverVariable(j, ZERO);
                continue;
            }
            catch (AgentException ex) {
                throw new IllegalStateException(ex);
            }
            catch (LogoException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void realloc() {
        for (String object2 : this.program.breeds.keySet()) {
            AgentSet agentSet = (AgentSet)this.oldBreeds.get(object2);
            if (agentSet == null) {
                this.program.breeds.put(object2, new TreeAgentSet(Turtle.class, object2.toUpperCase(), this));
                continue;
            }
            this.program.breeds.put(object2, agentSet);
        }
        for (String agentException : this.program.linkBreeds.keySet()) {
            boolean bl = this.program.linkBreeds.get(agentException).equals("DIRECTED-LINK-BREED");
            AgentSet agentSet = (AgentSet)this.oldLinkBreeds.get(agentException);
            if (agentSet == null) {
                agentSet = new TreeAgentSet(Link.class, agentException.toUpperCase(), this);
            } else {
                agentSet.clearDirected();
            }
            this.program.linkBreeds.put(agentException, agentSet);
            agentSet.setDirected(bl);
        }
        ArrayList arrayList = new ArrayList();
        try {
            if (this.turtles != null) {
                AgentSet.Iterator agentException = this.turtles.iterator();
                while (agentException.hasNext()) {
                    Agent agent = agentException.next().realloc(true);
                    if (agent == null) continue;
                    arrayList.add(agent);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((Turtle)iterator.next()).die();
                }
                arrayList.clear();
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
        try {
            if (this.links != null) {
                AgentSet.Iterator iterator = this.links.iterator();
                while (iterator.hasNext()) {
                    Agent agent = iterator.next().realloc(true);
                    if (agent == null) continue;
                    arrayList.add(agent);
                }
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    ((Link)iterator2.next()).die();
                }
                arrayList.clear();
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
        try {
            if (this.patches != null && !((Object)this.program.patchesOwn).equals(this.oldPatchesOwn)) {
                AgentSet.Iterator iterator = this.patches.iterator();
                while (iterator.hasNext()) {
                    iterator.next().realloc(true);
                }
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
        this.observer.realloc(true);
        this.turtleBreedShapes.setUpBreedShapes(false, this.program.breeds);
        this.linkBreedShapes.setUpBreedShapes(false, this.program.linkBreeds);
    }

    public double[][] getPatchScratch() {
        if (this.patchScratch == null) {
            this.patchScratch = new double[this.worldWidth][this.worldHeight];
        }
        return this.patchScratch;
    }

    @Override
    public String turtlesOwnNameAt(int index) {
        return this.program.turtlesOwn.get(index);
    }

    public int turtlesOwnIndexOf(String name) {
        return this.program.turtlesOwn.indexOf(name);
    }

    public int linksOwnIndexOf(String name) {
        return this.program.linksOwn.indexOf(name);
    }

    @Override
    public String linksOwnNameAt(int index) {
        return this.program.linksOwn.get(index);
    }

    int oldTurtlesOwnIndexOf(String name) {
        return this.oldTurtlesOwn.indexOf(name);
    }

    int oldLinksOwnIndexOf(String name) {
        return this.oldLinksOwn.indexOf(name);
    }

    @Override
    public String breedsOwnNameAt(org.nlogo.api.AgentSet breed, int index) {
        List<String> breedOwns = this.program.breedsOwn.get(breed.printName());
        return breedOwns.get(index - this.program.turtlesOwn.size());
    }

    public int breedsOwnIndexOf(AgentSet agentSet, String string) {
        List<String> list = this.program.breedsOwn.get(agentSet.printName());
        if (list == null) {
            return -1;
        }
        int n = list.indexOf(string);
        if (n == -1) {
            return -1;
        }
        return agentSet.type() == Turtle.class ? this.program.turtlesOwn.size() + n : this.program.linksOwn.size() + n;
    }

    public String linkBreedsOwnNameAt(AgentSet breed, int index) {
        List<String> breedOwns = this.program.linkBreedsOwn.get(breed.printName());
        return breedOwns.get(index - this.program.linksOwn.size());
    }

    public int linkBreedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this.program.linkBreedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result = breedOwns.indexOf(name);
        if (result == -1) {
            return -1;
        }
        return this.program.linksOwn.size() + result;
    }

    int oldBreedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this.oldBreedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result = breedOwns.indexOf(name);
        if (result == -1) {
            return -1;
        }
        return this.oldTurtlesOwn.size() + result;
    }

    int oldLinkBreedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this.oldLinkBreedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result = breedOwns.indexOf(name);
        if (result == -1) {
            return -1;
        }
        return this.oldLinksOwn.size() + result;
    }

    public String patchesOwnNameAt(int index) {
        return this.program.patchesOwn.get(index);
    }

    public int patchesOwnIndexOf(String name) {
        return this.program.patchesOwn.indexOf(name);
    }

    public String observerOwnsNameAt(int index) {
        return this.program.globals.get(index);
    }

    public int observerOwnsIndexOf(String name) {
        return this.program.globals.indexOf(name);
    }

    public boolean isBreed(AgentSet breed) {
        return this.program.breeds.containsValue(breed);
    }

    public boolean isLinkBreed(AgentSet breed) {
        return this.program.linkBreeds.containsValue(breed);
    }

    public AgentSet getBreed(String breedName) {
        return (AgentSet)this.program.breeds.get(breedName);
    }

    public AgentSet getLinkBreed(String breedName) {
        return (AgentSet)this.program.linkBreeds.get(breedName);
    }

    public String getBreedSingular(AgentSet agentSet) {
        if (agentSet == this.turtles) {
            return "TURTLE";
        }
        String string = agentSet.printName();
        for (Map.Entry<String, String> entry : this.program.breedsSingular.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return "TURTLE";
    }

    public String getLinkBreedSingular(AgentSet agentSet) {
        if (agentSet == this.links) {
            return "LINK";
        }
        String string = agentSet.printName();
        for (Map.Entry<String, String> entry : this.program.linkBreedsSingular.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return "LINK";
    }

    public int compareLinkBreeds(AgentSet agentSet, AgentSet agentSet2) {
        for (AgentSet agentSet3 : this.program.linkBreeds.values()) {
            if (agentSet3 == agentSet) {
                return -1;
            }
            if (agentSet3 != agentSet2) continue;
            return 1;
        }
        throw new IllegalStateException("neither of the breeds exist, that's bad");
    }

    public int getVariablesArraySize(Observer observer) {
        return this.program.globals.size();
    }

    public int getVariablesArraySize(Patch patch) {
        return this.program.patchesOwn.size();
    }

    @Override
    public int getVariablesArraySize(org.nlogo.api.Turtle turtle2, org.nlogo.api.AgentSet breed) {
        if (breed == this.turtles) {
            return this.program.turtlesOwn.size();
        }
        List<String> breedOwns = this.program.breedsOwn.get(breed.printName());
        return this.program.turtlesOwn.size() + breedOwns.size();
    }

    @Override
    public int getVariablesArraySize(org.nlogo.api.Link link, org.nlogo.api.AgentSet breed) {
        if (breed == this.links) {
            return this.program.linksOwn.size();
        }
        List<String> breedOwns = this.program.linkBreedsOwn.get(breed.printName());
        return this.program.linksOwn.size() + breedOwns.size();
    }

    public int getLinkVariablesArraySize(AgentSet breed) {
        if (breed == this.links) {
            return this.program.linksOwn.size();
        }
        List<String> breedOwns = this.program.linkBreedsOwn.get(breed.printName());
        return this.program.linksOwn.size() + breedOwns.size();
    }

    public String checkTurtleShapeName(String name) {
        if (this.turtleShapeList.exists(name = name.toLowerCase())) {
            return name;
        }
        return null;
    }

    public String checkLinkShapeName(String name) {
        if (this.linkShapeList.exists(name = name.toLowerCase())) {
            return name;
        }
        return null;
    }

    public Map<String, Object> getBreeds() {
        return this.program.breeds;
    }

    public boolean breedOwns(AgentSet breed, String name) {
        if (breed == this.turtles) {
            return false;
        }
        List<String> breedOwns = this.program.breedsOwn.get(breed.printName());
        return breedOwns.contains(name);
    }

    public Map<String, Object> getLinkBreeds() {
        return this.program.linkBreeds;
    }

    public boolean linkBreedOwns(AgentSet breed, String name) {
        if (breed == this.links) {
            return false;
        }
        List<String> breedOwns = this.program.linkBreedsOwn.get(breed.printName());
        return breedOwns.contains(name);
    }

    @Override
    public Program program() {
        return this.program;
    }

    public void program(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("World.program cannot be set to null");
        }
        this.program = program;
    }

    public Program newProgram() {
        return new Program(false);
    }

    public Program newProgram(List<String> interfaceGlobals) {
        return new Program(interfaceGlobals, false);
    }

    public void rememberOldProgram() {
        this.oldTurtlesOwn = this.program.turtlesOwn;
        this.oldPatchesOwn = this.program.patchesOwn;
        this.oldLinksOwn = this.program.linksOwn;
        this.oldGlobals = this.program.globals;
        this.oldBreeds = this.program.breeds;
        this.oldLinkBreeds = this.program.linkBreeds;
        this.oldBreedsOwn = this.program.breedsOwn;
        this.oldLinkBreedsOwn = this.program.linkBreedsOwn;
    }

    public boolean displayOn() {
        return this.displayOn;
    }

    public void displayOn(boolean displayOn) {
        this.displayOn = displayOn;
    }

    public Object getObserverVariableByName(String string) {
        int n = this.program.globals.indexOf(string.toUpperCase());
        if (n >= 0 && n < this.observer.variables.length) {
            return this.observer.variables[n];
        }
        throw new IllegalArgumentException("\"" + string + "\" not found");
    }

    public void setObserverVariableByName(String string, Object object) throws AgentException, LogoException {
        int n;
        if (this.program.globals.contains(string = string.toUpperCase()) && -1 != (n = this.program.globals.indexOf(string)) && n < this.observer.variables.length) {
            this.observer.setObserverVariable(n, object);
            return;
        }
        throw new IllegalArgumentException("\"" + string + "\" not found");
    }

    public void setDefaultEvaluator(Evaluator eval) {
        this.defaultEvaluator = eval;
    }

    public Evaluator defaultEvaluator() {
        return this.defaultEvaluator;
    }
}

