/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nlogo.api.Approximate;
import org.nlogo.api.LogoList;
import org.nlogo.util.Utils;

public strictfp final class Color {
    public static final int NUM_HUES = 14;
    public static final int MAX_COLOR = 140;
    private static final String[] COLOR_NAMES;
    public static final double BLACK = 0.0;
    public static final double WHITE = 9.9;
    public static final Double BOXED_BLACK;
    public static final Double BOXED_WHITE;
    private static final double[] COLOR_NUMBERS;
    private static final int[] COLORS_RGB;
    private static final int[] ARGB_CACHE;
    private static final java.awt.Color[] AWT_CACHE;
    private static final Map<Double, Double> rgbMap;
    private static final String COLOR_TRANSLATIONS = "/system/color-translation.txt";
    private static final Map<Double, Integer> colorTranslations;

    private Color() {
        throw new IllegalStateException();
    }

    public static java.awt.Color getColor(Object color) {
        if (color instanceof Double) {
            return AWT_CACHE[(int)((Double)color * 10.0)];
        }
        if (color instanceof LogoList) {
            LogoList list = (LogoList)color;
            if (list.size() == 3) {
                return new java.awt.Color(((Number)list.get(0)).intValue(), ((Number)list.get(1)).intValue(), ((Number)list.get(2)).intValue());
            }
            if (list.size() == 4) {
                return new java.awt.Color(((Number)list.get(0)).intValue(), ((Number)list.get(1)).intValue(), ((Number)list.get(2)).intValue(), ((Number)list.get(3)).intValue());
            }
        }
        throw new IllegalStateException();
    }

    public static double getColorNumberByIndex(int index) {
        return COLOR_NUMBERS[index];
    }

    public static String[] getColorNamesArray() {
        return COLOR_NAMES;
    }

    public static String getColorNameByIndex(int index) {
        return COLOR_NAMES[index];
    }

    public static int modulateInteger(int color) {
        if ((color < 0 || color >= 140) && (color %= 140) < 0) {
            color += 140;
        }
        return color;
    }

    public static double modulateDouble(Double color) {
        return Color.modulateDouble((double)color);
    }

    public static double modulateDouble(double color) {
        if (color < 0.0 || color >= 140.0) {
            if ((color %= 140.0) < 0.0) {
                color += 140.0;
            }
            if (color >= 140.0) {
                color = 139.9999999999999;
            }
        }
        return color;
    }

    public static double findCentralColorNumber(double color) {
        if (color < 0.0 || color >= 140.0) {
            color = Color.modulateDouble(color);
        }
        return ((double)((int)(color / 10.0)) + 0.5) * 10.0;
    }

    public static double getClosestColorNumberByARGB(int argb) {
        Double lookup = rgbMap.get(argb);
        if (lookup != null) {
            return lookup;
        }
        return Color.estimateClosestColorNumberByRGB(argb);
    }

    public static String getClosestColorNameByARGB(int argb) {
        String colorName = null;
        DecimalFormat formatter = new DecimalFormat("###.####");
        double closest = Color.getClosestColorNumberByARGB(argb);
        if (closest != 0.0 && closest != 9.9) {
            int baseColorNumber = (int)Color.findCentralColorNumber(closest);
            double difference = closest - (double)baseColorNumber;
            String baseColorName = Color.getColorNameByIndex((baseColorNumber - 5) / 10);
            if (difference == 0.0) {
                colorName = baseColorName;
            } else if (difference > 0.0) {
                colorName = baseColorName + " + " + formatter.format(StrictMath.abs(difference));
            } else if (difference < 0.0) {
                colorName = baseColorName + " - " + formatter.format(StrictMath.abs(difference));
            }
        } else if (closest == 0.0) {
            colorName = Color.getColorNameByIndex(14);
        } else if (closest == 9.9) {
            colorName = Color.getColorNameByIndex(15);
        }
        return colorName;
    }

    public static double getClosestColorNumberByHSB(float h, float s, float b) {
        int argb = java.awt.Color.HSBtoRGB((h = StrictMath.max(0.0f, StrictMath.min(255.0f, h))) / 255.0f, (s = StrictMath.max(0.0f, StrictMath.min(255.0f, s))) / 255.0f, (b = StrictMath.max(0.0f, StrictMath.min(255.0f, b))) / 255.0f);
        Double lookup = rgbMap.get(argb);
        if (lookup != null) {
            return lookup;
        }
        return Color.estimateClosestColorNumberByRGB(argb);
    }

    private static double estimateClosestColorNumberByRGB(int argb) {
        Set<Map.Entry<Double, Double>> supportedColors = rgbMap.entrySet();
        long smallestDistance = 100000000L;
        double closest = 0.0;
        for (Map.Entry<Double, Double> entry : supportedColors) {
            int candidate = entry.getKey().intValue();
            long dist = Color.colorDistance(argb, candidate);
            if (dist >= smallestDistance) continue;
            smallestDistance = dist;
            closest = entry.getValue();
        }
        return closest;
    }

    private static long colorDistance(int argb1, int argb2) {
        int r1 = argb1 >> 16 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int b1 = argb1 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        long rmean = r1 + r2 / 2;
        long rd = r1 - r2;
        long gd = g1 - g2;
        long bd = b1 - b2;
        return ((512L + rmean) * rd * rd >> 8) + 4L * gd * gd + ((767L - rmean) * bd * bd >> 8);
    }

    public static int getARGBbyPremodulatedColorNumber(double modulatedColor) {
        return ARGB_CACHE[(int)(modulatedColor * 10.0)];
    }

    private static int computeARGBforCache(int colorTimesTen) {
        int baseIndex = colorTimesTen / 100;
        int r = COLORS_RGB[baseIndex * 3];
        int g = COLORS_RGB[baseIndex * 3 + 1];
        int b = COLORS_RGB[baseIndex * 3 + 2];
        double step = (double)(colorTimesTen % 100 - 50) / 50.48 + 0.012;
        if (step < 0.0) {
            r += (int)((double)r * step);
            g += (int)((double)g * step);
            b += (int)((double)b * step);
        } else if (step > 0.0) {
            r += (int)((double)(255 - r) * step);
            g += (int)((double)(255 - g) * step);
            b += (int)((double)(255 - b) * step);
        }
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public static int getRGBByName(String name) {
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            if (!name.equals(Color.getColorNameByIndex(i))) continue;
            return Color.getARGBByIndex(i);
        }
        throw new IllegalStateException(name);
    }

    public static int getARGBByIndex(int index) {
        switch (index) {
            case 14: {
                return -16777216;
            }
            case 15: {
                return -1;
            }
        }
        return ARGB_CACHE[index * 100 + 50];
    }

    public static LogoList getRGBListByARGB(int argb) {
        LogoList result = new LogoList();
        result.add(Approximate.approximate(argb >> 16 & 0xFF, 3));
        result.add(Approximate.approximate(argb >> 8 & 0xFF, 3));
        result.add(Approximate.approximate(argb & 0xFF, 3));
        return result;
    }

    public static LogoList getRGBAListByARGB(int argb) {
        LogoList result = new LogoList();
        result.add(Approximate.approximate(argb >> 16 & 0xFF, 3));
        result.add(Approximate.approximate(argb >> 8 & 0xFF, 3));
        result.add(Approximate.approximate(argb & 0xFF, 3));
        result.add(Approximate.approximate(argb >> 24 & 0xFF, 3));
        return result;
    }

    public static int getARGBIntByRGBAList(LogoList rgba) {
        if (rgba.size() == 4) {
            return ((Double)rgba.get(3)).intValue() << 24 | ((Double)rgba.get(0)).intValue() << 16 | ((Double)rgba.get(1)).intValue() << 8 | ((Double)rgba.get(2)).intValue();
        }
        return 0xFF000000 | ((Double)rgba.get(0)).intValue() << 16 | ((Double)rgba.get(1)).intValue() << 8 | ((Double)rgba.get(2)).intValue();
    }

    public static LogoList getHSBListByARGB(int argb) {
        float[] hsb = new float[3];
        java.awt.Color.RGBtoHSB(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, hsb);
        LogoList result = new LogoList();
        result.add(Approximate.approximate(hsb[0] * 255.0f, 3));
        result.add(Approximate.approximate(hsb[1] * 255.0f, 3));
        result.add(Approximate.approximate(hsb[2] * 255.0f, 3));
        return result;
    }

    public static int translateSavedColor(int color) {
        Integer index = colorTranslations.get(color);
        return index == null ? color : Color.getARGBByIndex(index);
    }

    public static Double argbToColor(int argb) {
        return Color.getClosestColorNumberByARGB(argb);
    }

    public static int getRGBInt(int r, int g, int b) {
        return ((r << 8) + g << 8) + b;
    }

    public static int getRGBInt(Object c) {
        if (c instanceof LogoList) {
            return Color.getARGBIntByRGBAList((LogoList)c);
        }
        if (c instanceof Double) {
            return Color.getARGBbyPremodulatedColorNumber((Double)c);
        }
        throw new IllegalStateException("Can't get RGB color");
    }

    public static java.awt.Color getComplement(java.awt.Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        return new java.awt.Color((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
    }

    static {
        int i;
        COLOR_NAMES = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "black", "white"};
        BOXED_BLACK = 0.0;
        BOXED_WHITE = 9.9;
        COLOR_NUMBERS = new double[]{5.0, 15.0, 25.0, 35.0, 45.0, 55.0, 65.0, 75.0, 85.0, 95.0, 105.0, 115.0, 125.0, 135.0, 0.0, 9.9};
        COLORS_RGB = new int[]{140, 140, 140, 215, 48, 39, 241, 105, 19, 156, 109, 70, 237, 237, 47, 87, 176, 58, 42, 209, 57, 27, 158, 119, 82, 196, 196, 43, 140, 190, 50, 92, 168, 123, 78, 163, 166, 25, 105, 224, 126, 149, 0, 0, 0, 255, 255, 255};
        ARGB_CACHE = new int[1400];
        for (i = 0; i < 1400; ++i) {
            Color.ARGB_CACHE[i] = Color.computeARGBforCache(i);
        }
        Color.ARGB_CACHE[0] = -16777216;
        Color.ARGB_CACHE[99] = -1;
        Color.ARGB_CACHE[0] = -16777216;
        Color.ARGB_CACHE[99] = -1;
        AWT_CACHE = new java.awt.Color[1400];
        for (i = 0; i < 1400; ++i) {
            Color.AWT_CACHE[i] = new java.awt.Color(Color.getARGBbyPremodulatedColorNumber((double)i / 10.0));
        }
        rgbMap = new HashMap<Double, Double>();
        for (int c = 0; c < 1400; ++c) {
            double color = (double)c / 10.0;
            rgbMap.put(Double.valueOf(Color.getARGBbyPremodulatedColorNumber(color)), color);
        }
        colorTranslations = new HashMap<Double, Integer>();
        String[] lines = Utils.getResourceAsStringArray(COLOR_TRANSLATIONS);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2].trim();
            if (line.equals("") || line.charAt(0) == '#') continue;
            String[] strs = line.split("\\s+");
            Integer index = Integer.valueOf(strs[0]);
            for (int j = 1; j < strs.length; ++j) {
                colorTranslations.put(Double.valueOf(strs[j]), index);
            }
        }
    }
}

