/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.nlogo.api.GraphicsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DummyGraphics
implements GraphicsInterface {
    private AffineTransform transform = new AffineTransform();
    Color color = Color.black;
    double stroke = 1.0;
    String composite = "src";
    boolean antialiasing = false;
    private final List<String> operations = new ArrayList<String>();
    private final LinkedList<AffineTransform> transforms = new LinkedList();

    public List<String> operations() {
        return this.operations;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (String s : this.operations) {
            b.append(s + "\n");
        }
        return b.toString();
    }

    @Override
    public void antiAliasing(boolean on) {
        this.antialiasing = on;
    }

    @Override
    public void setInterpolation() {
    }

    @Override
    public void setStrokeControl() {
    }

    @Override
    public String location(double x, double y) {
        return "(" + (this.transform.getTranslateX() + x * this.transform.getScaleX()) + " , " + (this.transform.getTranslateY() + y * this.transform.getScaleY()) + ")";
    }

    private String size(double width, double height) {
        return "[" + this.transform.getScaleX() * width + " " + this.transform.getScaleY() * height + "]";
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.operations.add("draw line: " + this.location(x1, y1) + " " + this.location(x2, y2));
    }

    @Override
    public void drawLabel(String s, double x, double y, double patchSize) {
        this.operations.add("draw label: " + this.location(x, y));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.operations.add("fillRect " + this.location(x, y) + " " + this.size(width, height));
    }

    @Override
    public void drawPolygon(int[] xcors, int[] ycors, int length2) {
        this.operations.add("draw polygon " + this.poly(xcors, ycors));
    }

    @Override
    public void fillPolygon(int[] xcors, int[] ycors, int length2) {
        this.operations.add("fill polygon " + this.poly(xcors, ycors));
    }

    @Override
    public void drawPolyline(int[] xcors, int[] ycors, int length2) {
        this.operations.add("draw polyline " + this.poly(xcors, ycors));
    }

    private String poly(int[] xcors, int[] ycors) {
        StringBuilder b = new StringBuilder();
        b.append("[ ");
        for (int i = 0; i < xcors.length; ++i) {
            b.append(this.location(xcors[i], ycors[i]) + " ");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public void draw(Shape shape) {
        this.operations.add("draw shape: " + shape.getClass().getName() + " " + this.location(0.0, 0.0));
    }

    @Override
    public void drawImage(BufferedImage image) {
        this.operations.add("draw image: " + this.location(0.0, 0.0));
    }

    @Override
    public void drawImage(Image image, int x, int y, int width, int height) {
        this.operations.add("draw image: " + this.location(x, y) + " " + this.size(width, height));
    }

    @Override
    public void fill(Shape shape) {
        this.operations.add("fill shape: " + shape.getClass().getName() + " " + this.location(0.0, 0.0));
    }

    @Override
    public void fillCircle(double x, double y, double xDiameter, double yDiameter, double scale, double angle) {
        this.operations.add("fill circle: " + this.location(x, y) + " " + this.size(xDiameter, yDiameter));
    }

    @Override
    public void drawCircle(double x, double y, double xDiameter, double yDiameter, double scale, double angle) {
        this.operations.add("draw circle: " + this.location(x, y) + " " + this.size(xDiameter, yDiameter));
    }

    @Override
    public void fillRect(double x, double y, double width, double height, double scale, double angle) {
        this.operations.add("fill rect: " + this.location(x, y) + " " + this.size(width, height));
    }

    @Override
    public void drawRect(double x, double y, double width, double height, double scale, double angle) {
        this.operations.add("draw rect: " + this.location(x, y) + " " + this.size(width, height));
    }

    @Override
    public void pop() {
        this.transform = this.transforms.removeLast();
    }

    @Override
    public void push() {
        this.transforms.addLast((AffineTransform)this.transform.clone());
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void rotate(double theta, double x, double y, double offset) {
        this.transform.rotate(theta, x + offset / 2.0, y + offset / 2.0);
    }

    @Override
    public void scale(double x, double y) {
        this.transform.scale(x, y);
    }

    @Override
    public void scale(double x, double y, double shapeWidth) {
        this.transform.scale(x / shapeWidth, y / shapeWidth);
    }

    @Override
    public void translate(double x, double y) {
        this.transform.translate(x, y);
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public void setComposite(Composite comp) {
        if (comp == AlphaComposite.Src) {
            this.composite = "src";
        } else if (comp == AlphaComposite.Clear) {
            this.composite = "clear";
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setStroke(double width) {
        this.stroke = width;
    }

    @Override
    public void setStrokeFromLineThickness(double lineThickness, double scale, double cellSize, double shapeWidth) {
        this.stroke = (float)(shapeWidth / scale * (lineThickness == 0.0 ? 1.0 : StrictMath.max(1.0, lineThickness * cellSize)));
    }

    @Override
    public void setStroke(float width, float[] dashes) {
        this.stroke = width;
    }

    @Override
    public void dispose() {
    }
}

