/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlogo.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ModelReader {
    public static final String SEPARATOR = "@#$#@#$#@";

    private ModelReader() {
        throw new IllegalStateException();
    }

    public static Set<Section> getSections() {
        return EnumSet.allOf(Section.class);
    }

    public static String[] getDefaultShapesV() {
        return Utils.getResourceAsStringArray("/system/defaultShapes.txt");
    }

    public static String[] getDefaultLinkShapes() {
        return Utils.getResourceAsStringArray("/system/defaultLinkShapes.txt");
    }

    public static Map<Section, String[]> parseString(String string) {
        return ModelReader.parseString(string, true);
    }

    public static Map<Section, String[]> parseString(String string, boolean checkVersion) {
        try {
            HashMap<Section, String[]> map2 = new HashMap<Section, String[]>();
            for (Section section : ModelReader.getSections()) {
                map2.put(section, new String[0]);
            }
            BufferedReader br = new BufferedReader(new StringReader(string));
            Iterator<Section> sectionsIter = ModelReader.getSections().iterator();
            ArrayList<String> sectionContents = new ArrayList<String>();
            while (sectionsIter.hasNext()) {
                String str = br.readLine();
                if (str == null || str.startsWith(SEPARATOR)) {
                    map2.put(sectionsIter.next(), sectionContents.toArray(new String[0]));
                    if (str == null) break;
                    sectionContents.clear();
                    continue;
                }
                sectionContents.add(str);
            }
            if (checkVersion && ((String[])map2.get((Object)Section.VERSION)).length == 0) {
                return null;
            }
            return map2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<List<String>> parseWidgets(String[] widgets) {
        int index;
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        for (index = 0; widgets.length > index && 0 == ModelReader.getString(widgets, index).length(); ++index) {
        }
        ArrayList<String> res = new ArrayList<String>();
        while (widgets.length > index) {
            String s = ModelReader.getString(widgets, index);
            if (0 != s.length()) {
                res.add(s);
            } else {
                boolean blank = true;
                for (int i = 0; res.size() != i; ++i) {
                    String elem = ((String)res.get(i)).toString();
                    if (elem.length() == 0) continue;
                    blank = false;
                    break;
                }
                if (!blank) {
                    ret.add(res);
                }
                res = new ArrayList();
            }
            ++index;
        }
        return ret;
    }

    public static String getString(String[] v, int index) {
        if (null != v && v.length > index) {
            return v[index];
        }
        return "";
    }

    public static String parseVersion(Map<Section, String[]> map2) {
        return map2.get((Object)Section.VERSION)[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum Section {
        SOURCE,
        WIDGETS,
        INFO,
        SHAPES,
        VERSION,
        PREVIEW_COMMANDS,
        AGGREGATE,
        EXPERIMENTS,
        CLIENT,
        LINK_SHAPES,
        MODEL_SETTINGS;

    }
}

