/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import org.nlogo.api.File;
import org.nlogo.util.Utils;

public strictfp class RemoteFile
extends File {
    private final String filepath;
    private String suffix = null;
    private File.Mode mode = File.Mode.NONE;
    private BufferedReader buffReader;

    public RemoteFile(String filepath) {
        this.filepath = filepath;
    }

    public RemoteFile(String filepath, String suffix) {
        String tmps;
        String tmpf;
        this.filepath = filepath != null && suffix != null ? ((tmpf = filepath.toLowerCase()).endsWith(tmps = suffix.toLowerCase()) ? filepath.substring(0, tmpf.lastIndexOf(tmps)) : filepath) : filepath;
        this.suffix = suffix;
    }

    public File.Mode getMode() {
        return this.mode;
    }

    public PrintWriter getPrintWriter() {
        return null;
    }

    public BufferedReader getBufferedReader() {
        return this.buffReader;
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new URL(Utils.escapeSpacesInURL(this.getPath())).openStream());
    }

    public static boolean exists(String path) {
        String url = Utils.escapeSpacesInURL(path);
        try {
            new URL(url).openStream();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void open(File.Mode mode) throws IOException {
        if (this.buffReader != null) {
            throw new IOException("Attempted to open an already open file");
        }
        String fullpath = this.suffix == null ? this.filepath : this.filepath + this.suffix;
        switch (mode) {
            case READ: {
                this.pos = 0L;
                this.eof = false;
                this.buffReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new URL(Utils.escapeSpacesInURL(fullpath)).openStream())));
                this.mode = mode;
                break;
            }
            case WRITE: {
                throw new IOException("Cannot write to remote files.");
            }
            case APPEND: {
                throw new IOException("Cannot append to remote files.");
            }
        }
    }

    public void print(String str) throws IOException {
        throw new IOException("Attempted to print to an unopened File");
    }

    public void println(String line) throws IOException {
        throw new IOException("Attempted to println to an unopened File");
    }

    public void println() throws IOException {
        throw new IOException("Attempted to println to an unopened File");
    }

    public void flush() {
    }

    public void close(boolean ok) throws IOException {
        if (this.buffReader == null) {
            return;
        }
        switch (this.mode) {
            case WRITE: 
            case APPEND: {
                break;
            }
            case READ: {
                this.buffReader.close();
                this.buffReader = null;
                break;
            }
        }
        this.mode = File.Mode.NONE;
    }

    public String getAbsolutePath() {
        return this.filepath;
    }

    public String getPath() {
        return this.filepath;
    }
}

