/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlogo.api.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ShapeList {
    public static final String DEFAULT_SHAPE_NAME = "default";
    private final Map<String, Shape> shapes = new HashMap<String, Shape>();

    public static boolean isDefaultShapeName(String name) {
        return name.equals(DEFAULT_SHAPE_NAME);
    }

    public Shape shape(String name) {
        Shape shape = this.shapes.get(name);
        return shape == null ? this.shapes.get(DEFAULT_SHAPE_NAME) : shape;
    }

    public List<Shape> getShapes() {
        ArrayList<Shape> currentShapes = new ArrayList<Shape>();
        for (Shape nextShape : this.shapes.values()) {
            if (ShapeList.isDefaultShapeName(nextShape.getName())) continue;
            currentShapes.add(nextShape);
        }
        List<Shape> sortedShapes = ShapeList.sortShapes(currentShapes);
        sortedShapes.add(0, this.shapes.get(DEFAULT_SHAPE_NAME));
        return sortedShapes;
    }

    public static final List<Shape> sortShapes(List<Shape> unsortedShapes) {
        ArrayList<Shape> result = new ArrayList<Shape>(unsortedShapes);
        Collections.sort(result, new Comparator<Shape>(){

            @Override
            public int compare(Shape shape1, Shape shape2) {
                return shape1.getName().compareTo(shape2.getName());
            }
        });
        return result;
    }

    public Set<String> getNames() {
        return this.shapes.keySet();
    }

    public boolean exists(String name) {
        return this.shapes.containsKey(name);
    }

    public void replaceShapes(Collection<Shape> newShapes) {
        this.shapes.clear();
        this.addAll(newShapes);
    }

    public Shape add(Shape newShape) {
        return this.shapes.put(newShape.getName(), newShape);
    }

    public void addAll(Collection<Shape> collection) {
        for (Shape shape : collection) {
            this.add(shape);
        }
    }

    public Shape removeShape(Shape shapeToRemove) {
        return this.shapes.remove(shapeToRemove.getName());
    }
}

