/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.nlogo.api.Version;

public class TestVersion {
    @Test
    public void testStringComparisonLogic() {
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0", "NetLogo 4.0.1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0.1", "NetLogo 4.0.1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0", "NetLogo 4.0"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0.2", "NetLogo 4.0.1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0.1", "NetLogo 4.0.1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0.1", "NetLogo 4.0.2"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0beta1", "NetLogo 4.0.1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0.1", "NetLogo 4.0beta1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0", "NetLogo 4.0beta1"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0beta1", "NetLogo 4.0"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0beta1", Version.noVersion()));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0pre1", "NetLogo 4.0"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0pre1", Version.noVersion()));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0alpha1", "NetLogo 4.0"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0othergarbage", "NetLogo 4.0"));
        Assert.assertTrue((boolean)Version.compareVersions("NetLogo 4.0alpha1", Version.noVersion()));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 4.1", "NetLogo 4.0beta1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 4.1", "NetLogo 4.0.1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 4.1", "NetLogo 4.0.2"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 4.1", "NetLogo 4.0"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 4.1", "NetLogo 4.0pre1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 4.1", "NetLogo 4.0alpha1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.1", "NetLogo 4.0beta1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.1", "NetLogo 4.0.1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.1", "NetLogo 4.0.2"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.1", "NetLogo 4.0"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.1", "NetLogo 4.0pre1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.1", "NetLogo 4.0alpha1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.0", "NetLogo 4.0beta1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.0", "NetLogo 4.0.1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.0", "NetLogo 4.0.2"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.0", "NetLogo 4.0"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.0", "NetLogo 4.0pre1"));
        Assert.assertFalse((boolean)Version.compareVersions("NetLogo 3.0", "NetLogo 4.0alpha1"));
        Assert.assertTrue((boolean)Version.compatibleVersion(Version.noVersion()));
    }

    @Test
    public void testDate() {
        String string = Version.buildDate();
        String string2 = "INTERIM DEVEL BUILD";
        Assume.assumeTrue(((string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
        SimpleDateFormat format = new SimpleDateFormat("MMMM d, yyyy");
        Date date = format.parse(Version.buildDate());
        Assert.assertEquals((Object)format.format(date), (Object)Version.buildDate());
        Assert.assertTrue((boolean)date.after(new SimpleDateFormat("y").parse("1998")));
        Assert.assertTrue((boolean)date.before(new SimpleDateFormat("y").parse("2100")));
    }

    @Test
    public void testOldVersions() {
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0beta1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0pre1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0alpha1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0.1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0.1weirdversion"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.0weirdversion"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1beta1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1pre1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1alpha1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1.1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1.1weirdversion"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.1weirdversion"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0beta1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0pre1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0alpha1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0.1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0.1weirdversion"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3.0weirdversion"));
    }

    @Test
    public void futureMinor() {
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2RC1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2beta1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2pre1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2alpha1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2.1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2.1weirdversion"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 4.2weirdversion"));
    }

    @Test
    public void currentVersion3D() {
        Assume.assumeTrue((boolean)Version.is3D());
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 3D 4.1pre1"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3D Preview 5"));
        Assert.assertFalse((boolean)Version.compatibleVersion("NetLogo 3D Preview 4"));
    }

    @Test
    public void currentVersion2D() {
        Assume.assumeTrue((!Version.is3D() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1RC1"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1beta1"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1pre1"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1alpha1"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1.1"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1.1weirdversion"));
        Assert.assertTrue((boolean)Version.compatibleVersion("NetLogo 4.1weirdversion"));
    }
}

