/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import org.nlogo.api.Matrix3D;

public strictfp class Vect {
    private static final double INFINITESIMAL = 3.2E-15;
    private final double x;
    private final double y;
    private final double z;

    public Vect(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Vect)) {
            return false;
        }
        Vect v2 = (Vect)other;
        return this.x == v2.x && this.y == v2.y && this.z == v2.z;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[" + this.x + " " + this.y + " " + this.z + "]";
    }

    public double magnitude() {
        return StrictMath.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    private double zeroify(double d) {
        return StrictMath.abs(d) < 3.2E-15 ? 0.0 : d;
    }

    public Vect invert() {
        return new Vect(-this.x, -this.y, -this.z);
    }

    public Vect add(Vect v) {
        return new Vect(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vect subtract(Vect v) {
        return new Vect(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public Vect correct() {
        return new Vect(this.zeroify(this.x), this.zeroify(this.y), this.zeroify(this.z));
    }

    public Vect normalize() {
        double mag = this.magnitude();
        return mag == 0.0 ? this : new Vect(this.x / mag, this.y / mag, this.z / mag);
    }

    public Vect rotateX(double delta) {
        double deltaRadians = StrictMath.toRadians(delta);
        double deltaSin = StrictMath.sin(deltaRadians);
        double deltaCos = StrictMath.cos(deltaRadians);
        return new Vect(this.x, this.y * deltaCos - this.z * deltaSin, this.y * deltaSin + this.z * deltaCos).correct();
    }

    public Vect rotateY(double delta) {
        double deltaRadians = StrictMath.toRadians(delta);
        double deltaSin = StrictMath.sin(deltaRadians);
        double deltaCos = StrictMath.cos(deltaRadians);
        return new Vect(this.z * deltaSin + this.x * deltaCos, this.y, this.z * deltaCos - this.x * deltaSin).correct();
    }

    public Vect rotateZ(double delta) {
        double deltaRadians = StrictMath.toRadians(delta);
        double deltaSin = StrictMath.sin(deltaRadians);
        double deltaCos = StrictMath.cos(deltaRadians);
        return new Vect(this.x * deltaCos - this.y * deltaSin, this.x * deltaSin + this.y * deltaCos, this.z).correct();
    }

    public Vect transform(Matrix3D trans) {
        double[] vec = new double[]{this.x, this.y, this.z};
        trans.transform(vec, vec, 1);
        return new Vect(vec[0], vec[1], vec[2]);
    }

    public double dot(Vect v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vect cross(Vect v) {
        return new Vect(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x).normalize();
    }

    public double angleTo(Vect v) {
        if (this.magnitude() == 0.0 || v.magnitude() == 0.0) {
            return 0.0;
        }
        double value = this.normalize().dot(v.normalize());
        double angle = StrictMath.acos(Vect.bindWithinOne(value));
        if (this.cross((Vect)v).z == -1.0) {
            return Math.PI * 2 - angle;
        }
        return angle;
    }

    private double angle(Vect v) {
        return StrictMath.acos(Vect.bindWithinOne(this.normalize().dot(v.normalize())));
    }

    public static Vect axisTransformation(Vect a, Vect u, Vect v, Vect w) {
        return new Vect(u.x * a.x + v.x * a.y + w.x * a.z, u.y * a.x + v.y * a.y + w.y * a.z, u.z * a.x + v.z * a.y + w.z * a.z).normalize();
    }

    public static Vect[] toVectors(double headingDegrees, double pitchDegrees, double rollDegrees) {
        double heading = StrictMath.toRadians(headingDegrees);
        double pitch = StrictMath.toRadians(pitchDegrees);
        double roll = StrictMath.toRadians(rollDegrees);
        Vect tmp1 = new Vect(StrictMath.sin(heading), StrictMath.cos(heading), StrictMath.tan(pitch)).normalize();
        Vect forward = pitch > 1.5707963267948966 && pitch <= 4.71238898038469 ? tmp1.invert().normalize() : tmp1;
        Vect right = new Vect(StrictMath.sin(heading + 1.5707963267948966), StrictMath.cos(heading + 1.5707963267948966), 0.0).normalize();
        Vect orthogonal = right.cross(forward);
        Vect tmp2 = new Vect(1.0, 0.0, -StrictMath.tan(roll));
        Vect standardRight = roll > 1.5707963267948966 && roll <= 4.71238898038469 ? tmp2.invert() : tmp2;
        return new Vect[]{forward, Vect.axisTransformation(standardRight.normalize(), right, forward, orthogonal)};
    }

    public static double[] toAngles(Vect forward, Vect right) {
        double pitchCalc = StrictMath.asin(Vect.bindWithinOne(forward.z));
        double h = new Vect(0.0, 1.0, 0.0).angle(new Vect(forward.x, forward.y, 0.0));
        double headingCalc = forward.x < 0.0 ? Math.PI * 2 - h : h;
        double r = right.angle(new Vect(StrictMath.sin(headingCalc + 1.5707963267948966), StrictMath.cos(headingCalc + 1.5707963267948966), 0.0));
        double rollCalc = right.z > 0.0 ? Math.PI * 2 - r : r;
        return new double[]{StrictMath.toDegrees(headingCalc), StrictMath.toDegrees(pitchCalc), StrictMath.toDegrees(rollCalc)};
    }

    private static double bindWithinOne(double num) {
        return num > 1.0 ? 1.0 : (num < -1.0 ? -1.0 : num);
    }
}

