/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.security.AccessControlException;
import org.nlogo.util.Exceptions;
import org.nlogo.util.SysInfo;
import org.nlogo.util.Utils;

public strictfp final class Version {
    private static final String PATH = "/system/version.txt";
    private static final String NO_VERSION;
    private static final String version;
    private static final String buildDate;
    private static final String[] knownVersions;

    private Version() {
        throw new IllegalStateException();
    }

    public static boolean is3D(String version) {
        if (version != null) {
            return version.indexOf("3D") != -1 || version.indexOf("3-D") != -1;
        }
        return false;
    }

    public static boolean is3D() {
        try {
            return Boolean.getBoolean("org.nlogo.is3d");
        }
        catch (AccessControlException ex) {
            Exceptions.ignore(ex);
            return false;
        }
    }

    public static boolean isLoggingEnabled() {
        try {
            return Boolean.getBoolean("org.nlogo.loggingEnabled");
        }
        catch (AccessControlException ex) {
            return false;
        }
    }

    public static boolean useOptimizer() {
        try {
            return !Boolean.getBoolean("org.nlogo.noOptimizer");
        }
        catch (AccessControlException ex) {
            Exceptions.ignore(ex);
            return false;
        }
    }

    public static boolean useGenerator() {
        try {
            if (Boolean.getBoolean("org.nlogo.noGenerator")) {
                return false;
            }
            Class.forName("org.nlogo.generator.Generator");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (AccessControlException ex) {
            return false;
        }
    }

    public static boolean knownVersion(String version) {
        version = Version.removeRev(version.trim());
        for (int i = 0; i < knownVersions.length; ++i) {
            if (!version.startsWith(knownVersions[i])) continue;
            return true;
        }
        return false;
    }

    public static String removeRev(String version) {
        if (version.lastIndexOf(" (Rev ") == version.length() - 8) {
            return version.substring(0, version.length() - 8);
        }
        return version;
    }

    public static String version() {
        return version;
    }

    public static String noVersion() {
        return NO_VERSION;
    }

    public static String versionNumberOnly() {
        return Version.version().substring("NetLogo ".length());
    }

    public static boolean compatibleVersion(String modelVersion) {
        return Version.compareVersions(version, modelVersion);
    }

    static boolean compareVersions(String appVersion, String modelVersion) {
        return modelVersion.equals(Version.noVersion()) || Version.versionNumber(modelVersion).startsWith(Version.versionNumber(appVersion));
    }

    static String versionNumber(String v) {
        if (v.startsWith("NetLogo 3D Preview")) {
            return v.substring("NetLogo 3D".length(), "NetLogo 3D Preview 5".length());
        }
        if (v.startsWith("NetLogo 3D")) {
            return v.substring("NetLogo 3D".length(), "NetLogo 3D 4.0".length());
        }
        return v.substring("NetLogo".length(), "NetLogo 4.0".length());
    }

    public static String buildDate() {
        return buildDate;
    }

    public static String fullVersion() {
        return version + " (" + buildDate + ") " + SysInfo.getSVNInfoString();
    }

    public static boolean olderThan13pre1(String version) {
        return version.startsWith("NetLogo 1.0") || version.startsWith("NetLogo 1.1") || version.startsWith("NetLogo 1.2");
    }

    public static boolean olderThan20alpha1(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0pre");
    }

    public static boolean olderThan20beta5(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0pre") || version.startsWith("NetLogo 2.0alpha") || version.startsWith("NetLogo 2.0beta1") || version.startsWith("NetLogo 2.0beta2") || version.startsWith("NetLogo 2.0beta3") || version.startsWith("NetLogo 2.0beta4");
    }

    public static boolean olderThan21beta3(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0") || version.startsWith("NetLogo 2.1pre") || version.startsWith("NetLogo 2.1beta1") || version.startsWith("NetLogo 2.1beta2");
    }

    public static boolean olderThan22pre3(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0") || version.startsWith("NetLogo 2.1") || version.startsWith("NetLogo 2.2pre1") || version.startsWith("NetLogo 2.2pre2");
    }

    public static boolean olderThan30pre5(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0pre1") || version.startsWith("NetLogo 3.0pre2") || version.startsWith("NetLogo 3.0pre3") || version.startsWith("NetLogo 3.0pre4");
    }

    public static boolean olderThan30beta1(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0pre");
    }

    public static boolean olderThan30beta2(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0pre") || version.startsWith("NetLogo 3.0beta1");
    }

    public static boolean olderThan30beta4(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0pre") || version.startsWith("NetLogo 3.0beta1") || version.startsWith("NetLogo 3.0beta2") || version.startsWith("NetLogo 3.0beta3");
    }

    public static boolean olderThan31pre1(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0");
    }

    public static boolean olderThan31pre2(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0") || version.startsWith("NetLogo 3.1pre1");
    }

    public static boolean olderThan31beta5(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0") || version.startsWith("NetLogo 3.1pre") || version.startsWith("NetLogo 3.1beta1") || version.startsWith("NetLogo 3.1beta2") || version.startsWith("NetLogo 3.1beta3") || version.startsWith("NetLogo 3.1beta4");
    }

    public static boolean olderThan32pre2(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0") || version.startsWith("NetLogo 3.1") || version.startsWith("NetLogo 3.2pre1");
    }

    public static boolean olderThan32pre3(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0") || version.startsWith("NetLogo 3.1") || version.startsWith("NetLogo 3.2pre1") || version.startsWith("NetLogo 3.2pre2");
    }

    public static boolean olderThan32pre4(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0") || version.startsWith("NetLogo 3.1") || version.startsWith("NetLogo 3.2pre1") || version.startsWith("NetLogo 3.2pre2") || version.startsWith("NetLogo 3.2pre3");
    }

    public static boolean olderThan32pre5(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.0") || version.startsWith("NetLogo 3.1") || version.startsWith("NetLogo 3.2pre1") || version.startsWith("NetLogo 3.2pre2") || version.startsWith("NetLogo 3.2pre3") || version.startsWith("NetLogo 3.2pre4");
    }

    public static boolean olderThan40pre1(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.");
    }

    public static boolean olderThan40pre3(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.") || version.startsWith("NetLogo 4.0pre1") || version.startsWith("NetLogo 4.0pre2");
    }

    public static boolean olderThan40pre4(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.") || version.startsWith("NetLogo 4.0pre1") || version.startsWith("NetLogo 4.0pre2") || version.startsWith("NetLogo 4.0pre3");
    }

    public static boolean olderThan40alpha3(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.") || version.startsWith("NetLogo 4.0pre") || version.startsWith("NetLogo 4.0alpha1") || version.startsWith("NetLogo 4.0alpha2");
    }

    public static boolean olderThan40beta2(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.") || version.startsWith("NetLogo 4.0pre") || version.startsWith("NetLogo 4.0alpha") || version.startsWith("NetLogo 4.0beta1");
    }

    public static boolean olderThan40beta4(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.") || version.startsWith("NetLogo 4.0pre") || version.startsWith("NetLogo 4.0alpha") || version.startsWith("NetLogo 4.0beta1") || version.startsWith("NetLogo 4.0beta2") || version.startsWith("NetLogo 4.0beta3");
    }

    public static boolean olderThan40beta5(String version) {
        return version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.") || version.startsWith("NetLogo 3.") || version.startsWith("NetLogo 4.0pre") || version.startsWith("NetLogo 4.0alpha") || version.startsWith("NetLogo 4.0beta1") || version.startsWith("NetLogo 4.0beta2") || version.startsWith("NetLogo 4.0beta3") || version.startsWith("NetLogo 4.0beta4");
    }

    public static boolean olderThan3DPreview3(String version) {
        return Version.is3D(version) && (version.startsWith("NetLogo 3-D Preview 1") || version.startsWith("NetLogo 3-D Preview 2"));
    }

    public static boolean olderThan3DPreview4(String version) {
        return Version.is3D(version) && (version.startsWith("NetLogo 3-D Preview 1") || version.startsWith("NetLogo 3-D Preview 2") || version.startsWith("NetLogo 3D Preview 3"));
    }

    public static boolean olderThan3DPreview5(String version) {
        return Version.is3D(version) && (version.startsWith("NetLogo 3-D Preview 1") || version.startsWith("NetLogo 3-D Preview 2") || version.startsWith("NetLogo 3D Preview 3") || version.startsWith("NetLogo 3D Preview 4"));
    }

    static {
        int i;
        String[] lines = Utils.getResourceAsStringArray(PATH);
        buildDate = lines[1];
        String[] lines2 = new String[]{"NetLogo 3D Preview 5", "NetLogo 3D Preview 4", "NetLogo 3D Preview 3", "NetLogo 3-D Preview 2", "NetLogo 3-D Preview 1"};
        if (Version.is3D()) {
            version = lines[0].replaceFirst("NetLogo", "NetLogo 3D");
            knownVersions = new String[lines.length * 2 + lines2.length - 2];
        } else {
            version = lines[0];
            knownVersions = new String[lines.length];
        }
        Version.knownVersions[0] = version;
        int j = 1;
        for (i = 2; i < lines.length; ++i) {
            Version.knownVersions[j] = lines[i];
            ++j;
        }
        if (Version.is3D()) {
            for (i = 2; i < lines.length; ++i) {
                Version.knownVersions[j] = "NetLogo 3D" + lines[i].substring("NetLogo".length());
                ++j;
            }
            for (i = 0; i < lines2.length; ++i) {
                Version.knownVersions[j] = lines2[i];
                ++j;
            }
        }
        Version.knownVersions[Version.knownVersions.length - 1] = NO_VERSION = Version.is3D() ? "NetLogo 3D (no version)" : "NetLogo (no version)";
    }
}

