/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public strictfp class RowLayout
implements LayoutManager {
    private final int hGap;
    private final float hAlign;
    private final float vAlign;

    public RowLayout(int hGap, float hAlign, float vAlign) {
        this.hGap = hGap;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void layoutContainer(Container target) {
        Dimension size = target.getSize();
        Insets insets = target.getInsets();
        int x = insets.left;
        if (this.hAlign == 1.0f) {
            x += size.width - this.minimumLayoutSize((Container)target).width;
        } else if (this.hAlign == 0.5f) {
            x += (size.width - this.minimumLayoutSize((Container)target).width) / 2;
        }
        for (int i = 0; i < target.getComponentCount(); ++i) {
            if (i > 0) {
                x += this.hGap;
            }
            Component comp = target.getComponent(i);
            Dimension pref = comp.getPreferredSize();
            int y = this.vAlign == 1.0f ? size.height - insets.top - insets.bottom - pref.height : (this.vAlign == 0.5f ? (size.height - insets.top - insets.bottom - pref.height) / 2 : 0);
            comp.setBounds(x, y + insets.top, pref.width, pref.height);
            x += pref.width;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        Insets insets = target.getInsets();
        int x = 0;
        int y = 0;
        for (int i = 0; i < target.getComponentCount(); ++i) {
            if (i > 0) {
                x += this.hGap;
            }
            Component comp = target.getComponent(i);
            Dimension pref = comp.getPreferredSize();
            x += pref.width;
            y = StrictMath.max(y, pref.height);
        }
        return new Dimension(insets.left + x + insets.right, insets.top + y + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.minimumLayoutSize(target);
    }
}

