/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.api.CompilerException;
import org.nlogo.api.TokenizerInterface;
import org.nlogo.api.Version;
import org.nlogo.compiler.AutoConverter2$;
import org.nlogo.compiler.DefaultAstVisitor;
import org.nlogo.compiler.IdentifierParser;
import org.nlogo.compiler.Replacement;
import org.nlogo.compiler.ReporterApp;
import org.nlogo.compiler.ReporterBlock;
import org.nlogo.compiler.Statement;
import org.nlogo.compiler.StructureParser;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Workspace;
import org.nlogo.prim._constdouble;
import org.nlogo.prim.dead._histogramfrom;
import org.nlogo.prim.dead._randomorrandomfloat;
import org.nlogo.prim.dead._valuefrom;
import org.nlogo.prim.dead._valuesfrom;
import org.nlogo.util.JCL$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public class AutoConverter2 {
    private final TokenizerInterface tokenizer;
    private final boolean ignoreErrors;
    private final Workspace workspace;

    public AutoConverter2(Workspace workspace, boolean ignoreErrors, TokenizerInterface tokenizer) {
        this.workspace = workspace;
        this.ignoreErrors = ignoreErrors;
        this.tokenizer = tokenizer;
    }

    private String runVisitor(String source2, boolean subprogram, boolean reporter) {
        String preamble = "";
        String postamble = "\nend";
        ObjectRef wrappedSource$1 = new ObjectRef(null);
        if (subprogram) {
            preamble = reporter ? "to-report __convertValueAndValuesFrom report " : "to __convertValueAndValuesFrom ";
            wrappedSource$1.elem = new scala.StringBuilder().append((Object)preamble).append((Object)source2).append((Object)postamble).toString();
        } else {
            wrappedSource$1.elem = source2;
        }
        StructureParser.Results results$1 = new StructureParser(this.tokenizer.tokenizeAllowingRemovedPrims((String)wrappedSource$1.elem), this.workspace.world().program(), this.workspace.getProcedures(), this.workspace.getExtensionManager(), this.tokenizer).parse(subprogram);
        IdentifierParser identifierParser$1 = new IdentifierParser(this.workspace.world().program(), this.workspace.getProcedures(), results$1.procedures(), true);
        ArrayBuffer replacements$1 = new ArrayBuffer();
        JCL$.MODULE$.iterableFromJava(results$1.procedures().values()).foreach(new $anonfun$runVisitor$1(this, wrappedSource$1, results$1, identifierParser$1, replacements$1));
        StringBuilder buf$1 = new StringBuilder(source2);
        IntRef offset$1 = new IntRef(-preamble.length());
        replacements$1.foreach(new $anonfun$runVisitor$2(this, buf$1, offset$1));
        if (!subprogram) {
            this.workspace.setProcedures(results$1.procedures());
        }
        return buf$1.toString();
    }

    public String convert(String originalSource, boolean subprogram, boolean reporter, String version) {
        CompilerException compilerException2;
        block4: {
            String source2 = originalSource;
            if (source2.trim().length() == 0) {
                return source2;
            }
            if (Version.olderThan32pre4(version) || Version.olderThan3DPreview4(version)) {
                try {
                    source2 = this.runVisitor(source2, subprogram, reporter);
                }
                catch (CompilerException compilerException2) {
                    if (!this.ignoreErrors) break block4;
                }
                this.workspace.world().realloc();
            }
            return source2;
        }
        throw new IllegalStateException(compilerException2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AutoConverterVisitor
    extends DefaultAstVisitor {
        public final /* synthetic */ AutoConverter2 $outer;
        private final String source;
        private final ArrayBuffer<Replacement> replacements;

        public AutoConverterVisitor(AutoConverter2 $outer, ArrayBuffer<Replacement> replacements, String source2) {
            this.replacements = replacements;
            this.source = source2;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void visitStatement(Statement stmt) {
            Command oldCommand = stmt.command();
            if (oldCommand instanceof _histogramfrom) {
                ReporterBlock arg1 = (ReporterBlock)stmt.apply(1);
                int start = arg1.start();
                this.replacements.$plus$eq(new Replacement(oldCommand.token().startPos(), oldCommand.token().endPos(), oldCommand.token().name(), new scala.StringBuilder().append((Object)"histogram ").append((Object)this.source.substring(start, arg1.end())).append((Object)" of").toString()));
                if (start > 0 && this.source.charAt(start - 1) == ' ') {
                    --start;
                }
                this.replacements.$plus$eq(new Replacement(start, arg1.end(), this.source.substring(start, arg1.end()), ""));
            }
            super.visitStatement(stmt);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitReporterApp(ReporterApp app) {
            block6: {
                block5: {
                    oldReporter = app.reporter();
                    var3_3 = oldReporter;
                    if (!(var3_3 instanceof _valuefrom) && !(var3_3 instanceof _valuesfrom)) break block5;
                    arg1 = (ReporterBlock)app.apply(1);
                    this.replacements.$plus$eq(new Replacement(app.reporter().token().startPos(), app.reporter().token().endPos(), app.reporter().token().name(), new scala.StringBuilder().append((Object)this.source.substring(arg1.start(), arg1.end())).append((Object)" of").toString()));
                    start = arg1.start();
                    if (start > 0 && this.source.charAt(start - 1) == ' ') {
                        --start;
                    }
                    this.replacements.$plus$eq(new Replacement(start, arg1.end(), this.source.substring(start, arg1.end()), ""));
                    break block6;
                }
                if (!(var3_3 instanceof _randomorrandomfloat)) break block6;
                choice = null;
                arg = ((ReporterApp)app.apply(0)).reporter();
                if (!(arg instanceof _constdouble)) ** GOTO lbl-1000
                if (((_constdouble)arg).report(null) instanceof Double) {
                    choice = arg.token().name().indexOf(46) == -1 ? "random" : "random-float";
                } else if (arg.token().name().equalsIgnoreCase("WORLD-WIDTH") || arg.token().name().equalsIgnoreCase("WORLD-HEIGHT") || arg.token().name().equalsIgnoreCase("MAX-PXCOR") || arg.token().name().equalsIgnoreCase("MAX-PYCOR")) {
                    choice = "random";
                }
                var8_8 = choice;
                if (var8_8 != null && !var8_8.equals(null)) {
                    this.replacements.$plus$eq(new Replacement(oldReporter.token().startPos(), oldReporter.token().endPos(), oldReporter.token().name(), choice));
                }
            }
            super.visitReporterApp(app);
        }
    }
}

