/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nlogo.api.Program;
import org.nlogo.api.Token;
import org.nlogo.api.TokenType;
import org.nlogo.compiler.Instantiator$;
import org.nlogo.nvm.Instruction;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BreedIdentifierHandler {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        private final Pattern pattern;
        private final Function1<Object, Boolean> isValidBreed;
        private final Function1<Program, Map<String, String>> singularMap;
        private final Function1<Program, Map<String, Object>> breeds;
        private final Class<? extends Instruction> primClass;
        private final boolean singular;
        private final TokenType tokenType;

        public Helper(String patternString, TokenType tokenType, boolean singular, Class<? extends Instruction> primClass, Function1<Program, Map<String, Object>> breeds, Function1<Program, Map<String, String>> singularMap, Function1<Object, Boolean> isValidBreed) {
            this.tokenType = tokenType;
            this.singular = singular;
            this.primClass = primClass;
            this.breeds = breeds;
            this.singularMap = singularMap;
            this.isValidBreed = isValidBreed;
            this.pattern = Pattern.compile(new StringBuilder().append((Object)"\\A").append((Object)patternString.replaceAll("\\?", "\\\\?").replaceAll("\\*", "(.+)")).append((Object)"\\Z").toString());
        }

        public Option<Token> process(Token tok, Program program) {
            Matcher matcher = this.pattern().matcher((String)tok.value());
            if (matcher.matches()) {
                Map<String, Object> map2;
                String name = matcher.group(1);
                Map<String, Object> map3 = map2 = this.singular ? this.singularMap.apply(program) : this.breeds.apply(program);
                if (map2.containsKey(name)) {
                    String breedName;
                    String string = breedName = this.singular ? map2.get(name) : name;
                    if (BoxesRunTime.unboxToBoolean(this.isValidBreed.apply(this.breeds.apply(program).get(breedName)))) {
                        Instruction instr = Instantiator$.MODULE$.newInstance(this.primClass, ScalaRunTime$.MODULE$.boxArray(new Object[]{breedName}));
                        Token tok2 = new Token((String)tok.value(), this.tokenType, instr, tok.startPos(), tok.endPos(), tok.fileName());
                        instr.token(tok2);
                        return new Some<Token>(tok2);
                    }
                    return None$.MODULE$;
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }

        public Pattern pattern() {
            return this.pattern;
        }
    }
}

