/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.File;
import org.nlogo.api.Program;
import org.nlogo.api.Token;
import org.nlogo.api.TokenMapperInterface;
import org.nlogo.api.TokenReaderInterface;
import org.nlogo.api.TokenizerInterface;
import org.nlogo.compiler.AutoConverter1;
import org.nlogo.compiler.AutoConverter2;
import org.nlogo.compiler.Compiler$;
import org.nlogo.compiler.CompilerMain$;
import org.nlogo.compiler.ConstantParser;
import org.nlogo.compiler.IdentifierParser;
import org.nlogo.compiler.StructureParser;
import org.nlogo.compiler.StructureParserExtras;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import org.nlogo.util.Femto;
import org.nlogo.util.JCL$;
import scala.Iterator;
import scala.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Compiler$
implements CompilerInterface {
    public static final Compiler$ MODULE$;
    private final Map<String, Procedure> noProcedures;
    private final TokenMapperInterface TokenMapper2D;
    private final TokenizerInterface Tokenizer3D;
    private final TokenizerInterface Tokenizer2D;

    static {
        new Compiler$();
    }

    private Compiler$() {
        MODULE$ = this;
        this.Tokenizer2D = Femto.scalaSingleton(TokenizerInterface.class, "org.nlogo.lex.Tokenizer2D");
        this.Tokenizer3D = Femto.scalaSingleton(TokenizerInterface.class, "org.nlogo.lex.Tokenizer3D");
        this.TokenMapper2D = Femto.scalaSingleton(TokenMapperInterface.class, "org.nlogo.lex.TokenMapper2D");
        this.noProcedures = Collections.emptyMap();
    }

    @Override
    public Token[] tokenizeForColorization(String source2, ExtensionManager extensionManager, boolean is3D) {
        return this.tokenizer(is3D).tokenizeForColorization(source2, extensionManager);
    }

    @Override
    public Token getTokenAtPosition(String source2, int position) {
        return this.tokenizer(false).getTokenAtPosition(source2, position);
    }

    @Override
    public boolean isValidIdentifier(String s, boolean is3D) {
        return this.tokenizer(is3D).isValidIdentifier(s);
    }

    public Map<String, String> findIncludes(String sourceFileName, String source2, boolean is3D) {
        return new StructureParserExtras(this.tokenizer(is3D)).findIncludes(sourceFileName, source2);
    }

    @Override
    public Map<String, List<Object>> findProcedurePositions(String source2, boolean is3D) {
        return new StructureParserExtras(this.tokenizer(is3D)).findProcedurePositions(source2);
    }

    @Override
    public Object readFromFile(File currFile, org.nlogo.api.World world, ExtensionManager extensionManager) throws CompilerException, IOException {
        Iterator tokens = Femto.get(TokenReaderInterface.class, "org.nlogo.lex.TokenReader", currFile, this.tokenizer(world.program().is3D));
        Object result = new ConstantParser((World)world, extensionManager).getConstantFromFile(tokens);
        boolean done = false;
        while (!done) {
            currFile.getBufferedReader().mark(1);
            ++currFile.pos;
            int i = currFile.getBufferedReader().read();
            if (i != -1 && Character.isWhitespace(i)) continue;
            currFile.getBufferedReader().reset();
            --currFile.pos;
            done = true;
        }
        return result;
    }

    @Override
    public Double readNumberFromString(String source2, org.nlogo.api.World world, ExtensionManager extensionManager, boolean is3D) throws CompilerException {
        return new ConstantParser((World)world, extensionManager).getNumberValue(this.tokenizer(is3D).tokenize(source2).elements());
    }

    @Override
    public Object readFromString(String source2, org.nlogo.api.World world, ExtensionManager extensionManager, boolean is3D) throws CompilerException {
        return new ConstantParser((World)world, extensionManager).getConstantValue(this.tokenizer(is3D).tokenize(source2).elements());
    }

    @Override
    public Object readFromString(String source2, boolean is3D) throws CompilerException {
        return new ConstantParser().getConstantValue(this.tokenizer(is3D).tokenize(source2).elements());
    }

    @Override
    public String autoConvert(String source2, boolean subprogram, boolean reporter, String version, Object w, boolean ignoreErrors, boolean is3D) {
        Workspace workspace = (Workspace)w;
        String result1 = new AutoConverter1(this.tokenizer(is3D)).convert(source2, subprogram, reporter, version);
        return new AutoConverter2(workspace, ignoreErrors, this.tokenizer(is3D)).convert(result1, subprogram, reporter, version);
    }

    private void checkSyntax(String source2, boolean subprogram, Program program, Map<String, Procedure> oldProcedures, ExtensionManager extensionManager, boolean parse$1) throws CompilerException {
        TokenizerInterface t = this.tokenizer(program.is3D);
        StructureParser.Results results$1 = new StructureParser(t.tokenizeRobustly(source2), program, oldProcedures, extensionManager, t).parse(subprogram);
        IdentifierParser identifierParser$1 = new IdentifierParser(program, this.noProcedures(), results$1.procedures(), !parse$1);
        JCL$.MODULE$.iterableFromJava(results$1.procedures().values()).foreach(new anonfun.checkSyntax.1(parse$1, results$1, identifierParser$1));
    }

    @Override
    public void checkReporterSyntax(String string, Program program, Map<String, Procedure> map2, ExtensionManager extensionManager, boolean bl) throws CompilerException {
        this.checkSyntax(new StringBuilder().append((Object)"to-report __bogus-name report ").append((Object)string).append((Object)"\nend").toString(), true, program, map2, extensionManager, bl);
    }

    @Override
    public void checkCommandSyntax(String string, Program program, Map<String, Procedure> map2, ExtensionManager extensionManager, boolean bl) throws CompilerException {
        this.checkSyntax(new StringBuilder().append((Object)"to __bogus-name ").append((Object)string).append((Object)"\nend").toString(), true, program, map2, extensionManager, bl);
    }

    @Override
    public Procedure compileMoreCode(String source2, Program program, Map<String, Procedure> oldProcedures, ExtensionManager extensionManager) throws CompilerException {
        return CompilerMain$.MODULE$.compile(source2, program, oldProcedures, true, extensionManager).values().iterator().next();
    }

    @Override
    public CompilerResults compileProgram(String source2, Program program, ExtensionManager extensionManager) throws CompilerException {
        return new CompilerResults(CompilerMain$.MODULE$.compile(source2, program, this.noProcedures(), false, extensionManager), program);
    }

    private TokenizerInterface tokenizer(boolean is3D) {
        return is3D ? this.Tokenizer3D() : this.Tokenizer2D();
    }

    private Map<String, Procedure> noProcedures() {
        return this.noProcedures;
    }

    public TokenMapperInterface TokenMapper2D() {
        return this.TokenMapper2D;
    }

    public TokenizerInterface Tokenizer3D() {
        return this.Tokenizer3D;
    }

    public TokenizerInterface Tokenizer2D() {
        return this.Tokenizer2D;
    }
}

