/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.compiler.AstNode;
import org.nlogo.compiler.CompilerExceptionThrowers$;
import org.nlogo.compiler.DefaultAstVisitor;
import org.nlogo.compiler.Expression;
import org.nlogo.compiler.ProcedureDefinition;
import org.nlogo.compiler.ReporterApp;
import org.nlogo.compiler.Statement;
import org.nlogo.compiler.TemplateVisitor$;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import org.nlogo.prim._filter;
import org.nlogo.prim._foreach;
import org.nlogo.prim._map;
import org.nlogo.prim._nvalues;
import org.nlogo.prim._reduce;
import org.nlogo.prim._sortby;
import org.nlogo.prim._templatevariable;
import scala.Seq;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateVisitor
extends DefaultAstVisitor {
    private Procedure procedure = null;
    private int numberBound = 0;
    private int currentIndex = -1;

    public void visitVariable(_templatevariable ins) {
        if (ins.getVarNumber() > this.numberBound()) {
            throw CompilerExceptionThrowers$.MODULE$.exception(TemplateVisitor$.MODULE$.OUT_OF_SCOPE(), ins.token());
        }
        ins.setSlotNumber(this.currentIndex() - this.numberBound() + ins.getVarNumber());
    }

    public void visitFilter(_filter ins, Seq<Expression> args) {
        int temp = this.numberBound();
        this.numberBound_$eq(1);
        this.currentIndex_$eq(this.currentIndex() + 1);
        if (this.currentIndex() > this.procedure().getNumSlots() - 1) {
            Procedure procedure = this.procedure();
            ++procedure.templateVars;
        }
        ins.setVarIndex(this.currentIndex());
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(0))).accept(this);
        this.currentIndex_$eq(this.currentIndex() - 1);
        this.numberBound_$eq(temp);
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(1))).accept(this);
    }

    public void visitNValues(_nvalues ins, Seq<Expression> args) {
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(0))).accept(this);
        int temp = this.numberBound();
        this.numberBound_$eq(1);
        this.currentIndex_$eq(this.currentIndex() + 1);
        if (this.currentIndex() > this.procedure().getNumSlots() - 1) {
            Procedure procedure = this.procedure();
            ++procedure.templateVars;
        }
        ins.setVarIndex(this.currentIndex());
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(1))).accept(this);
        this.currentIndex_$eq(this.currentIndex() - 1);
        this.numberBound_$eq(temp);
    }

    public void visitReduce(_reduce ins, Seq<Expression> args) {
        int temp = this.numberBound();
        this.numberBound_$eq(2);
        this.currentIndex_$eq(this.currentIndex() + 2);
        while (this.currentIndex() > this.procedure().getNumSlots() - 1) {
            Procedure procedure = this.procedure();
            ++procedure.templateVars;
        }
        ins.setLeftVarIndex(this.currentIndex() - 1);
        ins.setRightVarIndex(this.currentIndex());
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(0))).accept(this);
        this.currentIndex_$eq(this.currentIndex() - 2);
        this.numberBound_$eq(temp);
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(1))).accept(this);
    }

    public void visitSortBy(_sortby ins, Seq<Expression> args) {
        int temp = this.numberBound();
        this.numberBound_$eq(2);
        this.currentIndex_$eq(this.currentIndex() + 2);
        while (this.currentIndex() > this.procedure().getNumSlots() - 1) {
            Procedure procedure = this.procedure();
            ++procedure.templateVars;
        }
        ins.setLeftVarIndex(this.currentIndex() - 1);
        ins.setRightVarIndex(this.currentIndex());
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(0))).accept(this);
        this.currentIndex_$eq(this.currentIndex() - 2);
        this.numberBound_$eq(temp);
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(1))).accept(this);
    }

    public void visitForeach(_foreach ins, Seq<Expression> args) {
        args.take(args.size() - 1).foreach(new $anonfun$visitForeach$1(this));
        int temp = this.numberBound();
        this.numberBound_$eq(args.size() + 1);
        this.currentIndex_$eq(this.currentIndex() + this.numberBound());
        while (this.currentIndex() > this.procedure().getNumSlots() - 1) {
            Procedure procedure = this.procedure();
            ++procedure.templateVars;
        }
        ins.setFirstVarIndex(this.currentIndex() - this.numberBound() + 1);
        ((AstNode)args.last()).accept(this);
        this.currentIndex_$eq(this.currentIndex() - this.numberBound());
        this.numberBound_$eq(temp);
    }

    private void visitMap(_map ins, Seq<Expression> args) {
        int temp = this.numberBound();
        this.numberBound_$eq(args.size() - 1);
        this.currentIndex_$eq(this.currentIndex() + this.numberBound());
        while (this.currentIndex() > this.procedure().getNumSlots() - 1) {
            Procedure procedure = this.procedure();
            ++procedure.templateVars;
        }
        ins.setFirstVarIndex(this.currentIndex() - this.numberBound() + 1);
        ((AstNode)args.apply(BoxesRunTime.boxToInteger(0))).accept(this);
        this.currentIndex_$eq(this.currentIndex() - this.numberBound());
        this.numberBound_$eq(temp);
        args.drop(1).foreach(new $anonfun$visitMap$1(this));
    }

    @Override
    public void visitStatement(Statement stmt) {
        Command command = stmt.command();
        if (command instanceof _foreach) {
            this.visitForeach((_foreach)command, stmt.args());
        } else {
            super.visitStatement(stmt);
        }
    }

    @Override
    public void visitReporterApp(ReporterApp app) {
        Reporter reporter = app.reporter();
        if (reporter instanceof _map) {
            this.visitMap((_map)reporter, app.args());
        } else if (reporter instanceof _filter) {
            this.visitFilter((_filter)reporter, app.args());
        } else if (reporter instanceof _nvalues) {
            this.visitNValues((_nvalues)reporter, app.args());
        } else if (reporter instanceof _sortby) {
            this.visitSortBy((_sortby)reporter, app.args());
        } else if (reporter instanceof _reduce) {
            this.visitReduce((_reduce)reporter, app.args());
        } else if (reporter instanceof _templatevariable) {
            this.visitVariable((_templatevariable)reporter);
        } else {
            super.visitReporterApp(app);
        }
    }

    @Override
    public void visitProcedureDefinition(ProcedureDefinition procdef) {
        this.procedure_$eq(procdef.procedure());
        this.currentIndex_$eq(this.procedure().getNumSlots() - 1);
        super.visitProcedureDefinition(procdef);
    }

    private void procedure_$eq(Procedure x$1) {
        this.procedure = x$1;
    }

    private Procedure procedure() {
        return this.procedure;
    }

    private void numberBound_$eq(int x$1) {
        this.numberBound = x$1;
    }

    private int numberBound() {
        return this.numberBound;
    }

    private void currentIndex_$eq(int x$1) {
        this.currentIndex = x$1;
    }

    private int currentIndex() {
        return this.currentIndex;
    }
}

