/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lex;

import java.io.IOException;
import java.io.Reader;
import org.nlogo.api.StringUtils;
import org.nlogo.api.Token;
import org.nlogo.api.TokenHolder;
import org.nlogo.api.TokenType;
import org.nlogo.lex.TokenMapper;

class TokenLexer {
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    private static final char[] ZZ_CMAP = TokenLexer.zzUnpackCMap("\b\u0000\u0002\u0005\u0001\u0006\u0002\u0000\u0001\u0004\u0012\u0000\u0001\u0005\u0001\u0003\u0001\u0002\u0005\u0003\u0001\r\u0001\u000e\u0002\u0003\u0001\n\u0001\u0010\u0001\u0011\u0001\u0003\n\u0012\u0001\u0003\u0001\u000f\u0004\u0003\u0001\u0000\u001a\u0003\u0001\u000b\u0001\u0001\u0001\f\u0001\u0003\u0001\u0007\u0001\u0000\r\u0003\u0001\u0003\u0003\u0003\u0001\u0003\u0001\u0003\u0001\u0003\u0006\u0003\u0001\b\u0001\u0000\u0001\t\uff82\u0000");
    private static final int[] ZZ_ACTION = TokenLexer.zzUnpackAction();
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yychar;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private final TokenMapper tokenMapper;
    private final String fileName;
    private final boolean allowRemovedPrimitives;

    private static int[] zzUnpackAction() {
        int[] result = new int[28];
        int offset = 0;
        offset = TokenLexer.zzUnpackAction("\u0001\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0002\u0005\u0001\u0002\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0002\u0004\u0001\u000e\u0001\u0001\u0001\u000f\u0001\u0000\u0001\u0010\u0002\u0000\u0001\u0011\u0001\u0000\u0001\u0012", offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    Token literal() {
        String text = this.yytext();
        return new Token(text, TokenType.LITERAL, text, this.yychar, this.yychar + text.length(), this.fileName);
    }

    Token ident() {
        String text = this.yytext();
        if (this.tokenMapper.isKeyword(text)) {
            return new Token(text, TokenType.KEYWORD, text.toUpperCase(), this.yychar, this.yychar + text.length(), this.fileName);
        }
        if (this.tokenMapper.isCommand(text.toUpperCase()) && (this.allowRemovedPrimitives || !this.tokenMapper.wasRemoved(text.toUpperCase()))) {
            TokenHolder instr = this.tokenMapper.getCommand(text);
            Token tok = new Token(text, TokenType.COMMAND, instr, this.yychar, this.yychar + text.length(), this.fileName);
            instr.token(tok);
            return tok;
        }
        if (this.tokenMapper.isReporter(text) && (this.allowRemovedPrimitives || !this.tokenMapper.wasRemoved(text.toUpperCase()))) {
            TokenHolder instr = this.tokenMapper.getReporter(text);
            Token tok = new Token(text, TokenType.REPORTER, instr, this.yychar, this.yychar + text.length(), this.fileName);
            instr.token(tok);
            return tok;
        }
        if (this.tokenMapper.isVariable(text)) {
            return new Token(text, TokenType.VARIABLE, text.toUpperCase(), this.yychar, this.yychar + text.length(), this.fileName);
        }
        if (this.tokenMapper.isConstant(text)) {
            return new Token(text, TokenType.CONSTANT, this.tokenMapper.getConstant(text), this.yychar, this.yychar + text.length(), this.fileName);
        }
        return new Token(text, TokenType.IDENT, text.toUpperCase(), this.yychar, this.yychar + text.length(), this.fileName);
    }

    TokenLexer(Reader in, TokenMapper tokenMapper, String fileName, boolean allowRemovedPrimitives) {
        this.tokenMapper = tokenMapper;
        this.fileName = fileName;
        this.allowRemovedPrimitives = allowRemovedPrimitives;
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map2 = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 80) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map2[j++] = value;
            } while (--count > 0);
        }
        return map2;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public Token yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        block129: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            block130: while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                zzInput = zzCMapL[zzInput];
                boolean zzIsFinal = false;
                boolean zzNoLookAhead = false;
                block2 : switch (this.zzState) {
                    case 0: {
                        switch (zzInput) {
                            case 2: {
                                zzIsFinal = true;
                                this.zzState = 3;
                                break block2;
                            }
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 4;
                                break block2;
                            }
                            case 4: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 5;
                                break block2;
                            }
                            case 5: 
                            case 6: {
                                zzIsFinal = true;
                                this.zzState = 6;
                                break block2;
                            }
                            case 7: {
                                zzIsFinal = true;
                                this.zzState = 7;
                                break block2;
                            }
                            case 8: {
                                zzIsFinal = true;
                                this.zzState = 8;
                                break block2;
                            }
                            case 9: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 9;
                                break block2;
                            }
                            case 10: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 10;
                                break block2;
                            }
                            case 11: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 11;
                                break block2;
                            }
                            case 12: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 12;
                                break block2;
                            }
                            case 13: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 13;
                                break block2;
                            }
                            case 14: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 14;
                                break block2;
                            }
                            case 15: {
                                zzIsFinal = true;
                                this.zzState = 15;
                                break block2;
                            }
                            case 16: {
                                zzIsFinal = true;
                                this.zzState = 16;
                                break block2;
                            }
                            case 17: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block2;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block2;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 2;
                        break;
                    }
                    case 1: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 19;
                                break block2;
                            }
                            case 6: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 20;
                                break block2;
                            }
                        }
                        zzIsFinal = true;
                        zzNoLookAhead = true;
                        this.zzState = 2;
                        break;
                    }
                    case 3: {
                        switch (zzInput) {
                            case 1: {
                                this.zzState = 21;
                                break;
                            }
                            case 2: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 22;
                                break;
                            }
                            case 4: 
                            case 6: {
                                break block130;
                            }
                            default: {
                                zzIsFinal = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 6: {
                        switch (zzInput) {
                            case 5: 
                            case 6: {
                                zzIsFinal = true;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 7: {
                        switch (zzInput) {
                            case 3: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 4;
                                break block2;
                            }
                            case 7: {
                                this.zzState = 23;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 8: {
                        switch (zzInput) {
                            case 8: {
                                this.zzState = 24;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 15: {
                        switch (zzInput) {
                            case 6: {
                                break block130;
                            }
                            default: {
                                zzIsFinal = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 16: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: {
                                zzIsFinal = true;
                                this.zzState = 4;
                                break block2;
                            }
                            case 17: {
                                zzIsFinal = true;
                                this.zzState = 17;
                                break block2;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 17: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: {
                                zzIsFinal = true;
                                this.zzState = 4;
                                break block2;
                            }
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 18;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 18: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 19: {
                        switch (zzInput) {
                            case 3: 
                            case 7: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 21: {
                        switch (zzInput) {
                            default: 
                        }
                        zzIsFinal = true;
                        this.zzState = 3;
                        break;
                    }
                    case 23: {
                        switch (zzInput) {
                            case 3: 
                            case 16: 
                            case 17: 
                            case 18: {
                                zzIsFinal = true;
                                this.zzState = 4;
                                break block2;
                            }
                            case 7: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 25;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    case 24: {
                        switch (zzInput) {
                            case 9: {
                                this.zzState = 26;
                                break block2;
                            }
                        }
                        break;
                    }
                    case 26: {
                        switch (zzInput) {
                            case 9: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 27;
                                break block2;
                            }
                        }
                        break block130;
                    }
                    default: {
                        this.zzScanError(0);
                    }
                }
                if (!zzIsFinal) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if (zzNoLookAhead) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 3: {
                    String text = this.yytext();
                    return new Token(text, TokenType.BAD, "Closing double quote is missing", this.yychar, this.yychar + this.yytext().length(), this.fileName);
                }
                case 19: {
                    continue block129;
                }
                case 14: {
                    String text = this.yytext();
                    try {
                        long l;
                        Double d = Double.valueOf(text);
                        if (d.isInfinite()) {
                            return new Token(text, TokenType.BAD, "Number too large", this.yychar, this.yychar + text.length(), this.fileName);
                        }
                        if (text.indexOf(46) == -1 && text.indexOf(101) == -1 && text.indexOf(69) == -1 && ((l = Long.valueOf(text).longValue()) > 0x20000000000000L || l < -9007199254740992L)) {
                            return new Token(text, TokenType.BAD, text + " is too large to be represented exactly as an integer in NetLogo", this.yychar, this.yychar + text.length(), this.fileName);
                        }
                        return new Token(text, TokenType.CONSTANT, d, this.yychar, this.yychar + text.length(), this.fileName);
                    }
                    catch (NumberFormatException ex) {
                        return new Token(text, TokenType.BAD, "Illegal number format", this.yychar, this.yychar + text.length(), this.fileName);
                    }
                }
                case 20: {
                    continue block129;
                }
                case 15: {
                    this.yybegin(0);
                }
                case 21: {
                    continue block129;
                }
                case 8: {
                    return new Token(this.yytext(), TokenType.COMMA, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 22: {
                    continue block129;
                }
                case 6: {
                    return new Token(this.yytext(), TokenType.OPEN_BRACE, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 23: {
                    continue block129;
                }
                case 4: {
                    return this.ident();
                }
                case 24: {
                    continue block129;
                }
                case 10: {
                    return new Token(this.yytext(), TokenType.CLOSE_BRACKET, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 25: {
                    continue block129;
                }
                case 17: {
                    this.yybegin(2);
                    TokenHolder cmd = this.tokenMapper.getCommand("__magic-open");
                    Token token = new Token("__magic-open", TokenType.COMMAND, cmd, this.yychar, this.yychar + 3, this.fileName);
                    cmd.token(token);
                    return token;
                }
                case 26: {
                    continue block129;
                }
                case 9: {
                    return new Token(this.yytext(), TokenType.OPEN_BRACKET, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 27: {
                    continue block129;
                }
                case 2: {
                    String text = this.yytext();
                    return new Token(text, TokenType.BAD, "This non-standard character is not allowed.", this.yychar, this.yychar + 1, this.fileName);
                }
                case 28: {
                    continue block129;
                }
                case 18: {
                    return this.literal();
                }
                case 29: {
                    continue block129;
                }
                case 13: {
                    String text = this.yytext();
                    return new Token(text, TokenType.COMMENT, null, this.yychar, this.yychar + text.length(), this.fileName);
                }
                case 30: {
                    continue block129;
                }
                case 16: {
                    String text = this.yytext();
                    try {
                        return new Token(text, TokenType.CONSTANT, StringUtils.unEscapeString(text.substring(1, text.length() - 1)), this.yychar, this.yychar + text.length(), this.fileName);
                    }
                    catch (IllegalArgumentException ex) {
                        return new Token(text, TokenType.BAD, "Illegal character after backslash", this.yychar, this.yychar + text.length(), this.fileName);
                    }
                }
                case 31: {
                    continue block129;
                }
                case 1: {
                    String text = this.yytext();
                    this.yybegin(0);
                    return new Token("\"" + text + "\"", TokenType.CONSTANT, text, this.yychar, this.yychar + text.length(), this.fileName);
                }
                case 32: {
                    continue block129;
                }
                case 7: {
                    return new Token(this.yytext(), TokenType.CLOSE_BRACE, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 33: {
                    continue block129;
                }
                case 11: {
                    return new Token(this.yytext(), TokenType.OPEN_PAREN, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 34: {
                    continue block129;
                }
                case 5: 
                case 35: {
                    continue block129;
                }
                case 12: {
                    return new Token(this.yytext(), TokenType.CLOSE_PAREN, null, this.yychar, this.yychar + 1, this.fileName);
                }
                case 36: {
                    continue block129;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

