/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lex;

import java.io.BufferedReader;
import java.io.StringReader;
import org.nlogo.api.Command;
import org.nlogo.api.CompilerException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Primitive;
import org.nlogo.api.Token;
import org.nlogo.api.TokenType;
import org.nlogo.api.TokenizerInterface;
import org.nlogo.lex.TokenLexer;
import org.nlogo.lex.TokenMapper;
import org.nlogo.lex.Tokenizer$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Seq;
import scala.Seq$;
import scala.Some;
import scala.Stream;
import scala.Stream$;
import scala.Stream$cons$;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer
implements TokenizerInterface {
    private final TokenMapper tokenMapper;

    public Tokenizer(TokenMapper tokenMapper) {
        this.tokenMapper = tokenMapper;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Token replaceImports$1(Token token, ExtensionManager extensionManager) {
        Token token2;
        if (extensionManager.anyExtensionsLoaded()) {
            TokenType tokenType = token.tyype();
            TokenType tokenType2 = TokenType.IDENT;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                Primitive primitive = extensionManager.replaceIdentifier((String)token.value());
                if (primitive == null) {
                    token2 = token;
                    return token2;
                }
                Primitive prim = primitive;
                TokenType newType = prim instanceof Command ? TokenType.COMMAND : TokenType.REPORTER;
                token2 = new Token(token.name(), newType, token.value(), token.startPos(), token.endPos(), token.fileName());
                return token2;
            }
        }
        token2 = token;
        return token2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Stream yystream$1(boolean bl, TokenLexer tokenLexer, Token token) {
        Stream<Object> stream;
        Token t = tokenLexer.yylex();
        Token token2 = t;
        if (token2 == null || ((Object)token2).equals(null)) {
            stream = Stream$.MODULE$.apply(ScalaRunTime$.MODULE$.boxArray(new Token[]{token}));
            return stream;
        }
        if (bl) {
            TokenType tokenType = t.tyype();
            TokenType tokenType2 = TokenType.BAD;
            if (!(tokenType != null ? !((Object)((Object)tokenType)).equals((Object)tokenType2) : tokenType2 != null)) {
                stream = Stream$.MODULE$.apply(ScalaRunTime$.MODULE$.boxArray(new Token[]{t, token}));
                return stream;
            }
        }
        stream = Stream$cons$.MODULE$.apply(t, new $anonfun$yystream$1$1(this, bl, tokenLexer, token));
        return stream;
    }

    @Override
    public Token[] tokenizeForColorization(String source2, ExtensionManager extensionManager$1) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(ScalaRunTime$.MODULE$.boxArray(this.tokenizeForColorization(source2)).map((Function1)new $anonfun$tokenizeForColorization$2(this, extensionManager$1)), Token.class);
        return (Token[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Token.class) : object);
    }

    @Override
    public Token[] tokenizeForColorization(String source2) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(this.tokenizeIncludingComments(source2).takeWhile(new $anonfun$tokenizeForColorization$1(this)).toArray(), Token.class);
        return (Token[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Token.class) : object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValidIdentifier(String ident) {
        Seq<Token> seq = this.tokenizeRobustly(ident);
        Some<Seq<Token>> some = Seq$.MODULE$.unapplySeq(seq);
        if (!true) return false;
        Seq<Token> seq2 = some.get();
        Seq<Token> seq3 = seq2 instanceof Seq ? seq2 : ScalaRunTime$.MODULE$.boxArray(seq2);
        if (seq3.lengthCompare(2) != 0) return false;
        Token token = (Token)seq3.apply(BoxesRunTime.boxToInteger(0));
        Token token2 = (Token)seq3.apply(BoxesRunTime.boxToInteger(1));
        if (token == null) return false;
        TokenType tokenType = TokenType.IDENT;
        TokenType tokenType2 = token.tyype();
        if (tokenType == null) {
            if (tokenType2 != null) {
                return false;
            }
        } else if (!((Object)((Object)tokenType)).equals((Object)tokenType2)) return false;
        if (token2 == null) return false;
        TokenType tokenType3 = TokenType.EOF;
        TokenType tokenType4 = token2.tyype();
        if (tokenType3 != null) {
            if (!((Object)((Object)tokenType3)).equals((Object)tokenType4)) return false;
            return true;
        }
        if (tokenType4 == null) return true;
        return false;
    }

    @Override
    public Token getTokenAtPosition(String source2, int position$1) {
        return (Token)this.tokenizeIncludingComments(source2).find(new $anonfun$getTokenAtPosition$1(this, position$1)).getOrElse(new $anonfun$getTokenAtPosition$2(this));
    }

    @Override
    public Token nextToken(BufferedReader reader) {
        return new TokenLexer(reader, this.tokenMapper, null, false).yylex();
    }

    private Seq<Token> doTokenize(String source2, boolean includeCommentTokens$1, boolean allowRemovedPrimitives, String fileName, boolean stopAtFirstBadToken$1) {
        TokenLexer yy$1 = new TokenLexer(new StringReader(source2), this.tokenMapper, fileName, allowRemovedPrimitives);
        Token eof$1 = new Token("", TokenType.EOF, "", 0, 0, "");
        return this.yystream$1(stopAtFirstBadToken$1, yy$1, eof$1).filter((Function1)new $anonfun$doTokenize$1(this, includeCommentTokens$1)).toList();
    }

    private Seq<Token> tokenizeIncludingComments(String source2) {
        return this.doTokenize(source2, true, false, "", false);
    }

    @Override
    public Seq<Token> tokenize(String source2, String fileName) {
        Seq<Token> result = this.doTokenize(source2, false, false, fileName, true);
        Option<Token> option = result.find(new $anonfun$tokenize$1(this));
        if (option instanceof Some) {
            throw new CompilerException((Token)((Some)option).x());
        }
        None$ none$ = None$.MODULE$;
        Option<Token> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            return result;
        }
        throw new MatchError(option);
    }

    @Override
    public Seq<Token> tokenize(String source2) {
        return this.tokenize(source2, "");
    }

    @Override
    public Seq<Token> tokenizeAllowingRemovedPrims(String source2) {
        return this.doTokenize(source2, false, true, "", false);
    }

    @Override
    public Seq<Token> tokenizeRobustly(String source2) {
        return this.doTokenize(source2, false, false, "", false);
    }
}

