/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.log;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.FileAppender;
import org.nlogo.api.CompilerException;
import org.nlogo.api.NetLogoListener;
import org.nlogo.api.Version;
import org.nlogo.log.LogMessage;
import org.nlogo.log.XMLFileAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger
implements NetLogoListener {
    public static final org.apache.log4j.Logger BUTTONS = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".BUTTONS"));
    public static final org.apache.log4j.Logger GREENS = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".GREENS"));
    public static final org.apache.log4j.Logger CODE = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".CODE"));
    public static final org.apache.log4j.Logger WIDGETS = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".WIDGETS"));
    public static final org.apache.log4j.Logger GLOBALS = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".GLOBALS"));
    public static final org.apache.log4j.Logger SPEED = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".SPEED"));
    public static final org.apache.log4j.Logger TURTLES = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".TURTLES"));
    public static final org.apache.log4j.Logger LINKS = org.apache.log4j.Logger.getLogger((String)(Logger.class.getName() + ".LINKS"));
    private final String studentName;
    String logDirectory;
    List<String> filenames;
    private static LogMessage widgetMsg = LogMessage.createWidgetMessage();
    private static LogMessage speedMsg = LogMessage.createSpeedMessage();
    private static LogMessage tickMsg = LogMessage.createGlobalMessage("ticks");
    private static LogMessage mortalityMsg = LogMessage.createAgentMessage();
    private static LogMessage buttonMsg = LogMessage.createButtonMessage();
    private static LogMessage sliderMsg = LogMessage.createSliderMessage();
    private static LogMessage switchMsg = LogMessage.createGlobalMessage("switch");
    private static LogMessage chooserMsg = LogMessage.createGlobalMessage("chooser");
    private static LogMessage inputBoxMsg = LogMessage.createGlobalMessage("input box");
    private static LogMessage compileMsg = LogMessage.createCompileMessage();
    private static LogMessage globalMsg = LogMessage.createGlobalMessage("globals");
    private final DateFormat dateFormat;

    @Override
    public strictfp void modelOpened(String name) {
        this.filenames = new ArrayList<String>();
        this.filenames.addAll(this.newFiles(org.apache.log4j.Logger.getRootLogger().getAllAppenders(), name));
        Enumeration loggers = org.apache.log4j.Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            org.apache.log4j.Logger l = (org.apache.log4j.Logger)loggers.nextElement();
            this.filenames.addAll(this.newFiles(l.getAllAppenders(), name));
        }
    }

    public strictfp List<String> newFiles(Enumeration<?> e, String name) {
        ArrayList<String> filenames = new ArrayList<String>();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof FileAppender)) continue;
            FileAppender appender = (FileAppender)obj;
            String filename = this.logFileName(appender.getName());
            filenames.add(filename);
            appender.setFile(filename);
            if (appender instanceof XMLFileAppender) {
                XMLFileAppender xappender = (XMLFileAppender)appender;
                xappender.setStudentName(this.studentName);
                xappender.setUsername(System.getProperty("user.name"));
                xappender.setIPAddress(this.getIPAddress());
                xappender.setModelName(name == null ? "new model" : name);
                xappender.setVersion(Version.version());
            }
            appender.activateOptions();
        }
        return filenames;
    }

    public static strictfp void logSpeedSlider(double value) {
        speedMsg.updateSpeedMessage(Double.toString(value));
        SPEED.info((Object)speedMsg);
    }

    public static strictfp void logTick(double ticks) {
        tickMsg.updateGlobalMessage("ticks", Double.toString(ticks));
        GLOBALS.info((Object)tickMsg);
    }

    public static strictfp void logTurtleBirth(String name, String breed) {
        mortalityMsg.updateAgentMessage("turtle", name, "born", breed);
        TURTLES.info((Object)mortalityMsg);
    }

    public static strictfp void logTurtleDeath(String name, String breed) {
        mortalityMsg.updateAgentMessage("turtle", name, "died", breed);
        TURTLES.info((Object)mortalityMsg);
    }

    public static strictfp void logLinkBirth(String name, String breed) {
        mortalityMsg.updateAgentMessage("link", name, "born", breed);
        LINKS.info((Object)mortalityMsg);
    }

    public static strictfp void logLinkDeath(String name, String breed) {
        mortalityMsg.updateAgentMessage("link", name, "died", breed);
        LINKS.info((Object)mortalityMsg);
    }

    public static strictfp void logButtonStopped(String name, boolean onceButton, boolean stopping) {
        if (BUTTONS.isInfoEnabled()) {
            buttonMsg.updateButtonMessage(name, "released", onceButton ? "once" : (stopping ? "user" : "code"));
            BUTTONS.info((Object)buttonMsg);
        }
    }

    public static strictfp void logButtonPressed(String name) {
        buttonMsg.updateButtonMessage(name, "pressed", "user");
        BUTTONS.info((Object)buttonMsg);
    }

    @Override
    public strictfp void buttonPressed(String buttonName) {
    }

    @Override
    public strictfp void buttonStopped(String buttonName) {
    }

    @Override
    public strictfp void sliderChanged(String name, double value, double min, double increment, double max, boolean valueChanged, boolean buttonReleased) {
        if (valueChanged) {
            sliderMsg.updateSliderMessage(name.toUpperCase(), value, min, max, increment);
            if (buttonReleased) {
                GREENS.info((Object)sliderMsg);
            } else {
                GREENS.debug((Object)sliderMsg);
            }
        }
    }

    @Override
    public strictfp void switchChanged(String name, boolean value, boolean valueChanged) {
        if (valueChanged) {
            switchMsg.updateGlobalMessage(name.toUpperCase(), Boolean.toString(value));
            GREENS.info((Object)switchMsg);
        }
    }

    @Override
    public strictfp void chooserChanged(String name, Object value, boolean valueChanged) {
        if (valueChanged) {
            chooserMsg.updateGlobalMessage(name.toUpperCase(), value.toString());
            GREENS.info((Object)chooserMsg);
        }
    }

    @Override
    public strictfp void inputBoxChanged(String name, Object value, boolean valueChanged) {
        if (valueChanged) {
            inputBoxMsg.updateGlobalMessage(name.toUpperCase(), value.toString());
            GREENS.info((Object)inputBoxMsg);
        }
    }

    @Override
    public strictfp void commandEntered(String owner, String text, char agentType, CompilerException error) {
        if (error == null) {
            compileMsg.updateCompileMessage(owner.toLowerCase(), "compiled", text, Character.toString(agentType), "success", 0, 0);
        } else {
            compileMsg.updateCompileMessage(owner.toLowerCase(), "compiled", text, Character.toString(agentType), error.getMessage(), error.startPos(), error.endPos());
        }
        if (owner.equals("Procedures")) {
            CODE.debug((Object)compileMsg);
        } else if (!owner.startsWith("Slider")) {
            CODE.info((Object)compileMsg);
        }
    }

    public static strictfp void logGlobal(String name, Object value, boolean changed) {
        globalMsg.updateGlobalMessage(name, value.toString());
        if (changed) {
            GLOBALS.info((Object)globalMsg);
        } else {
            GLOBALS.debug((Object)globalMsg);
        }
    }

    public strictfp String getIPAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private strictfp String logFileName(String appender) {
        return this.logDirectory + System.getProperty("file.separator") + "logfile_" + appender + "_" + this.dateFormat.format(new Date()) + ".xml";
    }
}

