/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.api.LogoException;
import org.nlogo.api.Version;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;

public strictfp class EngineException
extends LogoException {
    protected boolean hasBeenResolved = false;
    public Context context = null;
    public Instruction instruction = null;

    public EngineException(Context context, Instruction instruction, String message) {
        super(message);
        this.context = context;
        this.instruction = instruction;
    }

    public EngineException(Context context, String message) {
        super(message);
        if (!Version.useGenerator()) {
            throw new IllegalStateException();
        }
        this.context = context;
        this.instruction = null;
    }

    static void rethrow(LogoException ex, Context context, Instruction instruction) throws LogoException {
        if (ex instanceof EngineException) {
            EngineException ee = (EngineException)ex;
            if (ee.context == null) {
                ee.context = context;
            }
            if (ee.instruction == null) {
                ee.instruction = instruction;
            }
            if (!ee.hasBeenResolved) {
                ee.resolveErrorInstruction();
            }
            throw ee;
        }
        if (ex instanceof HaltException) {
            throw ex;
        }
        EngineException newEx = new EngineException(context, instruction, ex.getMessage());
        newEx.resolveErrorInstruction();
        throw newEx;
    }

    protected void resolveErrorInstruction() {
        if (this.hasBeenResolved) {
            throw new IllegalStateException("An EngineException must only be 'resolved' once!");
        }
        this.hasBeenResolved = true;
        this.instruction = this.instruction.extractErrorInstruction(this);
    }
}

