/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Token;
import org.nlogo.api.TokenHolder;
import org.nlogo.nvm.ArgumentTypeException;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.Reporter;
import org.nlogo.nvm.Syntax;
import org.nlogo.nvm.Workspace;
import org.nlogo.util.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Instruction
implements TokenHolder {
    protected Workspace workspace;
    public World world;
    public Reporter[] args = new Reporter[0];
    private Token token;
    private Token token2 = null;
    public Method chosenMethod = null;
    public String source;
    public Thunk<String> disassembly = new Thunk<String>(){};
    public String agentClassString = "OTPL";
    public int agentBits = 0;
    public int storedSourceStartPosition = -1;
    public int storedSourceEndPosition = -1;
    private String storedSourceSnippet = "";

    Workspace workspace() {
        return this.workspace;
    }

    public abstract Syntax getSyntax();

    public Token token() {
        return this.token;
    }

    @Override
    public void token(Token token) {
        this.token = token;
    }

    public Token tokenLimitingType() {
        return this.token2 == null ? this.token : this.token2;
    }

    public void tokenLimitingType(Token token) {
        this.token2 = token;
    }

    public void init(Workspace workspace) {
        if (workspace != null) {
            this.workspace = workspace;
            this.world = workspace.world();
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].init(workspace);
        }
        this.agentBits = (this.agentClassString.indexOf(79) != -1 ? 1 : 0) | (this.agentClassString.indexOf(84) != -1 ? 2 : 0) | (this.agentClassString.indexOf(80) != -1 ? 4 : 0) | (this.agentClassString.indexOf(76) != -1 ? 8 : 0);
    }

    public int[] getPositionAndLength() {
        int begin = this.getSourceStartPosition();
        int end = this.getSourceEndPosition();
        return new int[]{begin, end - begin};
    }

    public int getSourceStartPosition() {
        if (this.storedSourceStartPosition > -1) {
            return this.storedSourceStartPosition;
        }
        if (this.token() == null) {
            return -1;
        }
        int begin = this.token().startPos();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].token() == null) continue;
            int argBegin = this.args[i].getSourceStartPosition();
            begin = StrictMath.min(begin, argBegin);
        }
        this.storedSourceStartPosition = begin;
        return begin;
    }

    public int getSourceEndPosition() {
        if (this.storedSourceEndPosition > -1) {
            return this.storedSourceEndPosition;
        }
        if (this.token() == null) {
            return -1;
        }
        int end = this.token().endPos();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].token() == null) continue;
            int argEnd = this.args[i].getSourceEndPosition();
            end = StrictMath.max(end, argEnd);
        }
        this.storedSourceEndPosition = end;
        return end;
    }

    public void setSourceSnippet(String s) {
        this.storedSourceSnippet = s;
    }

    public String getSourceSnippet() {
        return this.storedSourceSnippet;
    }

    public String displayName() {
        if (this.token != null) {
            return this.token.name().toUpperCase();
        }
        String result = "." + this.getClass().getName();
        return result.substring(result.lastIndexOf(46) + 1);
    }

    public String toString() {
        String result = this.getClass().getName();
        int dotPos = result.lastIndexOf(46);
        return dotPos == -1 ? result : result.substring(dotPos + 1);
    }

    public String dump() {
        return this.dump(3);
    }

    public String dump(int indentLevel) {
        StringBuilder buf = new StringBuilder(this.toString());
        if (this.source != null) {
            buf.append(" \"");
            buf.append(this.source);
            buf.append('\"');
        }
        if (this.chosenMethod != null) {
            buf.append(' ');
            buf.append(this.describeMethod(this.chosenMethod));
        }
        if (this.args.length > 0) {
            buf.append('\n');
            for (int i = 0; i < this.args.length; ++i) {
                for (int j = 0; j < indentLevel * 2; ++j) {
                    buf.append(' ');
                }
                buf.append(this.args[i].dump(indentLevel + 1));
                if (i >= this.args.length - 1) continue;
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    private String describeMethod(Method m) {
        Class<?>[] types = m.getParameterTypes();
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < types.length; ++i) {
            if (i > 1) {
                buf.append(',');
            }
            buf.append(this.shortClassName(types[i].getName()));
        }
        if (types.length > 1) {
            buf.append(' ');
        }
        buf.append("=> ");
        buf.append(this.shortClassName(m.getReturnType().getName()));
        return buf.toString();
    }

    private String shortClassName(String s) {
        String[] parts = s.split("\\.");
        return parts[parts.length - 1];
    }

    protected void mustNotBeDirected(AgentSet breed, Context context) throws EngineException {
        if (breed.isDirected()) {
            throw new EngineException(context, this, breed.printName() + " is a directed breed.");
        }
    }

    protected void mustNotBeUndirected(AgentSet breed, Context context) throws EngineException {
        if (breed.isUndirected()) {
            throw new EngineException(context, this, breed.printName() + " is an undirected breed.");
        }
    }

    protected void checkForBreedCompatibility(AgentSet breed, Context context) throws EngineException {
        if (!this.world.linkManager.checkBreededCompatibility(breed == this.world.links())) {
            throw new EngineException(context, this, "You cannot have both breeded and unbreeded links in the same world.");
        }
    }

    public static final Double newValidDouble(double d, Instruction instr) throws LogoException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new EngineException(null, instr, "math operation produced " + (Double.isInfinite(d) ? "a number too large for NetLogo" : "a non-number"));
        }
        return d;
    }

    public long validLong(double d) throws LogoException {
        if (d > 9.007199254740992E15 || d < -9.007199254740992E15) {
            throw new EngineException(null, this, d + " is too large to be represented exactly as an integer in NetLogo");
        }
        return (long)d;
    }

    public static boolean isValidLong(double d) {
        return d <= 9.007199254740992E15 && d >= -9.007199254740992E15;
    }

    public Double newValidDouble(double d) throws LogoException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.invalidDouble(d);
        }
        return d;
    }

    public double validDouble(double d) throws LogoException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.invalidDouble(d);
        }
        return d;
    }

    private void invalidDouble(double d) throws LogoException {
        throw new EngineException(null, this, "math operation produced " + (Double.isInfinite(d) ? "a number too large for NetLogo" : "a non-number"));
    }

    public void throwAgentClassException(Context context, Class<? extends Agent> clazz) throws EngineException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (this.getSyntax().agentClassString().indexOf("O") != -1) {
            arrayList.add(Observer.class);
        }
        if (this.getSyntax().agentClassString().indexOf("T") != -1) {
            arrayList.add(Turtle.class);
        }
        if (this.getSyntax().agentClassString().indexOf("P") != -1) {
            arrayList.add(Patch.class);
        }
        if (this.getSyntax().agentClassString().indexOf("L") != -1) {
            arrayList.add(Link.class);
        }
        if (arrayList.size() == 1) {
            throw new EngineException(context, this, "this code can't be run by " + Instruction.agentClassDescription(clazz) + ", only " + Instruction.agentClassDescription((Class)arrayList.get(0)));
        }
        throw new EngineException(context, this, "this code can't be run by " + Instruction.agentClassDescription(clazz));
    }

    protected static String agentClassDescription(Class<? extends Agent> clazz) {
        if (clazz == Observer.class) {
            return "the observer";
        }
        if (clazz == Turtle.class) {
            return "a turtle";
        }
        if (clazz == Patch.class) {
            return "a patch";
        }
        if (clazz == Link.class) {
            return "a link";
        }
        return null;
    }

    public Agent argEvalAgent(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            Agent agent = (Agent)obj;
            if (agent.id == -1L) {
                throw new EngineException(context, this, "This " + agent.classDisplayName() + " is dead.");
            }
            return agent;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 1792, obj);
        }
    }

    public AgentSet argEvalAgentSet(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (AgentSet)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 112, obj);
        }
    }

    public AgentSet argEvalAgentSet(Context context, int argIndex, Class<? extends Agent> type) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            AgentSet set = (AgentSet)obj;
            if (set.type() != type) {
                throw new ArgumentTypeException(context, this, argIndex, Syntax.getAgentSetMask(type), obj);
            }
            return set;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 112, obj);
        }
    }

    public Boolean argEvalBoolean(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (Boolean)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 2, obj);
        }
    }

    public boolean argEvalBooleanValue(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (Boolean)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 2, obj);
        }
    }

    public double argEvalDoubleValue(Context context, int argIndex) throws LogoException {
        return this.argEvalDouble(context, argIndex);
    }

    public int argEvalIntValue(Context context, int argIndex) throws LogoException {
        return this.argEvalDouble(context, argIndex).intValue();
    }

    public LogoList argEvalList(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (LogoList)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 8, obj);
        }
    }

    public Patch argEvalPatch(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (Patch)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 512, obj);
        }
    }

    public String argEvalString(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (String)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 4, obj);
        }
    }

    public Double argEvalDouble(Context context, int argIndex) throws LogoException {
        Reporter arg = this.args[argIndex];
        Object obj = arg.report(context);
        try {
            return (Double)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 1, obj);
        }
    }

    public Turtle argEvalTurtle(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (Turtle)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 256, obj);
        }
    }

    public Link argEvalLink(Context context, int argIndex) throws LogoException {
        Object obj = this.args[argIndex].report(context);
        try {
            return (Link)obj;
        }
        catch (ClassCastException ex) {
            throw new ArgumentTypeException(context, this, argIndex, 1024, obj);
        }
    }

    public void copyFieldsFrom(Instruction sourceInstr) {
        this.workspace = sourceInstr.workspace;
        this.world = sourceInstr.world;
        this.token = sourceInstr.token;
    }

    public Instruction extractErrorInstruction(EngineException ex) {
        return this;
    }
}

