/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.Dump;
import org.nlogo.api.Let;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.Token;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Syntax;
import org.nlogo.nvm.Workspace;

public strictfp class Procedure {
    public final String fileName;
    public String name = null;
    public int pos;
    public int endPos;
    public List<String> args = new ArrayList<String>();
    public final Type tyype;
    public String usableBy = "OTPL";
    public int localsCount = 0;
    public int templateVars = 0;
    public boolean topLevel = false;
    public SourceOwner owner;
    public Token nameToken;
    public final List<Let> lets = new ArrayList<Let>();
    public Command[] code = new Command[0];

    public Procedure(String fileName, Type tyype) {
        this.fileName = fileName;
        this.tyype = tyype;
    }

    public int getNumSlots() {
        return this.args.size() + this.templateVars;
    }

    public Syntax getSyntax() {
        int[] right = new int[this.args.size() - this.localsCount];
        for (int i = 0; i < right.length; ++i) {
            right[i] = 2047;
        }
        switch (this.tyype) {
            case COMMAND: {
                return Syntax.commandSyntax(right);
            }
            case REPORTER: {
                return Syntax.reporterSyntax(right, 2047);
            }
        }
        throw new IllegalStateException();
    }

    public String getNameAndFile() {
        if (this.fileName == null || this.fileName.length() == 0) {
            return this.name;
        }
        return this.name + " (" + this.fileName + ")";
    }

    public String toString() {
        return super.toString() + "[" + this.name + ":" + Dump.list(this.args) + ":" + this.usableBy + "]";
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name + "{" + this.usableBy + "}:\n");
        for (int i = 0; i < this.code.length; ++i) {
            Command command = this.code[i];
            buf.append("[" + i + "]");
            buf.append(command.dump());
            buf.append("\n");
        }
        return buf.toString();
    }

    public void init(Workspace workspace) {
        for (int i = 0; i < this.code.length; ++i) {
            this.code[i].init(workspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum Type {
        COMMAND,
        REPORTER;

    }
}

