/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.nlogo.api.Approximate;
import org.nlogo.api.Color;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.StringUtils;
import org.nlogo.plot.Histogram;
import org.nlogo.plot.PlotException;
import org.nlogo.plot.PlotListener;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPensList;

public strictfp class Plot
implements Serializable,
PlotInterface {
    PlotListener plotListener;
    private final DirtyListener listener;
    private String name;
    private PlotPensList pens = new PlotPensList();
    public boolean pensDirty;
    private PlotPen currentPen;
    private boolean legendIsOpen = false;
    private double defaultXMin = 0.0;
    private double defaultXMax = 10.0;
    private double defaultYMin = 0.0;
    private double defaultYMax = 10.0;
    private boolean defaultAutoPlotOn = true;
    private boolean autoPlotOn;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Histogram histogram = null;

    public Plot(String name, DirtyListener listener) {
        this.name = name;
        this.listener = listener;
        this.clear();
    }

    public void makeDirty() {
        if (this.listener != null) {
            this.listener.makeDirty();
        }
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public PlotPensList pens() {
        return this.pens;
    }

    public void addPen(PlotPen pen) {
        this.pens.addPen(pen);
        this.pensDirty = true;
    }

    public PlotPen currentPen() {
        return this.currentPen;
    }

    public void currentPen(PlotPen currentPen) {
        this.currentPen = currentPen;
        if (this.plotListener != null) {
            this.plotListener.currentPen(currentPen.name());
        }
    }

    public void currentPen(String pen) {
        this.currentPen(this.pens.getPen(pen));
        if (this.plotListener != null) {
            this.plotListener.currentPen(pen);
        }
    }

    public PlotPenInterface getPen(String pen) {
        return this.pens.getPen(pen);
    }

    public boolean legendIsOpen() {
        return this.legendIsOpen;
    }

    public void legendIsOpen(boolean legendIsOpen) {
        this.legendIsOpen = legendIsOpen;
    }

    public double defaultXMin() {
        return this.defaultXMin;
    }

    public void defaultXMin(double defaultXMin) {
        this.defaultXMin = defaultXMin;
        if (this.plotListener != null) {
            this.plotListener.defaultXMin(defaultXMin);
        }
    }

    public double defaultXMax() {
        return this.defaultXMax;
    }

    public void defaultXMax(double defaultXMax) {
        this.defaultXMax = defaultXMax;
        if (this.plotListener != null) {
            this.plotListener.defaultXMax(defaultXMax);
        }
    }

    public double defaultYMin() {
        return this.defaultYMin;
    }

    public void defaultYMin(double defaultYMin) {
        this.defaultYMin = defaultYMin;
        if (this.plotListener != null) {
            this.plotListener.defaultYMin(defaultYMin);
        }
    }

    public double defaultYMax() {
        return this.defaultYMax;
    }

    public void defaultYMax(double defaultYMax) {
        this.defaultYMax = defaultYMax;
        if (this.plotListener != null) {
            this.plotListener.defaultYMax(defaultYMax);
        }
    }

    public boolean defaultAutoPlotOn() {
        return this.defaultAutoPlotOn;
    }

    public void defaultAutoPlotOn(boolean defaultAutoPlotOn) {
        this.defaultAutoPlotOn = defaultAutoPlotOn;
        if (this.plotListener != null) {
            this.plotListener.defaultAutoPlotOn(defaultAutoPlotOn);
        }
    }

    public boolean autoPlotOn() {
        return this.autoPlotOn;
    }

    public void autoPlotOn(boolean autoPlotOn) {
        this.autoPlotOn = autoPlotOn;
        if (this.plotListener != null) {
            this.plotListener.autoPlotOn(autoPlotOn);
        }
    }

    public double xMin() {
        return this.xMin;
    }

    public void xMin(double xMin) {
        this.xMin = xMin;
        if (this.plotListener != null) {
            this.plotListener.xMin(xMin);
        }
    }

    public double xMax() {
        return this.xMax;
    }

    public void xMax(double xMax) {
        this.xMax = xMax;
        if (this.plotListener != null) {
            this.plotListener.xMax(xMax);
        }
    }

    public double yMin() {
        return this.yMin;
    }

    public void yMin(double yMin) {
        this.yMin = yMin;
        if (this.plotListener != null) {
            this.plotListener.yMin(yMin);
        }
    }

    public double yMax() {
        return this.yMax;
    }

    public void yMax(double yMax) {
        this.yMax = yMax;
        if (this.plotListener != null) {
            this.plotListener.yMax(yMax);
        }
    }

    public void clear() {
        this.pens.removeTemporaries();
        if (this.pens.size() == 0) {
            new PlotPen(this, "default", false);
        }
        this.currentPen(this.pens.getFirst());
        for (PlotPen pen : this.pens) {
            pen.hardReset();
        }
        this.xMin(this.defaultXMin());
        this.xMax(this.defaultXMax());
        this.yMin(this.defaultYMin());
        this.yMax(this.defaultYMax());
        this.autoPlotOn(this.defaultAutoPlotOn());
        this.makeDirty();
        if (this.plotListener != null) {
            this.plotListener.clear();
        }
        this.pensDirty = true;
    }

    void perhapsGrowRanges(PlotPen pen, double x, double y) {
        if (this.autoPlotOn()) {
            if (pen.mode() == 1) {
                this.growRanges(x + pen.interval(), y, true);
            }
            this.growRanges(x, y, true);
        }
    }

    private void growRanges(double x, double y, boolean extraRoom) {
        double newRange;
        if (x > this.xMax()) {
            newRange = x - this.xMin();
            if (extraRoom) {
                newRange *= 1.25;
            }
            this.xMax(Plot.newBound(this.xMin() + newRange, newRange));
        }
        if (x < this.xMin()) {
            newRange = this.xMax() - x;
            if (extraRoom) {
                newRange *= 1.25;
            }
            this.xMin(Plot.newBound(this.xMax() - newRange, newRange));
        }
        if (y > this.yMax()) {
            newRange = y - this.yMin();
            if (extraRoom) {
                newRange *= 1.1;
            }
            this.yMax(Plot.newBound(this.yMin() + newRange, newRange));
        }
        if (y < this.yMin()) {
            newRange = this.yMax() - y;
            if (extraRoom) {
                newRange *= 1.1;
            }
            this.yMin(Plot.newBound(this.yMax() - newRange, newRange));
        }
    }

    private static double newBound(double bound, double range) {
        return Approximate.approximate(bound, (int)(2.0 - StrictMath.floor(StrictMath.log(range) / StrictMath.log(10.0))));
    }

    public void setHistogramNumBars(PlotPen pen, int numBars) {
        pen.interval((this.xMax() - this.xMin()) / (double)numBars);
        if (this.plotListener != null) {
            this.plotListener.setHistogramNumBars(numBars);
        }
    }

    public void beginHistogram(PlotPen pen) throws PlotException {
        if (pen.interval() == 0.0) {
            throw new PlotException("You cannot histogram with a plot-pen-interval of 0.");
        }
        this.histogram = new Histogram(this.xMin(), this.xMax(), pen.interval());
    }

    public void nextHistogramValue(double value) {
        this.histogram.nextValue(value);
    }

    public void endHistogram(PlotPen pen) {
        pen.softReset();
        if (this.autoPlotOn()) {
            this.growRanges(this.xMin(), this.histogram.ceiling(), false);
        }
        int[] bars = this.histogram.bars();
        int barNumber = 0;
        for (int bar : bars) {
            if (bar > 0) {
                pen.plot(this.xMin() + (double)barNumber * pen.interval(), bar);
            }
            ++barNumber;
        }
        this.histogram = null;
    }

    public void loadPens(String[] strings, boolean translateColors) {
        this.pens.clear();
        for (int i = 15; i < strings.length; ++i) {
            StringTokenizer tokenizer = new StringTokenizer(strings[i]);
            String penName = tokenizer.nextToken().substring(1);
            while (!penName.endsWith("\"") || penName.endsWith("\\\"")) {
                penName = penName + " " + tokenizer.nextToken();
            }
            penName = StringUtils.unEscapeString(penName.substring(0, penName.length() - 1));
            PlotPen pen = new PlotPen(this, penName, false);
            pen.defaultInterval(Double.valueOf(tokenizer.nextToken()));
            int mode = (int)Double.valueOf(tokenizer.nextToken()).doubleValue();
            if (!PlotPen.isValidPlotPenMode(mode)) {
                throw new IllegalStateException(mode + " is not a valid plot pen mode");
            }
            pen.defaultMode(mode);
            int color = Integer.valueOf(tokenizer.nextToken());
            if (translateColors) {
                color = Color.translateSavedColor(color);
            }
            pen.defaultColor(color);
            pen.inLegend(Boolean.valueOf(tokenizer.nextToken()));
        }
    }

    public static interface DirtyListener {
        public void makeDirty();
    }
}

