/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.ShapeList;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.shape.LinkShape;

public strictfp class LinkDrawer {
    final ShapeList linkShapes;

    public LinkDrawer(ShapeList linkShapes) {
        this.linkShapes = linkShapes;
    }

    public void drawLink(GraphicsInterface g, TopologyRenderer topology, Link link, double patchSize, boolean outline) {
        if (!link.hidden()) {
            if (link.size() > 0.0) {
                if (outline) {
                    this.drawLinkWithOutline(g, topology, link, patchSize);
                } else {
                    this.drawLink(g, topology, link, patchSize);
                }
            }
            if (link.hasLabel()) {
                this.drawLinkLabel(g, topology, link, patchSize);
            }
        }
    }

    void drawLink(GraphicsInterface g, TopologyRenderer topology, Link link, double patchSize) {
        topology.drawLink(g, link, this.getLinkDrawable(link), patchSize, org.nlogo.api.Color.getColor(link.color()), link.lineThickness());
    }

    private void drawLinkWithOutline(GraphicsInterface g, TopologyRenderer topology, Link link, double patchSize) {
        LinkDrawable drawer = this.getLinkDrawable(link);
        double lineThickness = link.lineThickness();
        Color color = org.nlogo.api.Color.getColor(link.color());
        topology.drawLink(g, link, drawer, patchSize, color, lineThickness + 4.0 / patchSize);
        topology.drawLink(g, link, drawer, patchSize, org.nlogo.api.Color.getComplement(color), lineThickness + 2.0 / patchSize);
        topology.drawLink(g, link, drawer, patchSize, color, lineThickness);
    }

    private LinkDrawable getLinkDrawable(Link link) {
        LinkShape shape = (LinkShape)this.linkShapes.shape(link.shape());
        if (shape.isTooSimpleToPaint() && !link.isDirectedLink()) {
            return new LineDrawer();
        }
        if (shape.isTooSimpleToPaint()) {
            return new SimpleShapeDrawer(shape);
        }
        return new LinkShapeDrawer(shape);
    }

    private void drawLinkLabel(GraphicsInterface g, TopologyRenderer topology, Link link, double patchSize) {
        double midx = this.labelX(link, topology);
        double midy = this.labelY(link, topology);
        topology.drawLabelHelper(g, midx, midy, link.labelString(), link.labelColor(), patchSize, 1.0);
    }

    private double labelX(Link link, TopologyRenderer topology) {
        if (!link.isDirectedLink()) {
            return link.midpointX() - 0.5;
        }
        return this.pointBetweenMidpointAndEnd2X(link, topology, 0.5) + 0.5;
    }

    private double labelY(Link link, TopologyRenderer topology) {
        if (!link.isDirectedLink()) {
            return link.midpointY() + 0.5;
        }
        return this.pointBetweenMidpointAndEnd2Y(link, topology, 0.5) + 0.5;
    }

    private double pointBetweenMidpointAndEnd2X(Link link, TopologyRenderer topology, double c) {
        double x1 = (link.x1() + link.x2()) / 2.0;
        double x2 = link.x2() - StrictMath.sin(StrictMath.toRadians(link.heading())) * (link.linkDestinationSize() - 1.0);
        double xdiff = x1 - x2;
        return topology.wrapX(x1 - xdiff * c);
    }

    private double pointBetweenMidpointAndEnd2Y(Link link, TopologyRenderer topology, double c) {
        double y1 = (link.y1() + link.y2()) / 2.0;
        double y2 = link.y2() - StrictMath.cos(StrictMath.toRadians(link.heading())) * (link.linkDestinationSize() - 1.0);
        double ydiff = y1 - y2;
        return topology.wrapY(y1 - ydiff * c);
    }

    private strictfp class LinkShapeDrawer
    implements LinkDrawable {
        private final LinkShape shape;

        LinkShapeDrawer(LinkShape shape) {
            this.shape = shape;
        }

        public void draw(GraphicsInterface g, Link link, Color color, double x1, double y1, double x2, double y2, double patchSize, double lineThickness) {
            this.shape.paint(g, color, x1, y1, x2, y2, patchSize, link.size(), lineThickness, link.linkDestinationSize(), link.isDirectedLink());
        }
    }

    private strictfp class SimpleShapeDrawer
    implements LinkDrawable {
        private final LinkShape shape;

        SimpleShapeDrawer(LinkShape shape) {
            this.shape = shape;
        }

        public void draw(GraphicsInterface g, Link link, Color color, double x1, double y1, double x2, double y2, double patchSize, double lineThickness) {
            g.drawLine(x1, y1, x2, y2);
            this.shape.paintDirectionIndicator(g, color, x1, y1, x2, y2, link.heading(), patchSize, lineThickness, link.linkDestinationSize(), link.size());
        }
    }

    private strictfp class LineDrawer
    implements LinkDrawable {
        private LineDrawer() {
        }

        public void draw(GraphicsInterface g, Link link, Color color, double x1, double y1, double x2, double y2, double patchSize, double lineThickness) {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public static interface LinkDrawable {
        public void draw(GraphicsInterface var1, Link var2, Color var3, double var4, double var6, double var8, double var10, double var12, double var14);
    }
}

