/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.AbstractRenderer;

public strictfp class Renderer
extends AbstractRenderer {
    final World world2;

    public Renderer(World world) {
        super(world, world.turtleShapeList(), world.linkShapeList());
        this.world2 = world;
    }

    public void paint(Graphics2D g, ViewSettings settings) {
        this.paint(new Graphics2DWrapper(g), settings);
    }

    protected void paintPatchLabels(GraphicsInterface g, double patchSize) {
        if (this.world2.patchesWithLabels() > 0) {
            int patchCount = this.world2.patches().count();
            for (int i = 0; i < patchCount; ++i) {
                Patch patch = this.world2.getPatch(i);
                if (!patch.hasLabel()) continue;
                this.drawPatchLabel(g, patch, patchSize);
            }
        }
        if (this.outlineAgent instanceof Patch) {
            Patch patch = (Patch)this.outlineAgent;
            this.topology.drawWrappedRect(g, Color.getComplement(Color.getColor(patch.pcolor())), 1.0f, patch.pxcor(), patch.pycor(), 1.0, patchSize, false);
        }
    }

    protected void paintLinks(GraphicsInterface g, double patchSize) {
        int linksDrawn = 0;
        Collection<Object> breeds = this.world2.program().linkBreeds.values();
        for (AgentSet agentSet : breeds) {
            for (Agent a : agentSet.agents()) {
                this.linkDrawer.drawLink(g, this.topology, (Link)a, patchSize, false);
                ++linksDrawn;
            }
        }
        if (linksDrawn < this.world2.links().count()) {
            for (Agent agent : this.world2.links().agents()) {
                Link link = (Link)agent;
                if (link.getBreed() != this.world2.links()) continue;
                this.linkDrawer.drawLink(g, this.topology, link, patchSize, false);
            }
        }
        if (this.outlineAgent instanceof Link) {
            this.linkDrawer.drawLink(g, this.topology, (Link)this.outlineAgent, patchSize, true);
        }
    }

    protected void paintTurtles(GraphicsInterface graphicsInterface, double d) {
        int n = 0;
        Collection<Object> collection = this.world2.program().breeds.values();
        for (AgentSet object : collection) {
            if (!Turtle.class.isAssignableFrom(object.type())) continue;
            for (Agent agent : object.agents()) {
                this.turtleDrawer.drawTurtle(graphicsInterface, this.topology, (Turtle)agent, d);
                ++n;
            }
        }
        if (n < this.world2.turtles().count()) {
            for (Agent agent : this.world2.turtles().agents()) {
                Turtle turtle2 = (Turtle)agent;
                if (turtle2.getBreed() != this.world2.turtles()) continue;
                this.turtleDrawer.drawTurtle(graphicsInterface, this.topology, turtle2, d);
            }
        }
        if (this.outlineAgent instanceof Turtle) {
            this.turtleDrawer.drawTurtleWithOutline(graphicsInterface, this.topology, (Turtle)this.outlineAgent, d);
        }
    }

    private void drawPatchLabel(GraphicsInterface g, Patch patch, double patchSize) {
        this.topology.drawLabelHelper(g, patch.pxcor(), patch.pycor(), patch.labelString(), patch.labelColor(), patchSize, 1.0);
    }

    Agent targetAgent() {
        return this.world2.observer().targetAgent();
    }

    protected BufferedImage getSpotlightImage(ViewSettings settings) {
        double ycor;
        double xcor;
        double spotlightSize;
        boolean wrap = false;
        Agent agent = this.targetAgent();
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            spotlightSize = turtle2.size() * 2.0;
            xcor = turtle2.xcor();
            ycor = turtle2.ycor();
            wrap = true;
        } else if (agent instanceof Link) {
            Link link = (Link)agent;
            spotlightSize = link.size();
            xcor = link.midpointX();
            ycor = link.midpointY();
        } else {
            Patch patch = (Patch)agent;
            spotlightSize = 2.0;
            xcor = patch.pxcor();
            ycor = patch.pycor();
        }
        return this.spotlightDrawer.getImage(this.topology, xcor, ycor, this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), settings.patchSize(), spotlightSize, this.darkenPeripheral(settings), wrap);
    }

    protected boolean anyTurtles() {
        return this.world2.turtles().count() > 0;
    }

    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return this.topology.graphicsX(xcor, patchSize, viewOffsetX);
    }

    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return this.topology.graphicsY(ycor, patchSize, viewOffsetY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage exportView(ViewSettings settings) {
        BufferedImage image = new BufferedImage(this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Font font = g.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), settings.fontSize());
        g.setFont(newFont);
        World world = this.world2;
        synchronized (world) {
            this.paint(g, settings);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportView(Graphics2D g, ViewSettings settings) {
        World world = this.world2;
        synchronized (world) {
            this.paint(g, settings);
        }
    }
}

