/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;

public strictfp class SpotlightDrawer
implements Drawable {
    private BufferedImage spotlightImage;
    static Color DIMMED = new Color(0, 0, 50, 100);
    private static final Color SPOTLIGHT_INNER_BORDER = new Color(200, 255, 255, 100);
    private static final Color SPOTLIGHT_OUTER_BORDER = new Color(200, 255, 255, 50);
    private static final Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);

    public BufferedImage getImage(TopologyRenderer topology, double xcor, double ycor, int width, int height, double patchSize, double spotlightSize, boolean dim, boolean wrap) {
        if (this.spotlightImage == null || this.spotlightImage.getWidth() != width || this.spotlightImage.getHeight() != height) {
            this.spotlightImage = new BufferedImage(width, height, 2);
        }
        Graphics2DWrapper sg = new Graphics2DWrapper(this.spotlightImage.createGraphics());
        sg.antiAliasing(true);
        if (dim) {
            sg.setComposite(AlphaComposite.Src);
            sg.setColor(DIMMED);
            sg.fillRect(0, 0, width, height);
        } else {
            sg.setComposite(AlphaComposite.Clear);
            sg.setColor(DIMMED);
            sg.fillRect(0, 0, width, height);
        }
        if (wrap) {
            topology.wrapDrawable(this, sg, xcor, ycor, spotlightSize, patchSize);
        } else {
            sg.push();
            double size = spotlightSize * patchSize + this.adjustSize(spotlightSize, patchSize);
            double offset = size / 2.0;
            double x = topology.graphicsX(xcor, patchSize) - offset;
            double y = topology.graphicsY(ycor, patchSize) - offset;
            sg.translate(x, y);
            this.draw(sg, size);
            sg.pop();
        }
        sg.antiAliasing(false);
        return this.spotlightImage;
    }

    public double adjustSize(double spotlightSize, double patchSize) {
        double minSize = StrictMath.max(this.spotlightImage.getWidth(), this.spotlightImage.getHeight()) / 20;
        return spotlightSize * patchSize < minSize ? minSize - spotlightSize : 0.0;
    }

    public void draw(GraphicsInterface g, double size) {
        g.setComposite(AlphaComposite.Clear);
        this.drawEllipse(g, 8.0 + size, -4.0);
        g.setComposite(AlphaComposite.Src);
        g.setColor(DIMMED);
        this.drawEllipse(g, 10.0 + size, -5.0);
        g.setColor(SPOTLIGHT_OUTER_BORDER);
        this.drawEllipse(g, 8.0 + size, -4.0);
        g.setColor(SPOTLIGHT_INNER_BORDER);
        this.drawEllipse(g, 4.0 + size, -2.0);
        g.setComposite(AlphaComposite.Clear);
        this.drawEllipse(g, size, 0.0);
    }

    private void drawEllipse(GraphicsInterface g, double size, double offset) {
        g.push();
        g.translate(offset, offset);
        g.scale(size, size);
        g.fill(ellipse);
        g.pop();
    }
}

