/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.Drawable;
import org.nlogo.render.LinkDrawer;

public strictfp abstract class TopologyRenderer {
    final World world;
    int width;
    int height;
    int viewWidth;
    int viewHeight;
    int worldAndViewPreMultipliedX;
    int worldAndViewPreMultipliedY;
    double viewOffsetX;
    double viewOffsetY;

    public TopologyRenderer(World world) {
        this.world = world;
    }

    void prepareToPaint(ViewSettings settings, int width, int height) {
        this.width = width;
        this.height = height;
        this.viewWidth = (int)StrictMath.round(settings.viewWidth() * settings.patchSize());
        this.viewHeight = (int)StrictMath.round(settings.viewHeight() * settings.patchSize());
        if (settings.renderPerspective()) {
            this.viewOffsetX = settings.viewOffsetX();
            this.viewOffsetY = settings.viewOffsetY();
            this.worldAndViewPreMultipliedX = -((int)StrictMath.round(settings.patchSize() * this.viewOffsetX));
            this.worldAndViewPreMultipliedY = (int)StrictMath.round(settings.patchSize() * this.viewOffsetY);
        } else {
            this.worldAndViewPreMultipliedX = 0;
            this.worldAndViewPreMultipliedY = 0;
            this.viewOffsetX = 0.0;
            this.viewOffsetY = 0.0;
        }
    }

    abstract void wrapDrawable(Drawable var1, GraphicsInterface var2, double var3, double var5, double var7, double var9);

    void draw(Drawable drawable, GraphicsInterface g, double x, double y, double xOffset, double yOffset, double size) {
        if (x + size - xOffset >= 0.0 && x - xOffset <= (double)this.viewWidth && y + size - yOffset >= 0.0 && y - yOffset <= (double)this.viewHeight) {
            g.push();
            g.translate(-xOffset, -yOffset);
            drawable.draw(g, size);
            g.pop();
        }
    }

    void drawWrappedRect(GraphicsInterface g, Color color, final float stroke, double xcor, double ycor, double agentSize, double patchSize, final boolean fill) {
        g.setColor(color);
        this.wrapDrawable(new Drawable(){

            public void draw(GraphicsInterface g, double size) {
                g.setStroke(stroke);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                if (fill) {
                    g.fill(rect);
                } else {
                    g.draw(rect);
                }
            }

            public double adjustSize(double turtleSize, double patchSize) {
                return patchSize >= 5.0 ? -2.0 : 0.0;
            }
        }, g, xcor, ycor, agentSize, patchSize);
    }

    abstract void fillBackground(GraphicsInterface var1);

    abstract void paintAllPatchesBlack(GraphicsInterface var1);

    void fillWith(GraphicsInterface g, Color color) {
        g.setColor(color);
        g.fillRect(0, 0, this.width, this.height);
    }

    void paintViewImage(GraphicsInterface g, Image image) {
        g.setInterpolation();
        g.drawImage(image, this.worldAndViewPreMultipliedX, this.worldAndViewPreMultipliedY, this.width, this.height);
    }

    abstract void drawLink(GraphicsInterface var1, Link var2, LinkDrawer.LinkDrawable var3, double var4, Color var6, double var7);

    public void drawLabelHelper(GraphicsInterface g, double xcor, double ycor, String label, Object color, double patchSize, double size) {
        g.push();
        double x = this.graphicsX(xcor + 0.5 * size, patchSize);
        double y = this.graphicsY(ycor - 0.5 * size, patchSize);
        g.setColor(org.nlogo.api.Color.getColor(color));
        g.drawLabel(label, x, y, patchSize);
        g.pop();
    }

    abstract void drawLine(GraphicsInterface var1, double var2, double var4, double var6, double var8, double var10);

    double wrapX(double pos) {
        return this.world.wrap(pos, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    double wrapY(double pos) {
        return this.world.wrap(pos, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double graphicsXNoOffset(double xcor, double patchSize) {
        return patchSize * (xcor - ((double)this.world.minPxcor() - 0.5)) - 0.5;
    }

    double graphicsYNoOffset(double ycor, double patchSize) {
        return patchSize * (-ycor + ((double)this.world.maxPycor() + 0.4999999)) - 0.5;
    }

    public final double graphicsX(double xcor, double patchSize) {
        return this.graphicsX(xcor, patchSize, this.viewOffsetX);
    }

    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return patchSize * (xcor - (double)this.world.minPxcor() + 0.5 - viewOffsetX);
    }

    public final double graphicsY(double ycor, double patchSize) {
        return this.graphicsY(ycor, patchSize, this.viewOffsetY);
    }

    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return patchSize * (-ycor + (double)this.world.maxPycor() + 0.4999999 + viewOffsetY);
    }
}

