/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.nlogo.api.ShapeList;
import org.nlogo.api.Turtle;
import org.nlogo.render.CacheKey;
import org.nlogo.render.CachedShape;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleShapeManager {
    private final Queue<CacheKey> cacheQueue = new LinkedList<CacheKey>();
    private final Map<CacheKey, CachedShape> shapeCache = new HashMap<CacheKey, CachedShape>();
    private final CacheKey reusableCacheKey = new CacheKey(0, 0, null, 0.0);
    final ShapeList shapeList;
    private int cellSize;
    private int pixelCount = 0;
    private int angleStep;
    private int numAngleSteps;

    TurtleShapeManager(ShapeList shapeList) {
        this.shapeList = shapeList;
    }

    void resetCache(double patchSize) {
        this.shapeCache.clear();
        this.cacheQueue.clear();
        this.pixelCount = 0;
        this.cellSize = (int)StrictMath.floor(patchSize);
        if (this.cellSize == 0) {
            this.angleStep = 1;
        } else {
            this.angleStep = 30 / this.cellSize;
            if (this.angleStep == 0) {
                this.angleStep = 1;
            }
        }
        this.numAngleSteps = 360 / this.angleStep;
    }

    boolean useCache(Turtle turtle2, double patchSize) {
        double turtleSize = turtle2.size();
        return patchSize == (double)this.cellSize && (turtleSize == 1.0 || turtleSize == 1.5 || turtleSize == 2.0) && turtle2.lineThickness() == 0.0;
    }

    VectorShape getCachedShape(Turtle turtle2) {
        VectorShape shape = (VectorShape)turtle2.cachedShape();
        if (shape != null) {
            return shape;
        }
        shape = (VectorShape)this.shapeList.shape(turtle2.shape());
        turtle2.cachedShape(shape);
        return shape;
    }

    CachedShape getShape(VectorShape shape, Color color, double angle, double size) {
        int angleIndex;
        if (shape.isRotatable()) {
            angleIndex = (int)StrictMath.rint(angle / (double)this.angleStep);
            if (angleIndex == this.numAngleSteps) {
                angleIndex = 0;
            }
            angle = angleIndex * this.angleStep;
        } else {
            angleIndex = 0;
            angle = 0.0;
        }
        this.reusableCacheKey.reuse(color.getRGB(), angleIndex, shape, size);
        CachedShape cachedShape = this.shapeCache.get(this.reusableCacheKey);
        if (cachedShape == null) {
            while (this.pixelCount >= 0x200000) {
                this.discardOldestShape();
            }
            cachedShape = new CachedShape(shape, this.cellSize, (int)angle, size, color);
            try {
                CacheKey newKey = (CacheKey)this.reusableCacheKey.clone();
                this.shapeCache.put(newKey, cachedShape);
                this.cacheQueue.add(newKey);
                this.pixelCount += cachedShape.getPixelCount();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return cachedShape;
    }

    private void discardOldestShape() {
        CacheKey oldKey = this.cacheQueue.remove();
        this.pixelCount -= this.shapeCache.get(oldKey).getPixelCount();
        this.shapeCache.remove(oldKey);
    }
}

