/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.nlogo.api.AggregateManagerInterface;
import org.nlogo.api.CompilerServices;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.Model$;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Rate;
import org.nlogo.sdm.Reservoir;
import org.nlogo.sdm.Stock;
import org.nlogo.sdm.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class AggregateManagerLite
implements AggregateManagerInterface {
    private String source = "";
    private static final String[] TOKENS = new String[]{"MODEL", "org.nlogo.sdm.gui.AggregateDrawing", "STOCK", "org.nlogo.sdm.gui.WrappedStock", "RATE", "org.nlogo.sdm.gui.WrappedRate", "CONVERTER", "org.nlogo.sdm.gui.WrappedConverter", "RESERVOIR_FIGURE", "org.nlogo.sdm.gui.ReservoirFigure", "STOCK_FIGURE", "org.nlogo.sdm.gui.StockFigure", "RATE_CONN", "org.nlogo.sdm.gui.RateConnection", "CHOP_DIAMOND", "org.jhotdraw.contrib.ChopDiamondConnector", "CHOP_BOX", "org.jhotdraw.standard.ChopBoxConnector", "RESERVOIR", "org.nlogo.sdm.gui.WrappedReservoir", "CONVERTER_FIGURE", "org.nlogo.sdm.gui.ConverterFigure", "BINDING_CONN", "org.nlogo.sdm.gui.BindingConnection", "CHOP_ELLIPSE", "org.jhotdraw.figures.ChopEllipseConnector", "CHOP_RATE", "org.nlogo.sdm.gui.ChopRateConnector"};

    @Override
    public String innerSource() {
        return this.source;
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public void innerSource(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String classDisplayName() {
        return "System Dynamics";
    }

    @Override
    public Class<?> agentClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String headerSource() {
        return "";
    }

    @Override
    public void showEditor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String save() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(String lines, CompilerServices compiler) {
        if (lines.trim().equals("")) {
            return;
        }
        try {
            lines = Model$.MODULE$.mungeClassNames(lines);
            BufferedReader br = new BufferedReader(new StringReader(lines));
            double dt = Double.parseDouble(br.readLine());
            String str = br.readLine();
            lines = lines.substring(lines.indexOf(str));
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(lines));
            tokenizer.eolIsSignificant(true);
            this.source = new Translator(this.buildModel(tokenizer, dt), compiler).source();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (Model.ModelException e) {
            throw new IllegalStateException(e);
        }
    }

    private Model buildModel(StreamTokenizer tokenizer, double dt) throws IOException, Model.ModelException {
        HashMap<Integer, ModelElement> lineMap = new HashMap<Integer, ModelElement>();
        Map<String, String> validTokens = AggregateManagerLite.makeValidTokensMap();
        Model model = null;
        int validLines = 0;
        while (tokenizer.nextToken() != -1) {
            if (tokenizer.ttype == 10) continue;
            tokenizer.sval = tokenizer.sval.replaceAll("org.nlogo.aggregate.gui", "org.nlogo.sdm.gui");
            if (!validTokens.containsValue(tokenizer.sval)) {
                throw new IOException("invalid token: \"" + tokenizer.sval + "\"");
            }
            ++validLines;
            ModelElement me = this.processElement(tokenizer, validTokens);
            if (me != null) {
                if (me instanceof Model) {
                    if (model != null) {
                        throw new IllegalStateException();
                    }
                    model = (Model)me;
                    model.setDt(dt);
                } else if (me instanceof Stock) {
                    lineMap.put(validLines, me);
                    ++validLines;
                } else if (me instanceof Rate) {
                    this.setSourceSink((Rate)me, tokenizer, lineMap);
                }
                model.addElement(me);
            }
            while (tokenizer.ttype != 10 && tokenizer.ttype != -1) {
                tokenizer.nextToken();
            }
        }
        return model;
    }

    private ModelElement processElement(StreamTokenizer st, Map<String, String> validTokens) throws IOException {
        ModelElement element = null;
        if (st.ttype == -3) {
            if (st.sval.equals(validTokens.get("STOCK"))) {
                Stock stock = new Stock();
                stock.setName(this.readString(st));
                stock.setInitialValueExpression(this.readString(st));
                stock.setNonNegative(this.readBoolean(st));
                element = stock;
            } else if (st.sval.equals(validTokens.get("RATE"))) {
                Rate rate = new Rate();
                rate.setExpression(this.readString(st));
                rate.setName(this.readString(st));
                element = rate;
            } else if (st.sval.equals(validTokens.get("CONVERTER"))) {
                Converter converter = new Converter();
                converter.setExpression(this.readString(st));
                converter.setName(this.readString(st));
                element = converter;
            } else if (st.sval.equals(validTokens.get("MODEL"))) {
                element = new Model("Test Model", 1.0);
            }
        }
        return element;
    }

    private void setSourceSink(Rate rate, StreamTokenizer st, Map<Integer, ModelElement> lineMap) throws IOException {
        if (st.nextToken() == -3 && st.sval.equals("REF")) {
            rate.setSource(this.getSourceOrSink(st, lineMap));
            if (st.nextToken() == -3 && st.sval.equals("REF")) {
                rate.setSink(this.getSourceOrSink(st, lineMap));
            } else {
                rate.setSink(new Reservoir());
            }
        } else {
            st.nextToken();
            st.nextToken();
            rate.setSink(this.getSourceOrSink(st, lineMap));
            rate.setSource(this.getSourceOrSink(st, lineMap));
        }
    }

    private Stock getSourceOrSink(StreamTokenizer st, Map<Integer, ModelElement> lineMap) throws IOException {
        Integer key = this.readInt(st) + 1;
        if (lineMap.containsKey(key)) {
            return (Stock)lineMap.get(key);
        }
        return new Reservoir();
    }

    private static Map<String, String> makeValidTokensMap() {
        HashMap<String, String> validTokens = new HashMap<String, String>();
        for (int i = 0; i < TOKENS.length; i += 2) {
            validTokens.put(TOKENS[i], TOKENS[i + 1]);
        }
        return validTokens;
    }

    private String readString(StreamTokenizer st) throws IOException {
        int token = st.nextToken();
        if (token != 34) {
            throw new IOException("expected string token");
        }
        return st.sval;
    }

    private boolean readBoolean(StreamTokenizer st) throws IOException {
        int token = st.nextToken();
        if (token != -2) {
            throw new IOException("expected integer (boolean)");
        }
        return st.nval == 1.0;
    }

    private int readInt(StreamTokenizer st) throws IOException {
        int token = st.nextToken();
        if (token != -2) {
            throw new IOException("expected integer");
        }
        return (int)st.nval;
    }
}

