/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Circle
extends Element
implements Cloneable {
    private int x;
    private int y;
    private int xDiameter;
    private int yDiameter;

    public Circle(int x, int y, int xDiameter, Color color) {
        super(color);
        this.x = x;
        this.y = y;
        this.xDiameter = xDiameter;
        this.yDiameter = xDiameter;
    }

    public void setFilled(boolean fill) {
        this.filled = fill;
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.getColor(turtleColor));
        if (this.filled) {
            g.fillCircle(this.x, this.y, this.xDiameter, this.yDiameter, scale, angle);
        } else {
            g.drawCircle(this.x, this.y, this.xDiameter, this.yDiameter, scale, angle);
        }
    }

    public String toString() {
        return "Circle " + this.c.getRGB() + " " + this.filled + " " + this.marked + " " + this.x + " " + this.y + " " + this.xDiameter;
    }

    public static Circle parseCircle(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = tokenizer.nextToken().equals("true");
        boolean b2 = tokenizer.nextToken().equals("true");
        int x1 = Integer.valueOf(tokenizer.nextToken());
        int y1 = Integer.valueOf(tokenizer.nextToken());
        int diam = Integer.valueOf(tokenizer.nextToken());
        if (diam == 0) {
            return null;
        }
        Circle circle = new Circle(x1, y1, diam, Color.decode(color));
        circle.setFilled(b1);
        circle.setMarked(b2);
        return circle;
    }
}

