/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Curve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Polygon
extends Curve
implements Cloneable {
    public int latestIndex = 1;
    public boolean notCompleted = false;

    public Polygon(List<Integer> xcoords, List<Integer> ycoords, Color c) {
        super(c);
        this.xcoords = xcoords;
        this.ycoords = ycoords;
    }

    @Override
    public void setFilled(boolean fill) {
        this.filled = fill;
    }

    @Override
    public Object clone() {
        Polygon newPoly = (Polygon)super.clone();
        newPoly.xcoords = new ArrayList(newPoly.xcoords);
        newPoly.ycoords = new ArrayList(newPoly.ycoords);
        return newPoly;
    }

    @Override
    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        if (this.notCompleted) {
            super.draw(g, null, scale, angle);
        } else {
            int[] xArray = new int[this.xcoords.size()];
            int[] yArray = new int[this.xcoords.size()];
            for (int i = 0; i < this.xcoords.size(); ++i) {
                xArray[i] = this.getElt(i, this.xcoords);
                yArray[i] = this.getElt(i, this.ycoords);
            }
            g.setColor(this.getColor(turtleColor));
            if (this.filled) {
                g.fillPolygon(xArray, yArray, this.xcoords.size());
            } else {
                g.drawPolygon(xArray, yArray, this.xcoords.size());
            }
        }
    }

    @Override
    boolean shouldSave() {
        return this.xcoords.size() >= 2;
    }

    @Override
    public String toString() {
        String ret = "";
        ret = ret + "Polygon " + this.c.getRGB() + " " + this.filled + " " + this.marked;
        for (int i = 0; i < this.xcoords.size(); ++i) {
            ret = ret + " " + this.getElt(i, this.xcoords) + " " + this.getElt(i, this.ycoords);
        }
        return ret;
    }

    public static Polygon parsePolygon(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = tokenizer.nextToken().equals("true");
        boolean b2 = tokenizer.nextToken().equals("true");
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> ys = new ArrayList<Integer>();
        Integer lastx = null;
        Integer lasty = null;
        while (tokenizer.hasMoreTokens()) {
            Integer newx = Integer.valueOf(tokenizer.nextToken());
            Integer newy = Integer.valueOf(tokenizer.nextToken());
            if (!newx.equals(lastx) || !newy.equals(lasty)) {
                xs.add(newx);
                ys.add(newy);
            }
            lastx = newx;
            lasty = newy;
        }
        if (xs.size() < 2) {
            return null;
        }
        Polygon polygon = new Polygon(xs, ys, Color.decode(color));
        polygon.setFilled(b1);
        polygon.setMarked(b2);
        return polygon;
    }
}

