/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.nlogo.awt.Utils;
import org.nlogo.swing.UserDialog;

public strictfp class OptionDialog
extends UserDialog {
    JComboBox options;

    public OptionDialog(Frame owner, String title, String message, Object[] choices) {
        super(owner, title);
        this.options = new JComboBox<Object>(choices);
        this.addComponents(this.options, message);
    }

    public Object showOptionDialog() {
        Rectangle r = this.getOwner().getBounds();
        this.setLocation(r.x + r.width / 2 - this.getWidth() / 2, r.y + r.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
        if (this.selection == 0) {
            return this.options.getSelectedIndex();
        }
        return null;
    }

    public static int show(Component owner, String title, String message, Object[] options) {
        List<String> brokenLines = Utils.breakLines(message, owner.getFontMetrics(owner.getFont()), 400);
        StringBuilder brokenMessage = new StringBuilder();
        for (int i = 0; i < brokenLines.size(); ++i) {
            brokenMessage.append(brokenLines.get(i));
            if (i + 1 >= brokenLines.size()) continue;
            brokenMessage.append("\n");
        }
        return JOptionPane.showOptionDialog(Utils.getFrame(owner), brokenMessage.toString(), title, -1, 3, null, options, options[0]);
    }

    public static int showIgnoringCloseBox(Component owner, String title, String message, Object[] options, boolean asList) {
        int result = -1;
        while (result == -1) {
            if (asList) {
                result = OptionDialog.showAsList(owner, title, message, options);
                continue;
            }
            result = OptionDialog.show(owner, title, message, options);
        }
        return result;
    }

    public static int showAsList(Component owner, String title, String message, Object[] options) {
        return Arrays.asList(options).indexOf(JOptionPane.showInputDialog(Utils.getFrame(owner), message, title, 3, null, options, options[0]));
    }
}

