/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessControlException;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Utils;

public strictfp final class SysInfo {
    private static String JOGLInfoString = "JOGL: (3D View not initialized)";
    private static String GLInfoString = "OpenGL Graphics: (3D View not initialized)";
    private static String svnRevision = null;
    private static String urlHeader = "URL: svn+ssh://monk.ccl.northwestern.edu/srv/svnrepos/netlogo/";

    private SysInfo() {
        throw new IllegalStateException();
    }

    public static String getProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static String getVMInfoString() {
        String result = SysInfo.getProperty("java.vm.name") + " " + SysInfo.getProperty("java.version") + " (" + SysInfo.getProperty("java.vendor");
        if (SysInfo.getProperty("java.fullversion") != null) {
            result = result + "; " + SysInfo.getProperty("java.fullversion");
        } else if (SysInfo.getProperty("java.runtime.version") != null) {
            result = result + "; " + SysInfo.getProperty("java.runtime.version");
        }
        result = result + ")";
        return result;
    }

    public static boolean isLibgcj() {
        return SysInfo.getVMInfoString().indexOf("libgcj") != -1;
    }

    public static String getOSInfoString() {
        return "operating system: " + SysInfo.getProperty("os.name") + " " + SysInfo.getProperty("os.version") + " (" + SysInfo.getProperty("os.arch") + " processor)";
    }

    public static String getMemoryInfoString() {
        Runtime runtime = Runtime.getRuntime();
        System.gc();
        long total2 = runtime.totalMemory() / 1024L / 1024L;
        long free = runtime.freeMemory() / 1024L / 1024L;
        long max = runtime.maxMemory() / 1024L / 1024L;
        return "Java heap: used = " + (total2 - free) + " MB, free = " + free + " MB, max = " + max + " MB";
    }

    public static String getJOGLInfoString() {
        return JOGLInfoString;
    }

    public static String getGLInfoString() {
        return GLInfoString;
    }

    public static String getSVNInfoString() {
        if (svnRevision == null) {
            svnRevision = "n/a";
            if (Utils.class.getResourceAsStream("/system/svnversion.txt") != null) {
                String[] stringArray = Utils.getResourceAsStringArray("/system/svnversion.txt");
                svnRevision = stringArray[1] + ":" + stringArray[0];
                return svnRevision;
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("svn info").getInputStream()));
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (string.startsWith("URL:")) {
                        svnRevision = string.substring(string.indexOf(urlHeader) + urlHeader.length()) + ":";
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("svnversion").getInputStream()));
                svnRevision = svnRevision + bufferedReader.readLine();
            }
            catch (AccessControlException accessControlException) {
                Exceptions.ignore(accessControlException);
            }
            catch (IOException iOException) {
                Exceptions.ignore(iOException);
            }
        }
        return svnRevision;
    }

    public static String getBrowserInfoString() {
        try {
            String vendor;
            String version;
            int nulls = 0;
            String browser = SysInfo.getProperty("browser");
            if (browser == null) {
                ++nulls;
                browser = "(unknown browser)";
            }
            if ((version = SysInfo.getProperty("browser.version")) == null) {
                ++nulls;
                version = "(unknown version)";
            }
            if ((vendor = SysInfo.getProperty("browser.vendor")) == null) {
                ++nulls;
                vendor = "";
            } else {
                vendor = " (" + vendor + ")";
            }
            if (nulls == 3) {
                return null;
            }
            return browser + " " + version + vendor;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }
}

