/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.nlogo.api.Editable;
import org.nlogo.api.PropertyDescription;
import org.nlogo.api.Version;
import org.nlogo.awt.Utils;
import org.nlogo.plot.Plot;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.PlotCanvas;
import org.nlogo.window.PlotLegend;
import org.nlogo.window.Widget;
import org.nlogo.window.XAxisLabels;
import org.nlogo.window.YAxisLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class AbstractPlotWidget
extends Widget
implements Editable {
    final PlotCanvas canvas;
    final Plot plot;
    final PlotLegend legend;
    final JLabel nameLabel = new JLabel("", 0);
    final XAxisLabels xAxis = new XAxisLabels();
    final YAxisLabels yAxis = new YAxisLabels();
    static final Dimension MIN_SIZE = new Dimension(160, 120);
    static final Dimension PREF_SIZE = new Dimension(200, 150);

    public AbstractPlotWidget(String name) {
        this.canvas = new PlotCanvas(name);
        this.plot = this.canvas.plot;
        this.legend = new PlotLegend(this.plot, this);
        this.setBorder(this.widgetBorder);
        this.setOpaque(true);
        Utils.adjustDefaultFont(this);
        this.setBackground(InterfaceColors.PLOT_BACKGROUND);
        this.plot.clear();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 1, 1, 1);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        gridbag.setConstraints(this.nameLabel, c);
        this.add(this.nameLabel);
        Utils.adjustDefaultFont(this.nameLabel);
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        c.insets = new Insets(0, 1, 0, 1);
        c.gridx = -1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = -1;
        c.weighty = 3.0;
        c.anchor = 17;
        c.fill = 3;
        gridbag.setConstraints(this.yAxis, c);
        this.add(this.yAxis);
        c.gridwidth = -1;
        c.weightx = 3.0;
        c.anchor = 10;
        c.fill = 1;
        gridbag.setConstraints(this.canvas, c);
        this.add(this.canvas);
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        c.insets = new Insets(0, 3, 0, 1);
        gridbag.setConstraints(this.legend, c);
        this.add(this.legend);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 2;
        JLabel filler2 = new JLabel();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(filler2, c);
        this.add(filler2);
        c.gridwidth = -1;
        c.anchor = 10;
        c.fill = 2;
        gridbag.setConstraints(this.xAxis, c);
        this.add(this.xAxis);
        JLabel filler3 = new JLabel();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 0;
        gridbag.setConstraints(filler3, c);
        this.add(filler3);
        this.refreshGUI();
    }

    @Override
    public String classDisplayName() {
        return "Plot";
    }

    @Override
    public String displayName() {
        return this.plot.name();
    }

    @Override
    public List<PropertyDescription> propertySet() {
        ArrayList<PropertyDescription> propertySet = new ArrayList<PropertyDescription>();
        propertySet.add(new PropertyDescription("plotName", "Name", "PlotName", 0, true));
        propertySet.add(new PropertyDescription("xLabel", "X axis label", "String", 1, false));
        propertySet.add(new PropertyDescription("defaultXMin", "X min", "Double", -1, false));
        propertySet.add(new PropertyDescription("defaultXMax", "X max", "Double", 0, false));
        propertySet.add(new PropertyDescription("yLabel", "Y axis label", "String", 1, false));
        propertySet.add(new PropertyDescription("defaultYMin", "Y min", "Double", -1, false));
        propertySet.add(new PropertyDescription("defaultYMax", "Y max", "Double", 0, false));
        propertySet.add(new PropertyDescription("defaultAutoPlotOn", "Autoplot", "Boolean", 0, false));
        propertySet.add(new PropertyDescription("showLegend", "Show legend", "Boolean", 0, false));
        propertySet.add(new PropertyDescription("editPlotPens", "Plot pens", "PlotPens", 0, false));
        return propertySet;
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.clear();
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        return PREF_SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return null;
    }

    void refreshGUI() {
        String label = Double.toString(this.plot.xMin());
        if (label.endsWith(".0")) {
            label = label.substring(0, label.length() - 2);
        }
        this.xAxis.setMin(label);
        label = Double.toString(this.plot.xMax());
        if (label.endsWith(".0")) {
            label = label.substring(0, label.length() - 2);
        }
        this.xAxis.setMax(label);
        label = Double.toString(this.plot.yMin());
        if (label.endsWith(".0")) {
            label = label.substring(0, label.length() - 2);
        }
        this.yAxis.setMin(label);
        label = Double.toString(this.plot.yMax());
        if (label.endsWith(".0")) {
            label = label.substring(0, label.length() - 2);
        }
        this.yAxis.setMax(label);
        if (this.plot.pensDirty) {
            this.legend.refresh();
            this.legend.repaint();
            this.plot.pensDirty = false;
        }
    }

    public Plot plot() {
        return this.plot;
    }

    public void clear() {
        this.plot.clear();
        this.legend.refresh();
    }

    public void plotName(String name) {
        this.plot.name(name);
        this.nameLabel.setText(name);
    }

    public void xLabel(String label) {
        this.xAxis.setLabel(label);
    }

    public void yLabel(String label) {
        this.yAxis.setLabel(label);
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        this.plotName(strings[5].equals("NIL") ? "" : strings[5]);
        if (7 < strings.length) {
            this.xLabel(strings[6].equals("NIL") ? "" : strings[6]);
            this.yLabel(strings[7].equals("NIL") ? "" : strings[7]);
        }
        if (11 < strings.length) {
            this.plot.defaultXMin(Double.valueOf(strings[8]));
            this.plot.defaultXMax(Double.valueOf(strings[9]));
            this.plot.defaultYMin(Double.valueOf(strings[10]));
            this.plot.defaultYMax(Double.valueOf(strings[11]));
        }
        if (13 < strings.length) {
            this.plot.defaultAutoPlotOn(Boolean.valueOf(strings[12]));
            this.legend.setOpen(Boolean.valueOf(strings[13]));
        }
        if (15 < strings.length && strings[14].equals("PENS")) {
            String version = helper.version();
            this.plot.loadPens(strings, Version.olderThan30pre5(version) || Version.olderThan3DPreview3(version));
        }
        this.clear();
        return this;
    }

    public BufferedImage exportGraphics() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paint(image.getGraphics());
        return image;
    }
}

