/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.agent.ChooserConstraint;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Dump;
import org.nlogo.awt.Utils;
import org.nlogo.swing.WrappingPopupMenu;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Widget;

public strictfp abstract class Chooser
extends Widget
implements MouseWheelListener {
    protected final CompilerServices compiler;
    ChooserConstraint constraint = new ChooserConstraint();
    private final ChooserClickControl control = new ChooserClickControl();
    private String name = "";

    public Chooser(CompilerServices compiler) {
        this.compiler = compiler;
        this.setOpaque(true);
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        this.setLayout(null);
        this.add(this.control);
        this.doLayout();
        Utils.adjustDefaultFont(this);
        this.addMouseWheelListener(this);
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.repaint();
    }

    protected int index() {
        return this.constraint.defaultIndex();
    }

    protected void index(int index) {
        this.constraint.defaultIndex(index);
        this.updateConstraints();
        this.repaint();
    }

    public Object value() {
        return this.constraint.defaultValue();
    }

    public void updateConstraints() {
        if (this.name().length() > 0) {
            new Events.AddChooserConstraintEvent(this.name, this.constraint).raise(this);
        }
    }

    public void doLayout() {
        int controlHeight = this.getHeight() / 2;
        this.control.setBounds(4, this.getHeight() - 4 - controlHeight, this.getWidth() - 8, controlHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(92, 45);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 45);
    }

    public Dimension getPreferredSize(Font font) {
        int width = 120;
        FontMetrics metrics = this.getFontMetrics(font);
        width = StrictMath.max(width, metrics.stringWidth(this.name) + 8 + 14);
        width = StrictMath.max(width, this.longestChoiceWidth(metrics) + this.triangleSize() + 20 + 14 + 2);
        return new Dimension(width, 45);
    }

    private int longestChoiceWidth(FontMetrics metrics) {
        int result = 0;
        for (int i = 0; i < this.constraint.acceptedValues().size(); ++i) {
            int width = metrics.stringWidth(Dump.logoObject(this.constraint.acceptedValues().get(i)));
            result = StrictMath.max(result, width);
        }
        return result;
    }

    private int triangleSize() {
        return this.control.getBounds().height / 2 - 4;
    }

    public void popup() {
        WrappingPopupMenu menu = new WrappingPopupMenu();
        this.populate(menu);
        menu.show(this, this.control.getBounds().x + 3, this.control.getBounds().y + this.control.getBounds().height);
    }

    public void populate(JPopupMenu menu) {
        if (this.constraint.acceptedValues().isEmpty()) {
            JMenuItem nullItem = new JMenuItem("<No Choices>");
            nullItem.setEnabled(false);
            menu.add(nullItem);
        } else {
            int i = 0;
            while (i < this.constraint.acceptedValues().size()) {
                JMenuItem item = new JMenuItem(Dump.logoObject(this.constraint.acceptedValues().get(i)));
                final int iFinal = i++;
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Chooser.this.index(iFinal);
                    }
                });
                menu.add(item);
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Rectangle cb = this.control.getBounds();
        g.setColor(this.getForeground());
        FontMetrics metrics = g.getFontMetrics();
        int fontAscent = metrics.getMaxAscent();
        int fontHeight = fontAscent + metrics.getMaxDescent();
        String shortenedName = Utils.shortenStringToFit(this.name, size.width - 8, metrics);
        g.drawString(shortenedName, 4, 4 + (cb.y - 4 - fontHeight) / 2 + fontAscent);
        String shortenedValue = Utils.shortenStringToFit(Dump.logoObject(this.value()), cb.width - 12 - this.triangleSize() - 2, metrics);
        g.drawString(shortenedValue, cb.x + 4, cb.y + (cb.height - fontHeight) / 2 + fontAscent);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Chooser.filledDownTriangle(g, cb.x + cb.width - 4 - this.triangleSize() - 2, cb.y + (cb.height - this.triangleSize()) / 2 + 1, this.triangleSize());
    }

    private static void filledDownTriangle(Graphics g, int x, int y, int size) {
        Polygon shadowTriangle = new Polygon();
        shadowTriangle.addPoint(x + size / 2, y + size + 2);
        shadowTriangle.addPoint(x - 1, y - 1);
        shadowTriangle.addPoint(x + size + 2, y - 1);
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(shadowTriangle);
        Polygon downTriangle = new Polygon();
        downTriangle.addPoint(x + size / 2, y + size);
        downTriangle.addPoint(x, y);
        downTriangle.addPoint(x + size, y);
        g.setColor(InterfaceColors.SLIDER_HANDLE);
        g.fillPolygon(downTriangle);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() >= 1) {
            int max = this.constraint.acceptedValues().size() - 1;
            this.index(StrictMath.min(max, this.index() + 1));
        } else {
            this.index(StrictMath.max(0, this.index() - 1));
        }
    }

    private strictfp class ChooserClickControl
    extends JComponent {
        ChooserClickControl() {
            this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
            this.setBorder(Chooser.this.widgetBorder);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Chooser.this.popup();
                }
            });
        }
    }
}

