/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Token;
import org.nlogo.api.TokenType;
import org.nlogo.editor.Colorizer;
import org.nlogo.window.QuickHelp;
import org.nlogo.window.SyntaxColors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class EditorColorizer
implements Colorizer<TokenType> {
    private final CompilerServices compiler;
    private String lastLine = "";
    Color[] lastColors = new Color[0];

    public EditorColorizer(CompilerServices compiler) {
        this.compiler = compiler;
    }

    @Override
    public void reset() {
        this.lastLine = "";
        this.lastColors = new Color[0];
    }

    @Override
    public Color[] getCharacterColors(String line) {
        int i;
        if (line.equals(this.lastLine)) {
            return this.lastColors;
        }
        Color[] result = new Color[line.length()];
        Token[] tokens = this.tokenizeForColorization(line);
        for (i = 0; i < result.length; ++i) {
            result[i] = SyntaxColors.DEFAULT_COLOR;
        }
        for (i = 0; i < tokens.length; ++i) {
            TokenType type = tokens[i].tyype();
            if (type == TokenType.VARIABLE && tokens[i].startPos() == 0 && tokens[i].name().equalsIgnoreCase("BREED")) {
                type = TokenType.KEYWORD;
            }
            Color color = EditorColorizer.getTokenColor(type);
            for (int j = tokens[i].startPos(); j < tokens[i].endPos(); ++j) {
                result[j] = color;
            }
        }
        this.lastColors = result;
        this.lastLine = line;
        return result;
    }

    @Override
    public List<TokenType> getCharacterTokenTypes(String line) {
        TokenType[] result = new TokenType[line.length()];
        Token[] tokens = this.tokenizeForColorization(line);
        for (int i = 0; i < tokens.length; ++i) {
            for (int j = tokens[i].startPos(); j < tokens[i].endPos(); ++j) {
                result[j] = tokens[i].tyype();
            }
        }
        return Arrays.asList(result);
    }

    @Override
    public boolean isMatch(TokenType token1, TokenType token2) {
        return token1 == TokenType.OPEN_PAREN && token2 == TokenType.CLOSE_PAREN || token1 == TokenType.OPEN_BRACKET && token2 == TokenType.CLOSE_BRACKET;
    }

    @Override
    public boolean isOpener(TokenType token) {
        return token == TokenType.OPEN_PAREN || token == TokenType.OPEN_BRACKET;
    }

    @Override
    public boolean isCloser(TokenType token) {
        return token == TokenType.CLOSE_PAREN || token == TokenType.CLOSE_BRACKET;
    }

    public Token[] tokenizeForColorization(String line) {
        return this.compiler.tokenizeForColorization(line);
    }

    private static Color getTokenColor(TokenType type) {
        switch (type) {
            case CONSTANT: {
                return SyntaxColors.CONSTANT_COLOR;
            }
            case COMMAND: {
                return SyntaxColors.COMMAND_COLOR;
            }
            case REPORTER: {
                return SyntaxColors.REPORTER_COLOR;
            }
            case VARIABLE: {
                return SyntaxColors.REPORTER_COLOR;
            }
            case KEYWORD: {
                return SyntaxColors.KEYWORD_COLOR;
            }
            case COMMENT: {
                return SyntaxColors.COMMENT_COLOR;
            }
        }
        return SyntaxColors.DEFAULT_COLOR;
    }

    @Override
    public String getTokenAtPosition(String text, int position) {
        Token token = this.compiler.getTokenAtPosition(text, position);
        if (token != null) {
            return token.name();
        }
        return null;
    }

    @Override
    public void doHelp(Component comp, String name) {
        QuickHelp.doHelp(comp, name);
    }
}

