/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.EditorKit;
import org.nlogo.agent.InputBoxConstraint;
import org.nlogo.agent.World;
import org.nlogo.api.Approximate;
import org.nlogo.api.CompilerException;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Dump;
import org.nlogo.api.Editable;
import org.nlogo.api.File;
import org.nlogo.api.LogoException;
import org.nlogo.api.Options;
import org.nlogo.api.ValueConstraint;
import org.nlogo.awt.Utils;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.ColorDialog;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class InputBox
extends Widget
implements Editable,
Events.InputBoxLoseFocusEvent.Handler {
    private final InputBoxConstraint constraint;
    protected final JButton changeButton;
    private final CompilerServices compiler;
    private boolean hasFocus = false;
    protected final JLabel widgetLabel = new JLabel();
    protected final AbstractEditorArea textArea;
    protected final AbstractEditorArea editDialogTextArea;
    protected final JButton colorSwatch;
    protected InputDialog dialog = null;
    private final EditorKit codeEditorKit;
    private final JScrollPane scroller;
    private final Component nextComponent;
    protected boolean editing = false;
    protected String name = "";
    protected boolean nameChanged = false;
    protected boolean multiline = false;
    protected InputType type;
    private Options<InputType> typeOptions = new Options();
    protected String text = "";
    protected Object value = "";

    @Override
    public String classDisplayName() {
        return "Input Box";
    }

    private static String getColorString(double c) {
        if (c == 0.0) {
            return "0 (black)";
        }
        if (c == 9.9) {
            return "9.9 (white)";
        }
        int index = (int)(c / 10.0);
        String colorString = Dump.number(c) + " (" + org.nlogo.api.Color.getColorNameByIndex(index);
        int baseColor = index * 10 + 5;
        if (c > (double)baseColor) {
            colorString = colorString + " + " + Dump.number(Approximate.approximate(c - (double)baseColor, 1));
        } else if (c < (double)baseColor) {
            colorString = colorString + " - " + Dump.number(Approximate.approximate((double)baseColor - c, 1));
        }
        return colorString + ")";
    }

    public InputBox(AbstractEditorArea textArea, AbstractEditorArea editDialogTextArea, CompilerServices compiler, Component nextComponent) {
        this.compiler = compiler;
        this.textArea = textArea;
        this.editDialogTextArea = editDialogTextArea;
        this.nextComponent = nextComponent;
        this.codeEditorKit = textArea.getEditorKit();
        this.type = new InputType("String", textArea.getEditorKitForContentType("String"), UIManager.getFont("Label.font").deriveFont(12.0f));
        this.constraint = new InputBoxConstraint(this.type.name(), this.type.defaultValue());
        this.typeOptions().addOption("Number", new NumberInputType(this.codeEditorKit));
        this.typeOptions().addOption("String", this.type);
        this.typeOptions().addOption("String (reporter)", new ReporterInputType(this.codeEditorKit));
        this.typeOptions().addOption("String (commands)", new CommandInputType(this.codeEditorKit));
        this.typeOptions().addOption("Color", new ColorInputType(this.codeEditorKit));
        this.typeOptions().selectValue(this.type);
        textArea.setEditorKit(this.type.getEditorKit());
        textArea.setFont(this.type.getFont());
        textArea.enableBracketMatcher(this.type.enableBracketMatcher());
        this.changeButton = new NLButton("Change");
        this.changeButton.addActionListener(new EditActionListener());
        this.multiline(this.multiline);
        this.colorSwatch = new JButton("black");
        this.colorSwatch.setFont(UIManager.getFont("Label.font").deriveFont(9.0f));
        this.colorSwatch.setBorder(this.widgetBorder);
        this.colorSwatch.addActionListener(new SelectColorActionListener());
        this.colorSwatch.setContentAreaFilled(false);
        this.colorSwatch.setOpaque(true);
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        this.setBorder(this.widgetBorder);
        this.setOpaque(true);
        Utils.adjustDefaultFont(this);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        layout.setConstraints(this.widgetLabel, c);
        this.add(this.widgetLabel);
        this.widgetLabel.setFont(new Font(Utils.platformFont(), 0, 10));
        c.gridx = 1;
        c.weightx = 0.0;
        c.anchor = 13;
        layout.setConstraints(this.changeButton, c);
        this.add((Component)this.changeButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 17;
        this.scroller = new JScrollPane(textArea, 20, 31);
        layout.setConstraints(this.scroller, c);
        this.add(this.scroller);
        layout.setConstraints(this.colorSwatch, c);
        this.add((Component)this.colorSwatch, c);
        this.colorSwatch.setVisible(false);
        textArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                InputBox.this.hasFocus = true;
                if (InputBox.this.multiline) {
                    return;
                }
                InputBox.this.editing = true;
            }

            public void focusLost(FocusEvent e) {
                InputBox.this.hasFocus = false;
                if (InputBox.this.editing) {
                    try {
                        Object value = InputBox.this.type.readValue(InputBox.this.textArea.getText());
                        InputBox.this.inputText(value);
                    }
                    catch (LogoException ex) {
                        InputBox.this.showError(ex);
                        Utils.invokeLater(new Runnable(){

                            public void run() {
                                InputBox.this.textArea.requestFocus();
                            }
                        });
                    }
                    catch (CompilerException ex) {
                        InputBox.this.showError(ex);
                        Utils.invokeLater(new Runnable(){

                            public void run() {
                                InputBox.this.textArea.requestFocus();
                            }
                        });
                    }
                    catch (ValueConstraint.Violation ex) {
                        InputBox.this.showError(ex);
                        Utils.invokeLater(new Runnable(){

                            public void run() {
                                InputBox.this.textArea.requestFocus();
                            }
                        });
                    }
                    InputBox.this.editing = false;
                }
            }
        });
        textArea.getInputMap().put(KeyStroke.getKeyStroke(27, 0), new CancelAction());
        textArea.getInputMap().put(KeyStroke.getKeyStroke(10, 0), new TransferFocusAction());
        textArea.getInputMap().put(KeyStroke.getKeyStroke(9, 0), new TransferFocusAction());
    }

    private void showError(Exception ex) {
        Frame frame = Utils.getFrame(this);
        if (frame != null) {
            String msg = ex.getMessage();
            if (msg.startsWith("REPORT expected 1 input.")) {
                msg = "Expected reporter.";
            }
            OptionDialog.show(frame, "Invalid input for a " + this.type, msg, new String[]{"OK"});
        }
    }

    @Override
    public void handle(Events.InputBoxLoseFocusEvent e) {
        if (this.hasFocus) {
            this.transferFocus();
        }
    }

    protected void stopEdit() {
        this.editing = false;
        this.transferFocus();
        this.nextComponent.requestFocus();
    }

    @Override
    public void updateConstraints() {
        if (this.name().length() > 0) {
            new Events.AddInputBoxConstraintEvent(this.name, this.constraint).raise(this);
        }
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name(name, true);
    }

    protected void name(String name, boolean sendEvent) {
        this.name = name;
        this.displayName(name);
        this.widgetLabel.setText(name);
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.name(this.name(), this.nameChanged);
        this.nameChanged = false;
        try {
            Object val = this.type.readValue(this.text);
            this.inputText(this.constraint.coerceValue(val));
        }
        catch (LogoException ex) {
            throw new IllegalStateException(ex);
        }
        catch (CompilerException ex) {
            this.showError(ex);
        }
        catch (ValueConstraint.Violation e) {
            this.showError(e);
        }
        return true;
    }

    public void multiline(boolean multiline) {
        this.multiline = multiline;
        this.textArea.setEditable(!this.type.changeVisible());
        this.changeButton.setVisible(this.type.changeVisible());
        this.editing = false;
    }

    public Options<InputType> typeOptions() {
        return this.typeOptions;
    }

    public Object valueObject() {
        return this.value;
    }

    public void valueObject(Object value) {
        this.valueObject(value, false);
    }

    public void valueObject(Object value, boolean raiseEvent) {
        this.text = Dump.logoObject(value);
        this.value = value;
        if (!this.text.equals(this.textArea.getText())) {
            this.textArea.setText(this.text);
        }
    }

    protected void inputText(Object input) {
        if (input != null) {
            this.valueObject(input, true);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(50, 60);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        Dimension result = super.getPreferredSize(font);
        Insets insets = this.getInsets();
        result.width = this.textArea.getPreferredSize().width + insets.left + insets.right + this.textArea.getInsets().right + this.textArea.getInsets().left + 4;
        return new Dimension(StrictMath.max(50, result.width), StrictMath.max(60, result.height));
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        String displayName = strings[5];
        if (displayName.equals("NIL")) {
            this.name("");
        } else {
            this.name(displayName);
        }
        String contents = File.restoreLines(strings[6]);
        if (contents.equals("NIL")) {
            contents = "";
        }
        if (strings.length > 8) {
            this.multiline(strings[8].equals("1"));
        }
        if (strings.length > 9) {
            this.setType(strings[9]);
        } else {
            this.setType("String");
        }
        try {
            this.valueObject(this.type.readValue(contents), true);
        }
        catch (CompilerException e) {
            this.valueObject(this.type.defaultValue(), true);
        }
        catch (ValueConstraint.Violation e) {
            this.valueObject(this.type.defaultValue(), true);
        }
        catch (LogoException e) {
            this.valueObject(this.type.defaultValue(), true);
        }
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }

    private void setType(String type) {
        if (type.equals("Reporter")) {
            type = "String (reporter)";
        } else if (type.equals("Commands")) {
            type = "String (commands)";
        }
        this.type = type.equals("Number") ? new NumberInputType(this.codeEditorKit) : (type.equals("Color") ? new ColorInputType(this.codeEditorKit) : (type.equals("String (reporter)") ? new ReporterInputType(this.codeEditorKit) : (type.equals("String (commands)") ? new CommandInputType(this.codeEditorKit) : new InputType(type, this.textArea.getEditorKitForContentType("String"), UIManager.getFont("Label.font")))));
        this.textArea.setEditorKit(this.type.getEditorKit());
        this.textArea.setFont(this.type.getFont());
        this.textArea.enableBracketMatcher(this.type.enableBracketMatcher());
        this.typeOptions().selectByName(type);
        this.constraint.setType(this.type.name(), this.type.defaultValue());
        this.changeButton.setVisible(this.type.changeVisible());
    }

    @Override
    public boolean hasContextMenu() {
        return true;
    }

    @Override
    public Dimension getMaximumSize() {
        return null;
    }

    private strictfp class ColorInputType
    extends InputType {
        ColorInputType(EditorKit kit) {
            super("Color", kit, new Font(Utils.platformMonospacedFont(), 0, 12));
        }

        Object readValue(String text) throws CompilerException {
            return InputBox.this.compiler.readNumberFromString(text);
        }

        void colorPanel(JButton panel) {
            panel.setVisible(true);
            InputBox.this.scroller.setVisible(false);
            panel.setOpaque(true);
            Color c = Color.BLACK;
            double colorval = 0.0;
            if (InputBox.this.value instanceof Double) {
                colorval = org.nlogo.api.Color.modulateDouble((double)((Double)InputBox.this.value));
                c = org.nlogo.api.Color.getColor(colorval);
            }
            panel.setBackground(c);
            panel.setForeground(colorval % 10.0 > 5.0 ? Color.black : Color.white);
            panel.setText(InputBox.getColorString(colorval));
        }

        boolean changeVisible() {
            return false;
        }

        public Object defaultValue() {
            return World.ZERO;
        }
    }

    private strictfp class NumberInputType
    extends InputType {
        NumberInputType(EditorKit kit) {
            super("Number", kit, new Font(Utils.platformMonospacedFont(), 0, 12));
        }

        Object readValue(String text) throws CompilerException {
            return InputBox.this.compiler.readNumberFromString(text);
        }

        public Object defaultValue() {
            return World.ZERO;
        }
    }

    private strictfp class CommandInputType
    extends InputType {
        CommandInputType(EditorKit kit) {
            super("String (commands)", kit, new Font(Utils.platformMonospacedFont(), 0, 12));
        }

        boolean enableBracketMatcher() {
            return true;
        }

        Object readValue(String text) throws CompilerException, ValueConstraint.Violation {
            InputBox.this.constraint.assertConstraint(text);
            InputBox.this.compiler.checkCommandSyntax(text);
            return text;
        }
    }

    private strictfp class ReporterInputType
    extends InputType {
        ReporterInputType(EditorKit kit) {
            super("String (reporter)", kit, new Font(Utils.platformMonospacedFont(), 0, 12));
        }

        public Object defaultValue() {
            return "0";
        }

        boolean enableBracketMatcher() {
            return true;
        }

        Object readValue(String text) throws CompilerException, ValueConstraint.Violation {
            InputBox.this.constraint.assertConstraint(text);
            InputBox.this.compiler.checkReporterSyntax(text);
            return text;
        }
    }

    public strictfp class InputType {
        private final String name1;
        private final EditorKit editorKit;
        private final Font font;

        public Object defaultValue() {
            return "";
        }

        InputType(String name, EditorKit editorKit, Font font) {
            this.name1 = name;
            this.editorKit = editorKit;
            this.font = font;
        }

        public String toString() {
            return this.name1;
        }

        public String name() {
            return this.name1;
        }

        EditorKit getEditorKit() {
            return this.editorKit;
        }

        Font getFont() {
            return this.font;
        }

        void colorPanel(JButton panel) {
            panel.setVisible(false);
            InputBox.this.scroller.setVisible(true);
        }

        Object readValue(String text) throws ValueConstraint.Violation, LogoException, CompilerException {
            InputBox.this.constraint.assertConstraint(text);
            return text;
        }

        boolean changeVisible() {
            return InputBox.this.multiline;
        }

        boolean enableBracketMatcher() {
            return false;
        }
    }

    protected strictfp class InputDialog
    extends JDialog {
        private final AbstractEditorArea textArea1;
        private final Action okAction;
        private final Action cancelAction;
        private final Action applyAction;

        public InputDialog(Frame parent, String title, InputType type, AbstractEditorArea textArea) {
            super(parent, title);
            this.okAction = new AbstractAction("OK"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Object value = InputBox.this.type.readValue(InputDialog.this.textArea1.getText());
                        InputBox.this.inputText(value);
                        InputBox.this.editing = false;
                        InputDialog.this.dispose();
                        InputBox.this.dialog = null;
                    }
                    catch (LogoException ex) {
                        InputBox.this.showError(ex);
                    }
                    catch (CompilerException ex) {
                        InputBox.this.showError(ex);
                    }
                    catch (ValueConstraint.Violation ex) {
                        InputBox.this.showError(ex);
                    }
                }
            };
            this.cancelAction = new AbstractAction("Cancel"){

                public void actionPerformed(ActionEvent e) {
                    InputDialog.this.dispose();
                    InputBox.this.editing = false;
                    InputBox.this.dialog = null;
                }
            };
            this.applyAction = new AbstractAction("Apply"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Object value = InputBox.this.type.readValue(InputDialog.this.textArea1.getText());
                        InputBox.this.inputText(value);
                    }
                    catch (LogoException ex) {
                        InputBox.this.showError(ex);
                    }
                    catch (CompilerException ex) {
                        InputBox.this.showError(ex);
                    }
                    catch (ValueConstraint.Violation ex) {
                        InputBox.this.showError(ex);
                    }
                }
            };
            this.setResizable(true);
            this.textArea1 = textArea;
            textArea.setEditorKit(type.getEditorKit());
            textArea.setFont(type.getFont());
            textArea.enableBracketMatcher(type.enableBracketMatcher());
            GridBagLayout layout = new GridBagLayout();
            this.getContentPane().setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.gridwidth = 0;
            c.anchor = 17;
            JLabel label = new JLabel(type.toString());
            layout.setConstraints(label, c);
            this.getContentPane().add(label);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            JScrollPane scroller = new JScrollPane(textArea);
            layout.setConstraints(scroller, c);
            this.getContentPane().add(scroller);
            ButtonPanel buttonPanel = new ButtonPanel(new JButton[]{new JButton(this.okAction), new JButton(this.applyAction), new JButton(this.cancelAction)});
            c.gridy = 2;
            c.anchor = 13;
            c.weightx = 0.0;
            c.weighty = 0.0;
            layout.setConstraints(buttonPanel, c);
            this.getContentPane().add(buttonPanel);
            org.nlogo.swing.Utils.addEscKeyAction(this, this.cancelAction);
            this.pack();
            Utils.center(this, parent);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    InputDialog.this.dispose();
                    InputBox.this.editing = false;
                    InputBox.this.dialog = null;
                }
            });
        }
    }

    protected strictfp class NLButton
    extends JButton {
        public NLButton(String title) {
            super(title);
            this.setFont(new Font(Utils.platformFont(), 0, 10));
            this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setFocusable(false);
            this.setOpaque(false);
            this.setFont(new Font(Utils.platformFont(), 0, 10));
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }
    }

    private strictfp class TransferFocusAction
    extends AbstractAction {
        private TransferFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            InputBox.this.transferFocus();
            InputBox.this.nextComponent.requestFocus();
        }
    }

    private strictfp class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            InputBox.this.textArea.setText(InputBox.this.text);
            InputBox.this.stopEdit();
        }
    }

    private strictfp class SelectColorActionListener
    implements ActionListener {
        private SelectColorActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorDialog colorDialog = new ColorDialog(Utils.getFrame(InputBox.this), true);
            double initialColor = 0.0;
            if (InputBox.this.value instanceof Double) {
                initialColor = org.nlogo.api.Color.modulateDouble((double)((Double)InputBox.this.value));
            }
            double c = colorDialog.showInputBoxDialog(initialColor);
            InputBox.this.valueObject(c, true);
        }
    }

    private strictfp class EditActionListener
    implements ActionListener {
        private EditActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!InputBox.this.editing) {
                InputBox.this.editing = true;
                InputBox.this.dialog = new InputDialog(Utils.getFrame(InputBox.this), InputBox.this.name, InputBox.this.type, InputBox.this.editDialogTextArea);
                InputBox.this.dialog.setVisible(true);
                InputBox.this.editDialogTextArea.setText(InputBox.this.textArea.getText());
                InputBox.this.editDialogTextArea.selectAll();
            }
        }
    }
}

