/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import org.nlogo.api.ModelReader;
import org.nlogo.api.ModelType;
import org.nlogo.api.Version;
import org.nlogo.swing.BrowserLauncher;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.InvalidVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ModelLoader
implements Event.LinkChild {
    private final Component linkParent;

    private ModelLoader(Container linkParent) {
        this.linkParent = linkParent;
    }

    @Override
    public Object getLinkParent() {
        return this.linkParent;
    }

    public static void load(Container linkParent, String modelPath, ModelType modelType, String source2) throws InvalidVersionException {
        new ModelLoader(linkParent).loadHelper(modelPath, modelType, ModelReader.parseString(source2));
    }

    private int versionWarning(String message) {
        Object[] options = new String[]{"Continue", "Open Transition Guide", "Cancel"};
        return OptionDialog.show(this.linkParent, "Warning", message, options);
    }

    private void loadHelper(String modelPath, ModelType modelType, Map<ModelReader.Section, String[]> map2) throws InvalidVersionException {
        boolean mayNeedWarning;
        if (map2 == null) {
            throw new InvalidVersionException();
        }
        String version = ModelReader.parseVersion(map2);
        if (version == null || !version.startsWith("NetLogo")) {
            throw new InvalidVersionException();
        }
        boolean bl = mayNeedWarning = Version.is3D() == Version.is3D(version) && !Version.compatibleVersion(version);
        if (mayNeedWarning) {
            boolean loop2 = true;
            block5: while (loop2) {
                int response = this.versionWarning("This model was created in " + version + ". You may need to make changes for it to work in " + Version.version() + ".");
                switch (response) {
                    case 0: {
                        loop2 = false;
                        continue block5;
                    }
                    case 1: {
                        BrowserLauncher.openURL(this.linkParent, "http://ccl.northwestern.edu/netlogo/4.1/docs/transition.html", false);
                        continue block5;
                    }
                    case 2: {
                        return;
                    }
                }
                throw new IllegalStateException();
            }
        }
        new Events.BeforeLoadEvent(modelPath, modelType).raise(this);
        new Events.RemoveAllJobsEvent().raise(this);
        new Events.LoadBeginEvent().raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.PREVIEW_COMMANDS, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.SOURCE, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.INFO, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.WIDGETS, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.AGGREGATE, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.SHAPES, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.EXPERIMENTS, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.CLIENT, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.LINK_SHAPES, map2).raise(this);
        this.makeLoadSectionEvent(version, (Object)ModelReader.Section.MODEL_SETTINGS, map2).raise(this);
        new Events.LoadEndEvent().raise(this);
        new Events.AfterLoadEvent().raise(this);
    }

    public Events.LoadSectionEvent makeLoadSectionEvent(String version, Object section, Map<ModelReader.Section, String[]> map2) {
        String[] lines = map2.get(section);
        if (section == ModelReader.Section.SHAPES && lines.length == 0) {
            lines = ModelReader.getDefaultShapesV();
        }
        if (section == ModelReader.Section.LINK_SHAPES && lines.length == 0) {
            lines = ModelReader.getDefaultLinkShapes();
        }
        if (section == ModelReader.Section.AGGREGATE) {
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].replaceAll("org.nlogo.aggregate.gui", "org.nlogo.sdm.gui");
            }
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            buf.append(lines[i] + "\n");
        }
        return new Events.LoadSectionEvent(version, section, lines, buf.toString());
    }
}

