/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.nlogo.api.Dump;
import org.nlogo.api.Editable;
import org.nlogo.api.PropertyDescription;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.OutputArea;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class OutputWidget
extends Widget
implements Editable,
Events.ExportWorldEvent.Handler {
    public final OutputArea outputArea = new OutputArea();

    public OutputWidget() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.widgetBorder);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.setBackground(InterfaceColors.MONITOR_BACKGROUND);
        centerPanel.setBackground(InterfaceColors.MONITOR_BACKGROUND);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        centerPanel.add((Component)this.outputArea, "Center");
        this.add((Component)centerPanel, "Center");
        this.displayName("Output Area");
    }

    @Override
    public List<PropertyDescription> propertySet() {
        ArrayList<PropertyDescription> result = new ArrayList<PropertyDescription>();
        result.add(new PropertyDescription("fontSize", "Font Size", "Integer", 0, false));
        return result;
    }

    @Override
    public String classDisplayName() {
        return "Output Area";
    }

    @Override
    public boolean hasContextMenu() {
        return true;
    }

    @Override
    public Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        JMenuItem copyItem = new JMenuItem("Copy Selected Text");
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputWidget.this.outputArea.text.copy();
            }
        });
        menu.add(copyItem);
        return p;
    }

    @Override
    public void handle(Events.ExportWorldEvent e) {
        e.writer.println(Dump.csv.encode("OUTPUT"));
        Dump.csv.stringToCSV(e.writer, this.outputArea.text.getText());
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        if (strings.length > 5) {
            this.outputArea.fontSize(Integer.parseInt(strings[5]));
        }
        return this;
    }
}

