/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.nlogo.awt.ColumnLayout;
import org.nlogo.awt.Utils;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPen;

strictfp class PlotLegend
extends JPanel {
    final Plot plot;
    private final Component fontSource;
    private boolean open = false;

    void setOpen(boolean open) {
        if (this.open != open) {
            this.toggle();
        }
    }

    PlotLegend(Plot plot, Component fontSource) {
        this.plot = plot;
        this.fontSource = fontSource;
        this.setLayout(new ColumnLayout(2));
        this.setOpaque(false);
    }

    void toggle() {
        this.open = !this.open;
        this.refresh();
    }

    void refresh() {
        this.clearGUI();
        if (this.open) {
            this.fillGUI();
        }
    }

    private void fillGUI() {
        for (PlotPen pen : this.plot.pens()) {
            if (!pen.inLegend()) continue;
            LegendItem item = new LegendItem(pen);
            item.setFont(this.fontSource.getFont());
            this.add(item);
        }
        this.revalidate();
    }

    private void clearGUI() {
        this.removeAll();
        this.revalidate();
    }

    private strictfp class LegendItem
    extends JComponent {
        final PlotPen pen;

        LegendItem(PlotPen pen) {
            Utils.adjustDefaultFont(this);
            this.pen = pen;
        }

        public void paintComponent(Graphics g) {
            int ascent = g.getFontMetrics().getMaxAscent();
            g.setColor(new Color(this.pen.color()));
            g.fillRect(0, 0, ascent, ascent);
            g.setColor(this.getForeground());
            g.drawRect(0, 0, ascent, ascent);
            g.drawString(this.pen.name(), ascent + 4, ascent);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            return new Dimension(metrics.stringWidth(this.pen.name()) + metrics.getMaxAscent() + 4, StrictMath.max(8, metrics.getMaxDescent() + metrics.getMaxAscent()));
        }
    }
}

