/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.awt.ImageSelection;
import org.nlogo.plot.PlotManager;
import org.nlogo.window.AbstractPlotWidget;
import org.nlogo.window.Events;

public strictfp class PlotWidget
extends AbstractPlotWidget
implements Events.PeriodicUpdateEvent.Handler {
    public PlotWidget(PlotManager plotManager) {
        super(PlotWidget.nextName(plotManager));
    }

    public PlotWidget(String name) {
        super(name);
    }

    private static String nextName(PlotManager plotManager) {
        String result;
        int nameCounter = 1;
        do {
            result = "plot " + nameCounter;
            ++nameCounter;
        } while (plotManager.getPlot(result) != null);
        return result;
    }

    public boolean hasContextMenu() {
        return true;
    }

    public Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        JMenuItem copyItem = new JMenuItem("Copy Image");
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(PlotWidget.this.exportGraphics()), null);
            }
        });
        menu.add(copyItem);
        return p;
    }

    public void handle(Events.PeriodicUpdateEvent e) {
        this.canvas.repaintIfNeeded();
        this.refreshGUI();
    }

    public BufferedImage exportGraphics() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paint(image.getGraphics());
        return image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum ExportType {
        PROMPT,
        ALL,
        ARGUMENT;

    }
}

