/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.nlogo.api.LogoException;
import org.nlogo.api.Version;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Instruction;
import org.nlogo.swing.MessageDialog;
import org.nlogo.util.SysInfo;
import org.nlogo.util.Utils;
import org.nlogo.window.Event;
import org.nlogo.workspace.AbstractWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class RuntimeErrorDialog
extends MessageDialog {
    private String title;
    private boolean knownError;
    private String errorMessage;
    private String javaStackTrace;
    private String eventTrace;
    private final String className;
    private String threadName;
    private String textWithoutDetails;
    private String textWithDetails;
    private boolean suppressJavaExceptionDialogs = false;
    private String modelName;
    private static final JButton SUPPRESS_BUTTON = new JButton("Don't show again");
    private static final JCheckBox CHECKBOX = new JCheckBox("Show internal details");

    public static MessageDialog init(Component owner) {
        dialog = new RuntimeErrorDialog(owner);
        return dialog;
    }

    public static void show(String title, Context context, Instruction instruction, Thread thread, Throwable throwable) {
        ((RuntimeErrorDialog)dialog).doShow(title, context, instruction, thread, throwable);
    }

    public static void setModelName(String name) {
        ((RuntimeErrorDialog)RuntimeErrorDialog.dialog).modelName = name;
    }

    private void doShow(String title, Context context, Instruction instruction, Thread thread, Throwable throwable) {
        this.title = title;
        this.threadName = thread.getName();
        this.knownError = throwable instanceof LogoException;
        SUPPRESS_BUTTON.setVisible(!this.knownError && context == null);
        this.javaStackTrace = Utils.getStackTrace(throwable);
        this.eventTrace = Event.recentEventTrace();
        this.errorMessage = context != null ? context.buildRuntimeErrorMessage(instruction, throwable) : (this.knownError ? throwable.getMessage() : null);
        this.buildTexts();
        if (this.textWithDetails.indexOf("sun.font.FontDesignMetrics.charsWidth") == -1) {
            this.showJavaDetails(CHECKBOX.isSelected());
        }
    }

    protected RuntimeErrorDialog(Component owner) {
        super(owner);
        this.className = owner.getClass().getName();
    }

    @Override
    protected List<JComponent> makeButtons() {
        ArrayList<JComponent> buttons = new ArrayList<JComponent>();
        buttons.addAll(super.makeButtons());
        if (!AbstractWorkspace.isApplet()) {
            JButton copyButton = new JButton("Copy");
            copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RuntimeErrorDialog.this.textArea.selectAll();
                    RuntimeErrorDialog.this.textArea.copy();
                    RuntimeErrorDialog.this.textArea.setCaretPosition(0);
                }
            });
            buttons.add(copyButton);
        }
        CHECKBOX.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RuntimeErrorDialog.this.showJavaDetails(CHECKBOX.isSelected());
            }
        });
        buttons.add(CHECKBOX);
        SUPPRESS_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RuntimeErrorDialog.this.suppressJavaExceptionDialogs = true;
                RuntimeErrorDialog.this.setVisible(false);
            }
        });
        buttons.add(SUPPRESS_BUTTON);
        return buttons;
    }

    private void buildTexts() {
        String extra = "";
        if (!this.knownError) {
            extra = "NetLogo is unable to supply you with more details about this error.  Please report the problem to bugs@ccl.northwestern.edu and paste the contents of this window into your E-mail.\n\n";
        }
        this.textWithoutDetails = "";
        if (this.errorMessage != null) {
            this.textWithoutDetails = this.errorMessage;
        }
        this.textWithDetails = this.textWithoutDetails;
        if (!this.textWithDetails.equals("")) {
            this.textWithDetails = this.textWithDetails + "\n\n";
        }
        this.textWithDetails = this.textWithDetails + extra + this.javaStackTrace + "\n" + Version.version() + "\n" + "main: " + this.className + "\n" + "thread: " + this.threadName + "\n" + SysInfo.getVMInfoString() + "\n" + SysInfo.getOSInfoString() + "\n" + SysInfo.getJOGLInfoString() + "\n" + SysInfo.getGLInfoString() + "\n" + SysInfo.getSVNInfoString() + "\n" + "model: " + this.modelName + "\n\n" + this.eventTrace;
        if (!AbstractWorkspace.isApp()) {
            String browser = SysInfo.getBrowserInfoString();
            this.textWithDetails = this.textWithDetails + "\n";
            this.textWithDetails = this.textWithDetails + (browser == null ? "running as applet in unknown browser" : "browser info: " + browser);
        }
    }

    private void showJavaDetails(boolean flag) {
        if (this.knownError) {
            CHECKBOX.setVisible(true);
        } else {
            CHECKBOX.setVisible(false);
            flag = true;
        }
        int lines = 1;
        int lineBegin = 0;
        int longestLine = 0;
        String text = flag ? this.textWithDetails : this.textWithoutDetails;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\n' && c != '\r') continue;
            ++lines;
            if (i - lineBegin > longestLine) {
                longestLine = i - lineBegin;
            }
            lineBegin = i;
        }
        longestLine += 2;
        if (lines < 5) {
            lines = 5;
        }
        if (lines > 15) {
            lines = 15;
        }
        if (longestLine > 70) {
            longestLine = 70;
        }
        ((RuntimeErrorDialog)dialog).doShow(this.title, text, lines, longestLine);
    }
}

