/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.nlogo.api.LogoException;
import org.nlogo.awt.Utils;
import org.nlogo.util.Exceptions;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Slider;
import org.nlogo.window.SliderPainter;

public strictfp class SliderHorizontalPainter
extends SliderPainter
implements MouseWheelListener {
    private final Slider slider;
    protected final Handle handle = new Handle();
    protected final Channel channel = new Channel();

    public SliderHorizontalPainter(Slider slider) {
        this.slider = slider;
        if (slider.painter == null) {
            slider.setOpaque(true);
            slider.setLayout(null);
            slider.setBackground(InterfaceColors.SLIDER_BACKGROUND);
            Utils.adjustDefaultFont(slider);
        }
        slider.add(this.handle);
        slider.add(this.channel);
        slider.addMouseWheelListener(this);
    }

    public void dettach() {
        this.slider.remove(this.handle);
        this.slider.remove(this.channel);
        this.slider.removeMouseWheelListener(this);
    }

    public Dimension getMinimumSize() {
        if (this.slider.getBorder() != null) {
            return new Dimension(92, 33);
        }
        return new Dimension(30, 14);
    }

    public Dimension getPreferredSize(Font font) {
        int width = 0;
        FontMetrics metrics = this.slider.getFontMetrics(font);
        width = this.maxValueWidth(metrics) + metrics.stringWidth(this.slider.name) + 2 + 1 + 23;
        return new Dimension(StrictMath.max(width, 150), 33);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 33);
    }

    private int maxValueWidth(FontMetrics metrics) {
        int result = metrics.stringWidth(this.slider.valueString(this.slider.minimum));
        result = StrictMath.max(result, metrics.stringWidth(this.slider.valueString(this.slider.maximum)));
        result = StrictMath.max(result, metrics.stringWidth(this.slider.valueString(this.slider.minimum + this.slider.increment)));
        result = StrictMath.max(result, metrics.stringWidth(this.slider.valueString(this.slider.maximum - this.slider.increment)));
        return result;
    }

    public void setToolTipText(String text) {
        this.handle.setToolTipText(text);
        this.channel.setToolTipText(text);
    }

    public void doLayout() {
        float scaleFactor = this.slider.getBorder() != null ? (float)this.slider.getHeight() / 33.0f : (float)this.slider.getHeight() / 18.0f;
        this.handle.setSize((int)(8.0f * scaleFactor), (int)(14.0f * scaleFactor));
        this.handle.setLocation(this.handleXPos(), 2);
        this.channel.setBounds(1, 3, this.slider.getBounds().width - 1 - 2, (int)(12.0f * scaleFactor));
    }

    private int handleXPos() {
        return 7 + (int)StrictMath.round((this.slider.value - this.slider.minimum) / this.scaleFactor()) - this.handle.getBounds().width / 2;
    }

    public void handlePositionChanged(int x, boolean buttonRelease) {
        try {
            double newValue = this.slider.minimum + (double)x * this.scaleFactor();
            this.slider.value(this.slider.coerceValue(newValue), buttonRelease);
        }
        catch (LogoException e) {
            Exceptions.ignore(e);
        }
    }

    public void incrementClick(int x) {
        try {
            Rectangle thisRect = this.channel.getBounds();
            Rectangle handleRect = this.handle.getBounds();
            int center = handleRect.x + this.handle.getBounds().width / 2;
            if (x + thisRect.x > center) {
                this.slider.value(this.slider.coerceValue(this.slider.value + this.slider.increment));
            } else {
                this.slider.value(this.slider.coerceValue(this.slider.value - this.slider.increment));
            }
        }
        catch (LogoException e) {
            Exceptions.ignore(e);
        }
    }

    private double scaleFactor() {
        return (this.slider.maximum() - this.slider.minimum) / (double)(this.slider.getBounds().width - 1 - 2 - 6 - 6);
    }

    public void paintComponent(Graphics g) {
        int padNameHeight = 3;
        int nameXOffset = 10;
        Rectangle rect = this.slider.getBounds();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        if (this.slider.getBorder() != null) {
            g.setColor(this.slider.getForeground());
            String valueString = this.slider.valueString(this.slider.value);
            FontMetrics fontMetrics = g.getFontMetrics();
            int valueWidth = fontMetrics.stringWidth(valueString);
            String shortenedName = Utils.shortenStringToFit(this.slider.name, rect.width - nameXOffset - valueWidth - 2 - 6 - 2, fontMetrics);
            g.setColor(this.slider.getForeground());
            g.drawString(shortenedName, nameXOffset, rect.height - fontMetrics.getMaxDescent() - padNameHeight);
            g.drawString(valueString, rect.width - valueWidth - 2 - 6, rect.height - fontMetrics.getMaxDescent() - padNameHeight);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        try {
            if (e.getWheelRotation() >= 1) {
                this.slider.value(this.slider.coerceValue(this.slider.value - this.slider.increment));
            } else {
                this.slider.value(this.slider.coerceValue(this.slider.value + this.slider.increment));
            }
        }
        catch (LogoException ex) {
            Exceptions.ignore(ex);
        }
    }

    private strictfp class Handle
    extends JPanel {
        Handle() {
            this.setBackground(InterfaceColors.SLIDER_HANDLE);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    new Events.InputBoxLoseFocusEvent().raise(Handle.this);
                }

                public void mouseReleased(MouseEvent e) {
                    Handle.this.changed(e.getX(), true);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent e) {
                    Handle.this.changed(e.getX(), false);
                }
            });
        }

        public Point getToolTipLocation(MouseEvent e) {
            Point loc = SliderHorizontalPainter.this.slider.getToolTipLocation(e);
            if (loc != null) {
                loc = new Point(loc);
                loc.translate(-this.getX(), -this.getY());
            }
            return loc;
        }

        private void changed(int mouseX, boolean buttonReleased) {
            SliderHorizontalPainter.this.handlePositionChanged(mouseX + this.getX() - this.getWidth() / 2, buttonReleased);
        }
    }

    private strictfp class Channel
    extends JComponent {
        Channel() {
            this.setOpaque(false);
            this.setBackground(Utils.mixColors(InterfaceColors.SLIDER_BACKGROUND, Color.BLACK, 0.5));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    new Events.InputBoxLoseFocusEvent().raise(Channel.this);
                    if (!e.isPopupTrigger() && Utils.button1Mask(e)) {
                        SliderHorizontalPainter.this.incrementClick(e.getX());
                    }
                }
            });
        }

        public Point getToolTipLocation(MouseEvent e) {
            Point loc = SliderHorizontalPainter.this.slider.getToolTipLocation(e);
            if (loc != null) {
                loc = new Point(loc);
                loc.translate(-this.getX(), -this.getY());
            }
            return loc;
        }

        public void paintComponent(Graphics g) {
            int x = 6;
            int y = 0;
            int width = this.getWidth() - 6 - 6;
            int height = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRect(x, y, width, height);
            org.nlogo.swing.Utils.createWidgetBorder().paintBorder(this, g, x, y, width, height);
        }
    }
}

